#include <stdio.h>
#include <stdlib.h>
#include <pmdsdk2.h>

// on error, prepend absolute path to files before plugin names
#define SOURCE_PLUGIN "digicam"
#define SOURCE_PARAM ""
#define PROC_PLUGIN "digicamproc"
#define PROC_PARAM ""

char err[128];

int main (int argc, char *argv[])
{
  PMDHandle hnd;
  int res;

  res = pmdOpen (&hnd, SOURCE_PLUGIN, SOURCE_PARAM, PROC_PLUGIN, PROC_PARAM);
  if (res != PMD_OK)
    {
      pmdGetLastError (0, err, 128);
      fprintf (stderr, "Could not connect: %s\n", err);
      return 1;
    }

  printf("opened sensor\n");  

  res = pmdUpdate (hnd);
  if (res != PMD_OK)
    {
      pmdGetLastError (hnd, err, 128);
      fprintf (stderr, "Could not transfer data: %s\n", err);
      pmdClose (hnd);
      return 1;
    }

  printf("acquired image\n");  

  PMDDataDescription dd;

  res = pmdGetSourceDataDescription (hnd, &dd);
  if (res != PMD_OK)
    {
      pmdGetLastError (hnd, err, 128);
      fprintf (stderr, "Could not get data description: %s\n", err);
      pmdClose (hnd);
      return 1;
    }

  printf("retrieved source data description\n");  

  if (dd.subHeaderType != PMD_IMAGE_DATA)
    {
      fprintf (stderr, "Source data is not an image!\n");
      pmdClose (hnd);
      return 1;
    }

  float * dist = new float [dd.img.numRows * dd.img.numColumns];

  res = pmdGetDistances (hnd, dist, dd.img.numColumns * dd.img.numRows * sizeof (float));
  if (res != PMD_OK)
    {
      pmdGetLastError (hnd, err, 128);
      fprintf (stderr, "Could not get distances: %s\n", err);
      pmdClose (hnd);
      return 1;
    }

  unsigned int * flags = new unsigned int [dd.img.numRows * dd.img.numColumns];

  res = pmdGetFlags (hnd, flags, dd.img.numColumns * dd.img.numRows * sizeof (unsigned int));
  if (res != PMD_OK)
    {
      pmdGetLastError (hnd, err, 128);
      fprintf (stderr, "Could not get flags: %s\n", err);
      pmdClose (hnd);
      return 1;
    }

  for (unsigned int i=0; i < dd.img.numRows; i++) {
    for (unsigned int j=0; j < dd.img.numColumns; j++) {
      printf ("%x ", flags[i * dd.img.numRows + j]);
    }
    printf ("\n");
  }
  //printf ("Middle distance: %f m\n", dist[(dd.img.numRows / 2) * dd.img.numColumns + dd.img.numColumns / 2]);

  system("PAUSE");
  pmdClose (hnd);

  return 0;
}


