%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: exampleFlagsUSB.m                                                 %
%                                                                         %
% brief: This is an example for getting a distance, amplitude and flags   %
% stream.                                                                 %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2015 Bluetechnix Group GmbH                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.frameMode = 2;
configStruct.serialNumber = 0;

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end

% set framerate to 20 (for limiting the workload)
status = BTAsetFrameRate(deviceHandle, 20);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAsetFrameRate failed. See "status" for error description');
end

%wait some time that the changes take effect
pause(3); 
       
% get one frame
[status, frameHandle, frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAgetFrame failed. See "status" for error description');
end

% get distance data
[status, distData, integrationTime, modulationFrequency, unit] = BTAgetDistances(frameHandle);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetDistances failed. See "status" for error description');
end

% get amplitude data
[status, ampData, integrationTime2, modulationFrequency2, unit2] = BTAgetAmplitudes(frameHandle);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetAmplitudes failed. See "status" for error description');
end

% get flags
[status, flags, integrationTime, modulationFrequency, unit] = BTAgetFlags(frameHandle);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAget2DData failed. See "status" for error description');
end

% free frame
[status] = BTAfreeFrame(frameHandle);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAfreeFrame failed. See "status" for error description');
end


%create window for distances
figure('name','Distance data');
set(gcf,'NumberTitle','off')
%set color range from 0 to 3
clims  = [0 3];
hDist = imagesc(distData, clims);
colorbar;
cm=flipud(jet);
colormap(cm);
global MK;
MK=0;
set(gcf,'KeyPressFcn','MK=1;');

%create window for amplitudes 
figure('name','Amplitude data');
set(gcf,'NumberTitle','off')
%set color range from 0 to 3000 
clims  = [0 3000];
hAmp=imagesc(ampData, clims);
colorbar;
colormap('GRAY');
global MK2;
MK2=0;
set(gcf,'KeyPressFcn','MK2=1;');

%create window for flags 
figure('name','Flags');
set(gcf,'NumberTitle','off')
%set color range from 0 to 32 
clims  = [0 32];
hFlags=imagesc(flags, clims);
colorbar;
colormap('GRAY');
global MK3;
MK3=0;
set(gcf,'KeyPressFcn','MK3=1;');

ampWindowIsclosed = 0;
distWindowIsclosed = 0;
flagsWindowIsclosed = 0;
%loop 
while ~MK && ~MK2 && ~MK3 &&~(ampWindowIsclosed && distWindowIsclosed && flagsWindowIsclosed)
    % get one frame
    [status, frameHandle,  frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
    if status == 0
        %get distances
        [status, distData, integrationTime, modulationFrequency, unit] = BTAgetDistances(frameHandle);
        if status == 0
            if ishandle(hDist)
                %display distances
                set(hDist,'CData',distData);
                refreshdata(hDist);
            else
                distWindowIsclosed = 1;
            end
        end
        %get amplitudes
        [status, ampData, integrationTime2, modulationFrequency2, unit2] = BTAgetAmplitudes(frameHandle);
        if status == 0
            if ishandle(hAmp)
                %display amplitudes
                set(hAmp,'CData',ampData);
                refreshdata(hAmp);
            else
                ampWindowIsclosed = 1;   
            end
        end
        %get flags
        [status, flags, integrationTime, modulationFrequency, unit] = BTAgetFlags(frameHandle);
        if status == 0
            if ishandle(hFlags)
                %display flags
                set(hFlags,'CData',flags);
                refreshdata(hFlags);
            else
                flagsWindowIsclosed = 1;
            end
        end
        %free frame
        [status] = BTAfreeFrame(frameHandle);
        if status ~= 0
            error('BTAfreeFrame failed. See "status" for error description');
        end
    end
    pause(0.1); 
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end

close all;
clear all;



