%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: phasesExampleUSB.m                                                %
%                                                                         %
% brief: This is an example for getting an phase value stream.            %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2015 Bluetechnix Group GmbH                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.frameMode = 7;
configStruct.serialNumber = 0;
configStruct.deviceType = 2; %USB generic

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end

% set integration time to 1000
status = BTAsetIntegrationTime(deviceHandle, 1000);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAsetFrameRate failed. See "status" for error description');
end
% set framerate to 20 (for limiting the workload)
status = BTAsetFrameRate(deviceHandle, 20);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAsetFrameRate failed. See "status" for error description');
end

% get one frame
[status, frameHandle, frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAgetFrame failed. See "status" for error description');
end

% get phase data
[status, phase0, phase90, phase180, phase270, integrationTime, modulationFrequency, unit] = BTAgetPhases(frameHandle);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetPhases failed. See "status" for error description');
end

% free frame
[status] = BTAfreeFrame(frameHandle);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAfreeFrame failed. See "status" for error description');
end

%create window for P0
figure('name','P0');
set(gcf,'NumberTitle','off')
%set color range from -5000 to 5000
clims  = [-5000 5000];
hP0 = imagesc(phase0, clims);
colorbar;
colormap('GRAY');
global MK;
MK=0;
set(gcf,'KeyPressFcn','MK=1;');

%create window for P90 
figure('name','P90');
set(gcf,'NumberTitle','off')
%set color range from -5000 to 5000 
clims  = [-5000 5000];
hP90=imagesc(phase90, clims);
colorbar;
colormap('GRAY');
global MK2;
MK2=0;
set(gcf,'KeyPressFcn','MK2=1;');

%create window for P180 
figure('name','P180');
set(gcf,'NumberTitle','off')
%set color range from -5000 to 5000 
clims  = [-5000 5000];
hP180=imagesc(phase180, clims);
colorbar;
colormap('GRAY');
global MK3;
MK3=0;
set(gcf,'KeyPressFcn','MK3=1;');

%create window for P270 
figure('name','P270');
set(gcf,'NumberTitle','off')
%set color range from -5000 to 5000 
clims  = [-5000 5000];
hP270=imagesc(phase270, clims);
colorbar;
colormap('GRAY');
global MK4;
MK4=0;
set(gcf,'KeyPressFcn','MK4=1;');

P0WindowIsclosed = 0;
P90WindowIsclosed = 0;
P180WindowIsclosed = 0;
P270WindowIsclosed = 0;
%loop 
while ~MK && ~MK2 && ~MK3 && ~MK4 &&~(P0WindowIsclosed && P90WindowIsclosed && P180WindowIsclosed && P270WindowIsclosed)
    % get one frame
    [status, frameHandle,  frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
    if status == 0
        %get P0
        [status, phase0, phase90, phase180, phase270, integrationTime, modulationFrequency, unit] = BTAgetPhases(frameHandle);
        if status == 0
            if ishandle(hP0)
                %display P0
                set(hP0,'CData',phase0);
                refreshdata(hP0);
            else
                P0WindowIsclosed = 1;
            end
            if ishandle(hP90)
                %display P90
                set(hP90,'CData',phase90);
                refreshdata(hP90);
            else
                P90WindowIsclosed = 1;   
            end
            if ishandle(hP180)
                %display P180
                set(hP180,'CData',phase180);
                refreshdata(hP180);
            else
                P180WindowIsclosed = 1;
            end
            if ishandle(hP270)
                %display P270
                set(hP270,'CData',phase270);
                refreshdata(hP270);
            else
                P270WindowIsclosed = 1;   
            end
        end
          
        %free frame
        [status] = BTAfreeFrame(frameHandle);
        if status ~= 0
            error('BTAfreeFrame failed. See "status" for error description');
        end
    end
    pause(0.1); 
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end

close all;
clear all;


