% This is a example for replaying 100 frames stored in a file.

N=100;
frameTime = 0.5;


load('FrameBuffer');

%create window for distances
figure('name','Distance data');
set(gcf,'NumberTitle','off')
%set color range from 0 to 3000
clims  = [0 3000];
hDist = imagesc(squeeze(FrameBuffer(1,:,:)), clims);
colorbar;
cm=flipud(jet);
colormap(cm);

for i = 1 : N
    %display distances
    set(hDist,'CData',squeeze(FrameBuffer(i,:,:)));
    refreshdata(hDist);
    pause(frameTime);
end
    
clear all;
close all;