#include <stdio.h>
#include <bta.h>


int main() {
    BTA_Config config;
    printf("BTAinitConfig()\n");
    BTAinitConfig(&config);
    uint8_t udpDataIpAddr[] = { 224, 0, 0, 1 };
    config.udpDataIpAddr = udpDataIpAddr;
    config.udpDataIpAddrLen = 4;
    config.udpDataPort = 10002;
    uint8_t tcpDeviceIpAddr[] = { 192, 168, 0, 10 };
    config.tcpDeviceIpAddr = tcpDeviceIpAddr;
    config.tcpDeviceIpAddrLen = 4;
    config.tcpControlPort = 10001;
    config.frameQueueMode = BTA_QueueModeDropOldest;
    config.frameQueueLength = 1;
    config.frameMode = BTA_FrameModeDistAmpFlags;

    
    BTA_Status status;
    BTA_Handle btaHandle;
    printf("BTAopen()\n");
    status = BTAopen(&config, &btaHandle);
    if (status != BTA_StatusOk) {
        return -1;
    }
    
    // Actively get a frame
    BTA_Frame *frame;
    printf("BTAgetFrame()\n");
    status = BTAgetFrame(btaHandle, &frame, 3000);
    if (status != BTA_StatusOk) {
        return -1;
    }
    
    uint16_t *distances;
    BTA_DataFormat dataFormat;
    BTA_Unit unit;
    uint16_t xRes, yRes;
    printf("BTAgetDistances()\n");
    status = BTAgetDistances(frame, (void **)&distances, &dataFormat, &unit, &xRes, &yRes);
    if (status == BTA_StatusOk) {
        if (dataFormat == BTA_DataFormatUInt16) {
            if (unit == BTA_UnitMillimeter) {
                printf("Got distance data\n");
                // as expected -> process amplitude data: amplitudes[i]
            }
        }
    }
    
    uint16_t *amplitudes;
    printf("BTAgetAmplitudes()\n");
    status = BTAgetAmplitudes(frame, (void **)&amplitudes, &dataFormat, &unit, &xRes, &yRes);
    if (status == BTA_StatusOk) {
        if (dataFormat == BTA_DataFormatUInt16) {
            if (unit == BTA_UnitUnitLess) {
                printf("Got amplitude data\n");
                // as expected -> process amplitude data: amplitudes[i]
            }
        }
    }    
    printf("BTAfreeFrame()\n");
    BTAfreeFrame(&frame);
    printf("BTAclose()\n");
    BTAclose(&btaHandle);
    printf("Hit <Return> to end the example\n");
    fgetc(stdin);
}
