#ifndef BTA_FLASH_UPDATE_H_INCLUDED
#define BTA_FLASH_UPDATE_H_INCLUDED

#include <stdint.h>

typedef enum {
    BTA_FlashTargetBootloader,
    BTA_FlashTargetApplication,
    BTA_FlashTargetGeneric,
    BTA_FlashTargetPixelList,
    BTA_FlashTargetLensCalibration,
    BTA_FlashTargetOtp
} BTA_FlashTarget;


typedef enum {
    BTA_FlashIdSpi,
    BTA_FlashIdParallel,
    BTA_FlashIdEmmc,
    BTA_FlashIdSd,
    BTA_FlashIdTim,
    BTA_FlashIdLim
} BTA_FlashId;

typedef struct {
    BTA_FlashTarget target;         //<<< Type of update, indicating the target where to copy the data to
    BTA_FlashId flashId;            //<<< Parameter to distinguish between different flash modules on the device
    uint32_t address;               //<<< Address within the flash memory
    uint8_t *data;                  //<<< Data to be flashed
    uint32_t dataLen;               //<<< Size of data in bytes
} BTA_FlashUpdateConfig;

#endif
