/**  @file bta_eth_example_minimal.cpp
*    @version 1.0.0
*  
*    @brief This example shows the minimum functionalities of the SDK
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <stdio.h>
#include <stdlib.h>
#include <bta.h>


int main() {
    BTA_Status status;
    BTA_Config config;
    uint16_t statusStringLen = 50;
    char *statusString = (char *)malloc(statusStringLen);
    
    // The config struct must be initialized.
    printf("BTAinitConfig()\n");
    status = BTAinitConfig(&config);
    if (status != BTA_StatusOk) {
        printf("error: %d\n", status);
        return -1;
    }
    // Ethernet devices need connection information.
    uint8_t udpDataIpAddr[] = { 224, 0, 0, 1 };
    config.udpDataIpAddr = udpDataIpAddr;
    config.udpDataIpAddrLen = 4;
    config.udpDataPort = 10002;
    uint8_t tcpDeviceIpAddr[] = { 192, 168, 0, 10 };
    config.tcpDeviceIpAddr = tcpDeviceIpAddr;
    config.tcpDeviceIpAddrLen = 4;
    config.tcpControlPort = 10001;
    // Choose whether and how queueing of frames is done.
    config.frameQueueMode = BTA_QueueModeDropOldest;
    // Set the length of the frame queue.
    config.frameQueueLength = 1;
    // Select the frame mode to fit your needs.
    config.frameMode = BTA_FrameModeDistAmp;

    
    BTA_Handle btaHandle;
    printf("BTAopen()\n");
    status = BTAopen(&config, &btaHandle);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    
    // Actively get a frame
    BTA_Frame *frame;
    printf("BTAgetFrame()\n");
    status = BTAgetFrame(btaHandle, &frame, 3000);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    
    uint16_t *distances;
    BTA_DataFormat dataFormat;
    BTA_Unit unit;
    uint16_t xRes, yRes;
    printf("BTAgetDistances()\n");
    status = BTAgetDistances(frame, (void **)&distances, &dataFormat, &unit, &xRes, &yRes);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    if (dataFormat == BTA_DataFormatUInt16) {
        if (unit == BTA_UnitMillimeter) {
            printf("Got distance data\n");
            // as expected -> process amplitude data: amplitudes[i]
        }
    }
    
    uint16_t *amplitudes;
    printf("BTAgetAmplitudes()\n");
    status = BTAgetAmplitudes(frame, (void **)&amplitudes, &dataFormat, &unit, &xRes, &yRes);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    if (dataFormat == BTA_DataFormatUInt16) {
        if (unit == BTA_UnitUnitLess) {
            printf("Got amplitude data\n");
            // as expected -> process amplitude data: amplitudes[i]
        }
    }
    printf("BTAfreeFrame()\n");
    status = BTAfreeFrame(&frame);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    printf("BTAclose()\n");
    status = BTAclose(&btaHandle);
    if (status != BTA_StatusOk) {
        BTAstatusToString(status, statusString, 50);
        printf("error: %d\n", statusString);
        return -1;
    }
    printf("Hit <Return> to end the example\n");
    fgetc(stdin);
}
