/**  @file bta_combine.h
*
*    @brief This file implements combining channels into one
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_COMBINE_H_INCLUDED
#define BTA_COMBINE_H_INCLUDED


typedef struct BTA_FltCombineInst {
	BTA_ChannelId channelToProcess;
    uint8_t removeOriginals;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltCombineInst;


BTA_Status BFLTcombineInit(BTA_FltCombineConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTcombineClose(BTA_FltHandle *handle);
BTA_Status BFLTcombineApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
