/**  @file bta_gaussian_blur.c
*
*    @brief This file implements the filter (see header)
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/


#include "bta_gaussian_blur.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef BTA_EXCLUDE_FILTERS

#include <bta_opencv_helper.h>



BTA_Status BFLTgaussianBlurInit(BTA_FltGaussianBlurConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst) {
    if (!handle || !config) {
        return BTA_StatusInvalidParameter;
    }
    *handle = 0;
    BTA_FltGaussianBlurInst *inst = (BTA_FltGaussianBlurInst *)calloc(1, sizeof(BTA_FltGaussianBlurInst));
    if (!inst) {
        return BTA_StatusOutOfMemory;
    }
	inst->channelToProcess = config->channelToProcess;
	inst->channelIdResult = config->channelIdResult;
    inst->infoEventInst = infoEventInst;
    *handle = inst;
    return BTA_StatusOk;
}


BTA_Status BFLTgaussianBlurClose(BTA_FltHandle *handle) {
    BTA_FltGaussianBlurInst **inst = (BTA_FltGaussianBlurInst **)handle;
    free(*inst);
    *inst = 0;
    return BTA_StatusOk;
}


BTA_Status BFLTgaussianBlurApply(BTA_FltHandle handle, BTA_Frame **frame) {
    BTA_FltGaussianBlurInst *inst = (BTA_FltGaussianBlurInst *)handle;
    if (!inst || !frame) {
        return BTA_StatusInvalidParameter;
    }
    if (!*frame) {
        return BTA_StatusInvalidParameter;
    }

	int chInd;
	int chCount = (*frame)->channelsLen;
	for (chInd = 0; chInd < chCount; chInd++) {
		BTA_Channel *channel = (*frame)->channels[chInd];
		if (!inst->channelToProcess || channel->id == inst->channelToProcess) {
            cv::Mat mat = BTAtoMat(channel);
            cv::Mat matBlurred;
            cv::GaussianBlur(mat, matBlurred, cv::Size(3, 3), 1.5);
			if (inst->channelIdResult) {
				BTAinsertChannelIntoFrame(*frame, BTAtoChannel(inst->channelIdResult, channel->unit, channel->integrationTime, channel->modulationFrequency, matBlurred));
			}
			else {
                BTAinsertChannelIntoFrame(*frame, BTAtoChannel(channel->id, channel->unit, channel->integrationTime, channel->modulationFrequency, matBlurred));
                BTAremoveChannelFromFrame(*frame, channel);
			}
		}
	}
	return BTA_StatusOk;
}
#endif
