/**  @file bta_morphology.c
*  
*    @brief This file implements some morphology filters
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS


#ifndef BTA_MORPHOLOGY_H_INCLUDED
#define BTA_MORPHOLOGY_H_INCLUDED


typedef struct BTA_FltMorphologyInst {
    BTA_FltMorphologyType morphologyType;
    uint8_t *mask;
    uint8_t xRes;
    uint8_t yRes;
    BTA_ChannelId channelToProcess;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltMorphologyInst;


BTA_Status BFLTmorphologyInit(BTA_FltMorphologyConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTmorphologyClose(BTA_FltHandle *handle);
BTA_Status BFLTmorphologyApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
