/**  @file bta_combine.c
*
*    @brief This file implements the filter (see header)
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/


#include "bta_combine.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef BTA_EXCLUDE_FILTERS



BTA_Status BFLTcombineInit(BTA_FltCombineConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst) {
    if (!handle || !config) {
        return BTA_StatusInvalidParameter;
    }
    *handle = 0;
    BTA_FltCombineInst *inst = (BTA_FltCombineInst *)calloc(1, sizeof(BTA_FltCombineInst));
    if (!inst) {
        return BTA_StatusOutOfMemory;
    }
	inst->channelToProcess = config->channelToProcess;
    inst->removeOriginals = config->removeOriginals;
    inst->infoEventInst = infoEventInst;
    *handle = inst;
    return BTA_StatusOk;
}


BTA_Status BFLTcombineClose(BTA_FltHandle *handle) {
    BTA_FltCombineInst **inst = (BTA_FltCombineInst **)handle;
    free(*inst);
    *inst = 0;
    return BTA_StatusOk;
}


BTA_Status BFLTcombineApply(BTA_FltHandle handle, BTA_Frame **frame) {
    BTA_FltCombineInst *inst = (BTA_FltCombineInst *)handle;
    if (!inst || !frame) {
        return BTA_StatusInvalidParameter;
    }
    if (!*frame) {
        return BTA_StatusInvalidParameter;
    }

	int chInd;
	int chCount = (*frame)->channelsLen;
    BTA_Channel *channelRef = 0;
    int resultCount = 0;
	for (chInd = 0; chInd < chCount; chInd++) {
        BTA_Channel *channel = (*frame)->channels[chInd];
		if (!inst->channelToProcess || channel->id == inst->channelToProcess) {
            if (!channelRef) {
                channelRef = (*frame)->channels[chInd];
            }
            resultCount++;
		}
	}
    if (!channelRef) {
        BTAinfoEventHelper(inst->infoEventInst, 3, BTA_StatusNotSupported, "BFLTcombineApply: no channel match", 0);
        return BTA_StatusOk;
    }
    uint8_t bytesPerPixel = channelRef->dataFormat & 0xf;
    if (!bytesPerPixel) {
        // not supported, do nothing
        BTAinfoEventHelper(inst->infoEventInst, 3, BTA_StatusNotSupported, "BFLTcombineApply: unsupported data format", 0);
        return BTA_StatusOk;
    }
    uint8_t *dataNew = (uint8_t *)malloc(channelRef->dataLen * resultCount);
    BTA_Channel **channelsToRemove = (BTA_Channel **)malloc(resultCount * sizeof(BTA_Channel *));
    int channelsToRemoveInd = 0;
    int xy = 0;
    int y;
    for (y = 0; y < channelRef->yRes; y++) {
        for (chInd = 0; chInd < chCount; chInd++) {
            BTA_Channel *channel = (*frame)->channels[chInd];
            if (channel->id == channelRef->id &&
                channel->dataFormat == channelRef->dataFormat &&
                channel->xRes == channelRef->xRes &&
                channel->yRes == channelRef->yRes &&
                channel->dataLen == channelRef->dataLen &&
                channel->unit == channelRef->unit) {
                channelsToRemove[channelsToRemoveInd++] = channel;
                int x;
                for (x = 0; x < channelRef->xRes; x++) {
                    int i;
                    for (i = 0; i < bytesPerPixel; i++) {
                        dataNew[xy++] = channel->data[bytesPerPixel * (x + y * channel->xRes) + i];
                    }
                }
                // TODO: metadata 
            }
        }
    }
    BTAinsertChannelDataIntoFrame(*frame, channelRef->id, xy / bytesPerPixel / channelRef->yRes, channelRef->yRes, channelRef->dataFormat, channelRef->unit, channelRef->integrationTime, channelRef->modulationFrequency, dataNew, xy);
    if (inst->removeOriginals) {
        for (chInd = 0; chInd < channelsToRemoveInd; chInd++) {
            BTAremoveChannelFromFrame(*frame, channelsToRemove[chInd]);
        }
    }
	return BTA_StatusOk;
}
#endif
