/**  @file bta_dct.h
*
*    @brief This filter computes the DCT
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_DCT_H_INCLUDED
#define BTA_DCT_H_INCLUDED


typedef struct BTA_FltDctInst {
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    float result0;
    float result1;
    float result2;
    float result3;
    float result4;
    float result5;
    float result6;
    float result7;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltDctInst;


BTA_Status BFLTdctInit(BTA_FltDctConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTdctClose(BTA_FltHandle *handle);
BTA_Status BFLTdctApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif