/**  @file bta_avg_sequences.c
*
*    @brief This file implements the averaging of matching frames
*           Two frames are averaged if their delta frameCounter and delta sequenceCounter are equal.
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_AVG_SEQUENCES_H_INCLUDED
#define BTA_AVG_SEQUENCES_H_INCLUDED


typedef struct BTA_FltAvgSequencesInst {
    uint16_t averageWindowLength;
    BTA_Frame *frameAvg;
    BTA_Frame **frames;
    uint32_t framesPos;
    uint32_t frameCounter;
    uint32_t frameCounterLast;
    uint32_t frameCounterDiff;
    uint32_t sequenceCounter;
    uint32_t sequenceCounterLast;
    uint32_t sequenceCounterDiff;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltAvgSequencesInst;


BTA_Status BFLTavgSequencesInit(BTA_FltAvgSequencesConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTavgSequencesClose(BTA_FltHandle *handle);
BTA_Status BFLTavgSequencesApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
