/**  @file bta_crop.h
*
*    @brief This file implements cropping of (a) channels to ROI
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_CROP_H_INCLUDED
#define BTA_CROP_H_INCLUDED


typedef struct BTA_FltCropInst {
	BTA_ChannelId channelToProcess;
	float roiStartX;
    float roiStartY;
    float roiEndX;
    float roiEndY;
	BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltCropInst;


BTA_Status BFLTcropInit(BTA_FltCropConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTcropClose(BTA_FltHandle *handle);
BTA_Status BFLTcropApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
