/**  @file bta_laplace.h
*
*    @brief This filter applies a laplace operator
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_LAPLACE_H_INCLUDED
#define BTA_LAPLACE_H_INCLUDED


typedef struct BTA_FltLaplaceInst {
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltLaplaceInst;


BTA_Status BFLTlaplaceInit(BTA_FltLaplaceConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTlaplaceClose(BTA_FltHandle *handle);
BTA_Status BFLTlaplaceApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif