
from enum import Enum

class BtaDiscoveryConfig(Structure):
    _fields_ = [
        ("deviceType", c_uint32),  # A special device type to look for, 0: Any
        ("broadcastIpAddr", POINTER(c_uint8)),  # The UDP broadcast IP address, null: 255.255.255.255
        ("broadcastIpAddrLen", c_uint8),  # The length in bytes of broadcastIpAddr
        ("broadcastPort", c_uint16),  # The UDP port to send the broadcast to, 0: 11003
        ("callbackIpAddr", POINTER(c_uint8)),  # The UDP callback IP address, null: chosen automatically
        ("callbackIpAddrLen", c_uint8),  # The length in bytes of callbackIpAddr
        ("callbackPort", c_uint16),  # The UDP port to listen for responses, 0: chosen automatically
        ("uartPortName", c_char_p),  # The port name of the UART to use (ASCII coded)
        ("uartBaudRate", c_int32),  # The UART baud rate
        ("uartDataBits", c_uint8),  # The number of UART data bits used
        ("uartStopBits", c_uint8),  # 0: None, 1: One, 2: Two, 3: 1.5 stop bits
        ("uartParity", c_uint8),  # 0: None, 1: Odd, 2: Even, 3: Mark, 4: Space Parity
        ("uartTransmitterAddress", c_uint8)]  # The source address for UART communications


class BtaDeviceInfo(Structure):
    _fields_ = [
        ("deviceType", c_uint32),  # Two-byte-id for a device or module (independent of hardware and software versions)
        ("productOrderNumber", c_char_p),
        # String containing the PON (not including the serial number) (unique in combination with serial number)
        ("serialNumber", c_uint32),  # Serial number (unique in combination with PON)
        ("firmwareVersionMajor", c_uint32),  # Firmware version major
        ("firmwareVersionMinor", c_uint32),  # Firmware version minor
        ("firmwareVersionNonFunc", c_uint32),  # Firmware version non functional
        ("mode0", c_uint32),  # The content of the device's primary mode register
        ("status", c_uint32),  # The content of the device's status register
        ("uptime", c_uint32),  # The content of the device's uptime register
        ("deviceMacAddr", POINTER(c_uint8)),  # The MAC address of the device
        ("deviceMacAddrLen", c_uint32),  # The length in bytes of deviceMacAddr
        ("deviceIpAddr", POINTER(c_uint8)),  # The IP address of the device
        ("deviceIpAddrLen", c_uint32),  # The length in bytes of deviceIpAddr
        ("subnetMask", POINTER(c_uint8)),  # The subnet IP address of the device
        ("subnetMaskLen", c_uint32),  # The length in bytes of subnetMask
        ("gatewayIpAddr", POINTER(c_uint8)),  # The gateway IP address of the device
        ("gatewayIpAddrLen", c_uint32),  # The length in bytes of gatewayIpAddr
        ("tcpControlPort", c_uint16),  # The TCP port of the control interface
        ("tcpDataPort", c_uint16),  # The TCP port of the data interface
        ("udpDataIpAddr", POINTER(c_uint8)),  # The IP destination address of the UDP data stream
        ("udpDataIpAddrLen", c_uint32),  # The length in bytes of udpDataIpAddr
        ("udpDataPort", c_uint16),  # The UDP port of the data interface
        ("udpControlPort", c_uint16)  # The UDP port of the control interface
    ]
