
from enum import IntEnum

class PyBtaStatus(IntEnum):
    Ok = 0                        # Everything went ok
    InvalidParameter = -32768     # At least one parameter passed is invalid or out of valid range
                                            # The combination of parameters is contradictory or incomplete
                                            # The provided frame does not contain the channel(s) expected
    IllegalOperation = -32767     # The data requested by the user cannot be read / written because it does not exist or is not accessible in the current configuration / state
                                            # The modulation frequency to be set or currently configured is not supported
                                            # BTAclose was already called
    TimeOut = -32766				# Within the waiting period a necessary condition was not met = -32767 so the operation had to be aborted
                                            # After trying repeatedly the operation did not succeed
    DeviceUnreachable = -32765    # The connection to the device could not be established
                                            # An error occurred during communication
                                            # The device with the specified attributes could not be found
    NotConnected = -32764         # The operation cannot be executed because the connection is down
    InvalidVersion = -32763       #
    RuntimeError = -32762         # A system resource (mutex, semaphore, thread, file) could not be created / initialized / read / written
                                            # The ToF device did not react as expected
    OutOfMemory = -32761          # A malloc, realloc or calloc failed to reserve the needed memory
                                            # The buffer provided by the caller is not large enough
                                            # The end of the file was reached
    NotSupported = -32760         # The function is not supported by this device/firmware
                                            #
    CrcError = -32759             # The cyclic redundancy check revealed that the data in question must be corrupt
    Unknown = -32758

    # These status are used only in infoEvent callbacks, it is merely a placeholder rather than a state
    Information = 1               # The infoEvent message contains the actual information
    Warning = 2                   # The infoEvent message describes the cause of the warning