/**
*   @file           buffer_management.h
*   @ingroup 
*   
*   @brief 
*   
*   BLT_DISCLAIMER
*   
*   @author     Alexander Froemel
*   @version    1.0.0.0
*   @date       28.03.2013
*   
*   @cond svn
*   
*   Information of last commit
*   $Rev::               $:  Revision of last commit
*   $Author::            $:  Author of last commit
*   $Date::              $:  Date of last commit
*   
*   @endcond
**/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#ifndef _BUFFER_MANAGEMENT_H_
#define _BUFFER_MANAGEMENT_H_

#include "datatypes.h"
/*****************************************************************
* Error codes                                                    *
******************************************************************/
#define ERR_BMT_NOT_ENOUGH_MEMORY               (ERR_GENERIC - 10)
#define ERR_BMT_INVALID_HANDLE                  (ERR_GENERIC - 11)
#define ERR_BMT_TOO_MANY_CLIENTS                (ERR_GENERIC - 12)
#define ERR_BMT_BUFFER_FULL                     (ERR_GENERIC - 13)
#define ERR_BMT_BUFFER_EMPTY                    (ERR_GENERIC - 14)
// ***************************************************************

typedef unsigned long T_BMT_MNGR_HANDLE;
typedef unsigned long T_BMT_CLIENT_HANDLE;

typedef struct {
    unsigned char *pucBuf;
    unsigned long ulCurrSize;
    unsigned long ulCopyOffsetInBuffer;
    void *pArg;
} T_BMT_BUFFER_DESC;


typedef struct {
    unsigned long ulMaxNofClients;
    unsigned char ucInstHeapNr;
} T_BMT_MNGR_CONFIG;


typedef struct {
    unsigned long ulMaxNofClients;
    unsigned long ulNofClients;
    unsigned char ucInstHeapNr;
    T_BMT_CLIENT_HANDLE *ptClients;
    T_BMT_CLIENT_HANDLE tLastRequestedEnqueueBufferClient;
    volatile bool bLocked;
} T_BMT_MNGR_INST;


typedef struct {
    unsigned char ucInstHeapNr;
    unsigned char ucBufferHeapnr;
    bool bBufferProvidedExtern;
    T_BMT_BUFFER_DESC *tBufferList;
    unsigned long ulNofBuffers;
    unsigned long ulSizePerBuffer;
//    bool bDMAcopy;                                  // not supported
//    unsigned char ucMDMAchannel;
    unsigned long ulCopyOffsetInBuffer;
} T_BMT_CLIENT_CONFIG;


typedef struct {
    unsigned char ucInstHeapNr;
    unsigned char ucBufferHeapnr;
    bool bBufferProvidedExtern;
    T_BMT_BUFFER_DESC *tBufferList;
    unsigned long ulNofBuffers;
    unsigned long ulSizePerBuffer;
//    unsigned char ucMDMAchannel;
//    bool bDMAcopy;
    unsigned long ulCopyOffsetInBuffer;
    T_BMT_MNGR_HANDLE ptMngr;
    unsigned long ulCurrIn;
    unsigned long ulCurrOut;
    unsigned long ulFillSize;
} T_BMT_CLIENT_INST;

/*****************************************************************************
* PROTOTYPE DECLARATIIONS                                                    *
*****************************************************************************/

void BMTsetup(void);
void BMTcleanup(void);

T_ERROR_CODE        BMTinitConfigMngr(T_BMT_MNGR_CONFIG *pa_ptConf);
T_BMT_MNGR_HANDLE   BMTopen(T_BMT_MNGR_CONFIG *pa_ptConfig, T_ERROR_CODE *pa_ptErr);
T_ERROR_CODE        BMTclose(T_BMT_MNGR_HANDLE pa_tHndl);

T_ERROR_CODE        BMTinitConfigClient(T_BMT_CLIENT_CONFIG *pa_ptConf);
T_BMT_CLIENT_HANDLE BMTaddClient(T_BMT_MNGR_HANDLE pa_tMngrHndl, T_BMT_CLIENT_CONFIG *pa_ptConfig, T_ERROR_CODE *pa_ptErr);
T_ERROR_CODE        BMTremoveClient(T_BMT_CLIENT_HANDLE pa_tHndl);

T_ERROR_CODE        BMTgetNextEnqueueBuffer(T_BMT_MNGR_HANDLE pa_tHndl, T_BMT_BUFFER_DESC **pa_ptBuffer);
T_ERROR_CODE        BMTbufferProcessed(T_BMT_MNGR_HANDLE pa_tHndl);

T_ERROR_CODE        BMTenqueue(T_BMT_MNGR_HANDLE pa_tHndl, unsigned char *pa_pucBuffer, unsigned long pa_ulBufferLength, void *pa_pArg, unsigned long pa_ulFlags);

/**     @brief Requests data from the queue
*       @param pa_tHndl The handle of the buffer manager
*       @param pa_ptBuffer Result: The data buffer (is succeded)
*       @return Error code (ERR_BMT_INVALID_HANDLE, ERR_BMT_BUFFER_EMPTY) or ERR_NONE                                      */
T_ERROR_CODE        BMTdequeue(T_BMT_CLIENT_HANDLE pa_tHndl, T_BMT_BUFFER_DESC **pa_ptBuffer);

/**     @brief Marks the last item in the queue as processed, so it can be discarded
*       In the general case this last item was previously requested with BMTdequeue and processed 
*       @param pa_tHndl The handle of the buffer manager
*       @return Error code (ERR_BMT_INVALID_HANDLE, ERR_BMT_BUFFER_EMPTY) or ERR_NONE                                      */
T_ERROR_CODE        BMTdequeueProcessed(T_BMT_CLIENT_HANDLE pa_tHndl);

T_ERROR_CODE        BMTdequeueProcessedFromInterrupt(T_BMT_CLIENT_HANDLE pa_tHndl);

/**     @brief Flushes the queue, marks all items as processed
*       @param pa_tHndl The handle of the buffer manager
*       @return Error code Error code (ERR_BMT_INVALID_HANDLE) or ERR_NONE                                      */
T_ERROR_CODE        BMTflushClient(T_BMT_CLIENT_HANDLE pa_tHndl);

T_ERROR_CODE        BMTflushAll(T_BMT_MNGR_HANDLE pa_tHndl);


// ****************************************************************

#endif //_BUFFER_MANAGEMENT_H_
