/**
*   @file configuration_interface_reg_access.c
*   @ingroup services
*   
*   @brief This file is a part of the service configuration_interface and has code for the read and write functions, which can be public to, say, core no. 2
*   
*   BLT_DISCLAIMER
*   
*   @author aFro, ROB, Alex Falkensteiner  
*   
*   @cond svn
*   
*   Information of last commit
*   $Rev::               $:  Revision of last commit
*   $Author::            $:  Author of last commit
*   $Date::              $:  Date of last commit
*   
*   @endcond
**/

/**  @defgroup services
*    @ingroup services
*    @brief Hardware independent services
**/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#include "tof_configuration_interface.h"
#include "buffer_management.h"
#include "eth_udp_streaming_thread.h"

volatile char g_bRegAccessLocked = 0;

#ifdef __ADSPBF561__
    volatile T_TCI_HANDLE g_tTCIdefaultHandle;
    volatile T_TCI_INST g_tTCIdefaultInst;
//    static bool s_bTCIdefaultInstInUse = false;
#else
    T_TCI_HANDLE g_tTCIdefaultHandle;
#endif


T_ERROR_CODE TCIregisterWrite(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short pa_usLength) {
    if (!pa_tHndl) {
        pa_tHndl = g_tTCIdefaultHandle;
    }
    T_TCI_INST *pInst = (T_TCI_INST *)pa_tHndl;
    T_ERROR_CODE tErr = ERR_NONE;
#ifdef ROBO_TOF_BOOTLOADER
#ifdef COREB
    unsigned short usLength = pa_usLength & 0xfffe;
#endif
#endif //ROBO_TOF_BOOTLOADER
    int nNofRegs = pa_usLength >> 1;
    
    if (pInst) {
    	if (pa_usRegister <= (T_TCI_REGISTERS_MAX_NOF - nNofRegs)) {
        	// wait while register access is locked and lock register access
        	while (g_bRegAccessLocked);
        		g_bRegAccessLocked = 1;

        	int i;
        	unsigned short *pa_pusBuffer = (unsigned short *)pa_pBuffer;
            for (i = 0; i < nNofRegs; i++) {
                if ((*pInst->ptRegisterList).atRegisterList[pa_usRegister].ulFlags & TCI_REGISTER_FLAG_WRITE_ENABLED) {
		            // register is write accessable
                    (*pInst->ptRegisterList).atRegisterList[pa_usRegister].usRegister = pa_pusBuffer[i];
                    (*pInst->ptRegisterList).atRegisterList[pa_usRegister].ulFlags |= (TCI_REGISTER_FLAG_CHANGED | TCI_REGISTER_FLAG_CHANGED_CORE_B);
		        } else {
		            tErr = ERR_TCI_ILLEGAL_REG_WRITE;
		        }
            	pa_usRegister++;
            }
            
            // unlock register access
            g_bRegAccessLocked = 0;
            
          #ifdef ROBO_TOF_BOOTLOADER
          #ifdef COREB
    	    } else if(pa_usRegister >= T_TCI_REGISTERS_FILE_TRANSFER) {
    	        TFUwrite((unsigned char *)pa_pBuffer, usLength);
          #endif
          #endif //ROBO_TOF_BOOTLOADER
    	} else {
    		tErr = ERR_TCI_ILLEGAL_REG_WRITE;
    	}
    } else {
        tErr = ERR_TCI_INVALID_HANDLE;
    }
    return tErr;
}


T_ERROR_CODE TCIregisterRead(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short *pa_pusLength) {
	if (!pa_tHndl) {
        pa_tHndl = g_tTCIdefaultHandle;
    }
    *pa_pusLength = *pa_pusLength & 0xfffe;				// only a even number of bytes is allowed because registers a 16 bit width
    int nNofRegs = *pa_pusLength >> 1;
    T_TCI_INST *pInst = (T_TCI_INST *)pa_tHndl;
    if (pInst) {
    	// wait while register access is locked
    	while (g_bRegAccessLocked);
    	// lock register access
    	g_bRegAccessLocked = 1;
    	/*
	    if((pa_usRegister >= T_TCI_REGISTERS_SEG_MIN_DISTANCE_0 && pa_usRegister <= T_TCI_REGISTERS_SEG_AVG_DISTANCE_31) 
	        || (pa_usRegister < T_TCI_REGISTERS_SEG_MIN_DISTANCE_0 && (pa_usRegister + nNofRegs) >= T_TCI_REGISTERS_SEG_MIN_DISTANCE_0)
	        || (pa_usRegister >= T_TCI_REGISTERS_OBJECT_DISTANCE_0 && pa_usRegister <= T_TCI_REGISTERS_OBJECT_DISTANCE_31)
	        || (pa_usRegister < T_TCI_REGISTERS_OBJECT_DISTANCE_0 && (pa_usRegister + nNofRegs) >= T_TCI_REGISTERS_OBJECT_DISTANCE_0)) {
	        *pFIO2_FLAG_C = (unsigned short)I2CES_INTERRUPT_PIN;
	    }
    	*/
    	int i;
        unsigned short *pa_pusBuffer = (unsigned short *)pa_pBuffer;
    	for (i = 0; i < nNofRegs; i++) {
            if(pa_usRegister < T_TCI_REGISTERS_MAX_NOF) {
    		    pa_pusBuffer[i] = (*pInst->ptRegisterList).atRegisterList[pa_usRegister].usRegister;
    		    (*pInst->ptRegisterList).atRegisterList[pa_usRegister].usRegister &= ~((*pInst->ptRegisterList).atRegisterList[pa_usRegister].usRegisterStickyMask);
    		    pa_usRegister++;
            } else {
    	    	*pa_pusLength = i << 1;
    	    	// unlock register access
                g_bRegAccessLocked = 0;
    	    	return ERR_TCI_REGISTER_END_REACHED;
            }
        }

        // unlock register access
        g_bRegAccessLocked = 0;
        return ERR_NONE;
    } else {
        return ERR_TCI_INVALID_HANDLE;
    }
}
    

T_ERROR_CODE TCIregisterGetFlags(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, unsigned long *pa_pulFlags) {
	if (!pa_tHndl) {
        pa_tHndl = g_tTCIdefaultHandle;
    }
    T_TCI_INST *pInst = (T_TCI_INST *)pa_tHndl;
    if (pInst) {
            if(pa_usRegister < T_TCI_REGISTERS_MAX_NOF) {
    		    *pa_pulFlags = (*pInst->ptRegisterList).atRegisterList[pa_usRegister].ulFlags;
            } else {
    	    	return ERR_TCI_REGISTER_END_REACHED;
            }
        return ERR_NONE;
    } else {
        return ERR_TCI_INVALID_HANDLE;
    }
}


T_ERROR_CODE TCIregisterClearFlags(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, unsigned long pa_pulFlags) {
	if (!pa_tHndl) {
        pa_tHndl = g_tTCIdefaultHandle;
    }
    T_TCI_INST *pInst = (T_TCI_INST *)pa_tHndl;
    if (pInst) {
            if(pa_usRegister < T_TCI_REGISTERS_MAX_NOF) {
    		    (*pInst->ptRegisterList).atRegisterList[pa_usRegister].ulFlags &= ~pa_pulFlags;
            } else {
    	    	return ERR_TCI_REGISTER_END_REACHED;
            }
        return ERR_NONE;
    } else {
        return ERR_TCI_INVALID_HANDLE;
    }
}





