/**
*   @file tof_configuration_interface_reg_access.h
*   @ingroup services
*   
*   @brief This file provides functionality to manage a register map.
*   
*   BLT_DISCLAIMER
*   
*   @author aFro, Alex Falkensteiner  
*   
*   @cond svn
*   
*   Information of last commit
*   $Rev::               $:  Revision of last commit
*   $Author::            $:  Author of last commit
*   $Date::              $:  Date of last commit
*   
*   @endcond
**/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#ifndef _CONFIGURATION_INTERFACE_REG_ACCESS_H_
#define _CONFIGURATION_INTERFACE_REG_ACCESS_H_

#include "datatypes.h"


typedef unsigned long T_TCI_HANDLE;              ///< Driver Handle

typedef T_ERROR_CODE (*T_REGISTERWRITE)(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short pa_usLength); ///< Callback function pointer, for a GPIO interrupt handler.
typedef T_ERROR_CODE (*T_REGISTERREAD)(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short *pa_usLength); ///< Callback function pointer, for a GPIO interrupt handler.
typedef T_ERROR_CODE (*T_REGISTERCLEANUP)(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, unsigned short usNofRegistersRead); ///< Callback function pointer, for a GPIO interrupt handler.


/*****************************************************************************
* TCI Register Descriptor Flags                                              *
*****************************************************************************/
#define TCI_REGISTER_FLAG_IN_USE                        (1 << 0)
#define TCI_REGISTER_FLAG_CHANGED                       (1 << 1)
#define TCI_REGISTER_FLAG_READ_ENABLED                  (1 << 2)
#define TCI_REGISTER_FLAG_WRITE_ENABLED                 (1 << 3)
#define TCI_REGISTER_FLAG_CHANGED_CORE_B                (1 << 4)
#define TCI_REGISTER_FLAG_INIT_DISABLED                 (1 << 5)



/**     @brief This function writes value(s) to registers
*       @param pa_tHndl The handle of the service (use 0 to imply the default handle)
*       @param pa_usRegister Register address to write to
*       @param pa_pBuffer Value(s) to write into register
*       @param pa_usLength Length of pa_pBuffer
*       @return Error code (ERR_TCI_INVALID_HANDLE, ERR_TCI_ILLEGAL_REG_WRITE) or ERR_NONE                     */
T_ERROR_CODE TCIregisterWrite(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short pa_usLength);

/**     @brief This function reads value(s) from registers
*       @param pa_tHndl The handle of the service (use 0 to imply the default handle)
*       @param pa_usRegister Register address to read from
*       @param pa_pBuffer Result: Value(s) read from register
*       @param pa_usLength Length of pa_pBuffer
*       @return Error code (ERR_TCI_INVALID_HANDLE, ERR_TCI_REGISTER_END_REACHED) or ERR_NONE                     */
T_ERROR_CODE TCIregisterRead(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, void *pa_pBuffer, unsigned short *pa_pusLength);

/**     @brief This function reads flags of registers
*       @param pa_tHndl The handle of the service (use 0 to imply the default handle)
*       @param pa_usRegister Register address to read from
*       @param pa_pulFlags Result: Flags read from register
*       @return Error code (ERR_TCI_INVALID_HANDLE, ERR_TCI_REGISTER_END_REACHED) or ERR_NONE                     */
T_ERROR_CODE TCIregisterGetFlags(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, unsigned long *pa_pulFlags);

/**     @brief This function clears flags of registers
*       @param pa_tHndl The handle of the service (use 0 to imply the default handle)
*       @param pa_usRegister Register address to read from
*       @param pa_pulFlags Flags to clear in register
*       @return Error code (ERR_TCI_INVALID_HANDLE, ERR_TCI_REGISTER_END_REACHED) or ERR_NONE                     */
T_ERROR_CODE TCIregisterClearFlags(T_TCI_HANDLE pa_tHndl, unsigned short pa_usRegister, unsigned long pa_pulFlags);

#endif // _CONFIGURATION_INTERFACE_REG_ACCESS_H_
