/**  @file eth_udp_streaming_thread.h
*    @ingroup services
*  
*    @brief Udp communication over ethernet: A given buffer is streamed out
*  
*    BLT_DISCLAIMER
*  
*    @author 
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

/**  @defgroup services
*    @ingroup services
*    @brief Hardware independent services
*/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#ifndef _ETH_UDP_STREAMING_THREAD_H_INCLUDED_
#define _ETH_UDP_STREAMING_THREAD_H_INCLUDED_



#define ETH_UDP_STREAMING_HEADER_VERSION               0x0001

#define ETH_UDP_STREAMING_HEADER_INDEX_HEADER_VERSION       0
#define ETH_UDP_STREAMING_HEADER_INDEX_FRAME_COUNTER        2
#define ETH_UDP_STREAMING_HEADER_INDEX_PACKET_COUNTER       4
#define ETH_UDP_STREAMING_HEADER_INDEX_PACKET_SIZE          6
#define ETH_UDP_STREAMING_HEADER_INDEX_TOTAL_LENGTH         8
#define ETH_UDP_STREAMING_HEADER_INDEX_CRC32               12
#define ETH_UDP_STREAMING_HEADER_INDEX_FLAGS               16
#define ETH_UDP_STREAMING_HEADER_INDEX_RESERVED            20

#define ETH_UDP_STREAMING_HEADER_RESERVED_LENGTH           12

#define ETH_UDP_STREAMING_HEADER_FLAGS_IGNORE_CRC           (1 << 0)

#define ETH_UDP_STREAMING_TRANSMIT_TIMEOUT               5000           //[ms]


#define UDP_HEADER_SIZE                             (SSDI_HEADER_LENGTH + ETH_UDP_STREAMING_HEADER_SIZE + 128)
#define ETH_UDP_STREAMING_HEADER_SIZE                      32
#define ETH_UDP_STREAMING_MAX_PACKET_LENGTH              1400

#define SSDI_HEADER_LENGTH                                 64


#define SHARED_BLOCK_IDENTIFIER_ADDRESS              0x1FFFF80
#define BUFFER_CLIENT_HANDLE_ADDRESS                 0x1FFFF82
#define REGISTER_HANDLE_ADDRESS                      0x1FFFF86 
#define CRC16_CHECK                                  0x1FFFFFE           

#define SHARED_BLOCK_IDENTIFIER                        0x1E5C
#define SHARED_BLOCK_LENGTH                               128


typedef struct {
    bool bStreamingEnabled;
    bool bIPportChangeRequest;
    bool bIgnoreCRC;
} T_ETH_UDP_STREAMING_THREAD_INST;

/*****************************************************************************
* PROTOTYPE DECLARATIIONS                                                    *
*****************************************************************************/

/**     @brief The thread's run function. it loops and handles communication
*       @param tSTM100udpBMTClient The buffer client handle address
*       @param tTCIHandle The register handle address                       */
void ETHudpStreamingThreadRunFunction(T_BMT_CLIENT_HANDLE, T_TCI_HANDLE);


#endif //_ETH_UDP_STREAMING_THREAD_H_INCLUDED_
