/**
*   @file tof_configuration_interface.h
*   @ingroup services
*   
*   @brief This file provides functionality to manage a register map.
*   
*   BLT_DISCLAIMER
*   
*   @author aFro, Alex Falkensteiner  
*   
*   @cond svn
*   
*   Information of last commit
*   $Rev::               $:  Revision of last commit
*   $Author::            $:  Author of last commit
*   $Date::              $:  Date of last commit
*   
*   @endcond
**/

/**  @defgroup services
*    @ingroup services
*    @brief Hardware independent services
**/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#ifndef _TOF_CONFIGURATION_INTERFACE_H_
#define _TOF_CONFIGURATION_INTERFACE_H_

#include "datatypes.h"
#include "tof_configuration_interface_register_def.h"
#include "configuration_interface_reg_access.h"

// define/undefine this macro in <environment.h> to enable/disable debug output
#ifdef TCI_DEBUG
	// change the debug level to change the level of debug output for this driver
	#define TCI_DEBUG_LVL			0
#else
	#define TCI_DEBUG_LVL			0
#endif

// add more macros if more debug levels are needed
#if TCI_DEBUG_LVL > 0
    #define TCI_DEBUG_1_PRINT     printf
#else
    #define TCI_DEBUG_1_PRINT
#endif
#if TCI_DEBUG_LVL > 1
    #define TCI_DEBUG_2_PRINT     printf
#else
    #define TCI_DEBUG_2_PRINT
#endif
#if TCI_DEBUG_LVL > 2
    #define TCI_DEBUG_3_PRINT     printf
#else
    #define TCI_DEBUG_3_PRINT
#endif
    
// error codes ***************************************************
#define ERR_TCI_NOT_ENOUGH_MEMORY               (ERR_GENERIC - 10)
#define ERR_TCI_UNKNOWN_COMMAND                 (ERR_GENERIC - 11)
#define ERR_TCI_INVALID_HANDLE                  (ERR_GENERIC - 12)
#define ERR_TCI_INVALID_PARAMETER               (ERR_GENERIC - 13)
#define ERR_TCI_ILLEGAL_REG_WRITE               (ERR_GENERIC - 14)
#define ERR_TCI_ILLEGAL_REG_READ                (ERR_GENERIC - 15)
#define ERR_TCI_REGISTER_END_REACHED            (ERR_GENERIC - 16)
#define ERR_TCI_FLASH_ERROR                     (ERR_GENERIC - 17)
#define ERR_TCI_REG_MAP_HEADER_CORRUPT          (ERR_GENERIC - 18)
#define ERR_TCI_REG_MAP_SIZE_MISSMATCH          (ERR_GENERIC - 19)
#define ERR_TCI_REG_MAP_WRONG_VERSION           (ERR_GENERIC - 20)
#define ERR_TCI_REG_MAP_CORRUPT                 (ERR_GENERIC - 21)
#define ERR_TCI_REG_READ_FAILED                 (ERR_GENERIC - 22)
#define ERR_TCI_OTP_NO_PREAMBLE                 (ERR_GENERIC - 23)
#define ERR_TCI_OTP_WRONG_VERSION               (ERR_GENERIC - 24)
#define ERR_TCI_OTP_CORRUPT                     (ERR_GENERIC - 25)
#define ERR_TCI_INVLAID_ADDRESS                 (ERR_GENERIC - 26)
//#define ERR_TCI_OTP_FACTORY_LOCKED              (ERR_GENERIC - 23)
//#define ERR_TCI_OTP_CUSTOMER_LOCKED             (ERR_GENERIC - 24)
// ***************************************************************



// macros for specific function section
#ifndef TCI_SET_SPECIFIC_IO_FUNC_SECTION
    #define TCI_SET_SPECIFIC_IO_FUNC_SECTION
    #define TCI_SPECIFIC_IO_FUNC_SECTION            "L1_code"
#endif //TCI_SET_SPECIFIC_IO_FUNC_SECTION

//#ifndef TCI_SET_SPECIFIC_INIT_FUNC_SECTION
//    #define TCI_SET_SPECIFIC_INIT_FUNC_SECTION
//    #define TCI_SPECIFIC_INIT_FUNC_SECTION        "L1_code"
//#endif //TCI_SET_SPECIFIC_INIT_FUNC_SECTION

//#ifndef TCI_SET_SPECIFIC_CONTROL_FUNC_SECTION
//    #define TCI_SET_SPECIFIC_CONTROL_FUNC_SECTION
//    #define TCI_SPECIFIC_CONTROL_FUNC_SECTION        "L1_code"
//#endif //TCI_SET_SPECIFIC_CONTROL_FUNC_SECTION





/*****************************************************************
* TYPE DEFINITIONS                                               *
******************************************************************/

typedef struct {
    unsigned long ulPreambel;
    unsigned long ulRegisterCount;
    unsigned long aulReserved[10];
    unsigned long aulDummy[52];		///< Fill up with dummy bytes so that header size = 256 bytes. This make it easier to write it to flash (256 byte pages)
    unsigned long ulCRC32data;
    unsigned long ulCRC16header;
} T_TCI_REG_MAP_HEADER;

typedef struct {
    unsigned short usRegister;
    unsigned short usRegisterStickyMask;
    unsigned long ulFlags;
} T_TCI_REGISTER_DESCRIPTOR;

typedef struct {
    T_TCI_REGISTER_DESCRIPTOR atRegisterList[T_TCI_REGISTERS_MAX_NOF];
    unsigned long ulFlags;
} T_TCI_REGISTER_LIST_DESCRIPTOR;

typedef struct {
    T_TCI_REGISTER_LIST_DESCRIPTOR   *ptRegisterList;
    unsigned long               ulReceiveTimeout;           ///< [us]
    unsigned long               ulCoreClk;
} T_TCI_CONFIG;                                  /// Configuration structure passed to the open function

typedef struct {
    T_TCI_REGISTER_LIST_DESCRIPTOR   *ptRegisterList;
    unsigned long long          ullMextReceiveTimeoutCC;
    unsigned char               ucCurrentReceiveIndex;
    unsigned short              usCurrentRegister;
    unsigned long               ulReceiveTimeoutInCC;
    unsigned short              usRegisterTempVal;
} T_TCI_INST;                                    /// Instance of the driver


/*****************************************************************************
* PROTOTYPE DECLARATIONS                                                     *
*****************************************************************************/

/**     @brief Setup function for service                                   */
void TCIsetup(void);

/**     @brief Cleanup function for service                                 */
void TCIcleanup(void);

/**     @brief Prepares the init struct for the open function
*       @param pa_ptConf This config struct will be filled with default values
*       @return Error code or ERR_NONE
**/
T_ERROR_CODE TCIinitConfig(T_TCI_CONFIG *pa_ptConf);

/**     @brief Open function for this service
*       @param pa_ptConf Configuration struct defines the drivers behaviour
*       @param pa_ptErr Result: Error code or ERR_NONE
*       @return The handle of the service for further interactions                  */
T_TCI_HANDLE TCIopen(T_TCI_CONFIG *pa_ptConf, T_ERROR_CODE *pa_ptErr);

/**     @brief Close function, cleans up
*       @param pa_tHndl The handle of the service to close
*       @return Error code or ERR_NONE                     */
T_ERROR_CODE TCIclose(T_TCI_HANDLE pa_tHndl);

/**     @brief This function sets all write enabled registers to their default value
*       Registers listed in T_TCI_REGISTERS_WRITE_ENABLED_REGISTERS and not listed in T_TCI_REGISTERS_INIT_DISABLED_REGISTERS
*       are set to the default values listed in T_TCI_REGISTERS_WRITE_ENABLED_REGISTERS_DEFAULT_VALUES
*       @param pa_ptCIhndl The configuration interface handle
*       @return Error code or ERR_NONE                     */
T_ERROR_CODE TCIRegMapLoadDefaults(T_TCI_HANDLE pa_ptCIhndl);


#endif
