/**  @file tof_configuration_interface_register_def.h
*    @ingroup tof
*  
*    @brief This file defines register addresses in an enum and their flags/codes/bit position, etc.
*  
*    BLT_DISCLAIMER
*  
*    @author aFro, Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

/**  @defgroup tof
*    @ingroup tof
*    @brief ToF related code
*/

/**
 * Copyright (c) 2013 Bluetechnix GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE
 **/

#ifndef _TOF_CONFIGURATION_INTERFACE_REGISTER_DEF_H_INCLUDED_
#define _TOF_CONFIGURATION_INTERFACE_REGISTER_DEF_H_INCLUDED_

typedef enum {
/*0x0000*/   
            T_TCI_REGISTERS_MODE_0                  = 0x0001,    // general registers
            T_TCI_REGISTERS_MADR,
            T_TCI_REGISTERS_STATUS,
            T_TCI_REGISTERS_IMAGE_FORMAT,
            T_TCI_REGISTERS_INTEGRATION_TIME,
            T_TCI_REGISTERS_DEVICE_TYPE,
            T_TCI_REGISTERS_DEVICE_INFO,
            T_TCI_REGISTERS_FIRMWARE_INFO,
            T_TCI_REGISTERS_MODULATION_FREQU,
            T_TCI_REGISTERS_FRAMERATE,
            T_TCI_REGISTERS_HARDWARE_CONFIG,
            T_TCI_REGISTERS_SERIAL_NR_LOW_WORD,
            T_TCI_REGISTERS_SERIAL_NR_HIGH_WORD,
            T_TCI_REGISTERS_FRAME_COUNTER,
            T_TCI_REGISTERS_CALIB_CMD,
/*0x0010*/  T_TCI_REGISTERS_CONFIDENCE_THRES_LOW,
            T_TCI_REGISTERS_CONFIDENCE_THRES_HIGH,
            T_TCI_REGISTERS_START_ROW,
            T_TCI_REGISTERS_END_ROW,
            T_TCI_REGISTERS_START_COLUMN,
            T_TCI_REGISTERS_END_COLUMN,
            T_TCI_REGISTERS_CAM_HEIGHT,
            T_TCI_REGISTERS_CAM_PAN,
            T_TCI_REGISTERS_CAM_TILT,
            T_TCI_REGISTERS_MODE_1,
            T_TCI_REGISTERS_CALCULATION_TIME,
            T_TCI_REGISTERS_LED_BOARD_TEMP,
            T_TCI_REGISTERS_MAIN_BOARD_TEMP,
            T_TCI_REGISTERS_LIN_AMPLITUDE,
            T_TCI_REGISTERS_LIN_PHASE_SHIFT,
    
/*0x0020*/  T_TCI_REGISTERS_RW_X_COOR             = 0x0020,
            T_TCI_REGISTERS_CALIB_EXT_REG,
            T_TCI_REGISTERS_CMD_ENABLE_PASSWD,
            T_TCI_REGISTERS_AGND_CONFIDENCE_THRESHOLD,
            T_TCI_REGISTERS_MAX_LED_TEMP,
            T_TCI_REGISTERS_PATTERN_STEP_SIZE,
            T_TCI_REGISTERS_HORIZONTAL_FOV,
            T_TCI_REGISTERS_VERTICAL_FOV,
            T_TCI_REGISTERS_CONF_PHASE_270_90,
            T_TCI_REGISTERS_CONF_PHASE_180_0,
            T_TCI_REGISTERS_CONF_PHASE_THRESH_FOR_FRAME_FAULTY,
            T_TCI_REGISTERS_TRIGGER_DELAY,
            T_TCI_REGISTERS_BOOTLOADER_STATUS,
            T_TCI_REGISTERS_TEMP_COMP_GRADIENT,
            T_TCI_REGISTERS_APPLICATION_VERSION,
            T_TCI_REGISTERS_DIST_CALIB_GRADIENT,
/*0x0030*/  
            T_TCI_REGISTERS_CALIBRATION_TEMPERATURE = 0x0031,
            T_TCI_REGISTERS_CPLD_VERSION,
            T_TCI_REGISTERS_CMD_EXEC,
            T_TCI_REGISTERS_CMD_EXEC_RESULT,
            T_TCI_REGISTERS_FACTORY_MAC_ADDRESS_5_4,
            T_TCI_REGISTERS_FACTORY_MAC_ADDRESS_3_2,
            T_TCI_REGISTERS_FACTORY_MAC_ADDRESS_1_0,
            T_TCI_REGISTERS_FACTORY_YEAR,
            T_TCI_REGISTERS_FACTORY_MONTH_DAY,
            T_TCI_REGISTERS_FACTORY_HOUR_MINUTE,
            T_TCI_REGISTERS_FACTORY_TIMEZONE,
            T_TCI_REGISTERS_CALIBRATION_MOD_FREQ,
            T_TCI_REGISTERS_BUILD_YEAR_MONTH,
            T_TCI_REGISTERS_BUILD_DAY_HOUR,
            T_TCI_REGISTERS_BUILD_MINUTE_SECOND,
/*0x0040*/  
        
/*0x0050*/  T_TCI_REGISTERS_MACROCELL_COUNT         = 0x0050,
            T_TCI_REGISTERS_TOP_OPENING_ANGLE,
            T_TCI_REGISTERS_TOP_ROW,
            T_TCI_REGISTERS_BOTTOM_OPENING_ANGLE,
            T_TCI_REGISTERS_BOTTOM_ROW,
            T_TCI_REGISTERS_SEG_MIN_COUNT_THRESHOLD,
            T_TCI_REGISTERS_SEG_MAX_COUNT_THRESHOLD,
            T_TCI_REGISTERS_SEG_MIN_SLIDING_MEDIAN_WINDOW_SIZE,
        
            T_TCI_REGISTERS_SEG_ERROR               = 0x005f,
/*0x0060*/  T_TCI_REGISTERS_SEG_MIN_DISTANCE_0      = 0x0060,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_1,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_2,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_3,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_4,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_5,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_6,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_7,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_8,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_9,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_10,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_11,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_12,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_13,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_14,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_15,
/*0x0070*/  T_TCI_REGISTERS_SEG_MIN_DISTANCE_16,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_17,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_18,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_19,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_20,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_21,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_22,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_23,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_24,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_25,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_26,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_27,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_28,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_29,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_30,
            T_TCI_REGISTERS_SEG_MIN_DISTANCE_31,
/*0x0080*/  T_TCI_REGISTERS_SEG_MAX_DISTANCE_0,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_1,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_2,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_3,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_4,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_5,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_6,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_7,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_8,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_9,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_10,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_11,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_12,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_13,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_14,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_15,
/*0x0090*/  T_TCI_REGISTERS_SEG_MAX_DISTANCE_16,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_17,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_18,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_19,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_20,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_21,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_22,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_23,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_24,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_25,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_26,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_27,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_28,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_29,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_30,
            T_TCI_REGISTERS_SEG_MAX_DISTANCE_31,
/*0x00a0*/  T_TCI_REGISTERS_SEG_AVG_DISTANCE_0,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_1,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_2,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_3,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_4,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_5,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_6,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_7,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_8,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_9,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_10,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_11,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_12,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_13,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_14,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_15,
/*0x00b0*/  T_TCI_REGISTERS_SEG_AVG_DISTANCE_16,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_17,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_18,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_19,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_20,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_21,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_22,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_23,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_24,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_25,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_26,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_27,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_28,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_29,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_30,
            T_TCI_REGISTERS_SEG_AVG_DISTANCE_31,
/*0x00c0*/  T_TCI_REGISTERS_ANGLE_PER_SEG,
            T_TCI_REGISTERS_DIST_OFFSET_0,
            T_TCI_REGISTERS_DIST_OFFSET_1,
            T_TCI_REGISTERS_DIST_OFFSET_2,
            T_TCI_REGISTERS_DIST_OFFSET_3,
            T_TCI_REGISTERS_DIST_OFFSET_4,
            T_TCI_REGISTERS_DIST_OFFSET_5,
            T_TCI_REGISTERS_DIST_OFFSET_6,
            T_TCI_REGISTERS_DIST_OFFSET_7,
            T_TCI_REGISTERS_DIST_OFFSET_8,
            T_TCI_REGISTERS_DIST_OFFSET_9,
            
/*0x00d0*/  
        
/*0x00e0*/  
        
/*0x00f0*/  
        
/*0x0100*/  T_TCI_REGISTERS_USER_DEFINED_00         = 0x0100,
            T_TCI_REGISTERS_USER_DEFINED_01,
            T_TCI_REGISTERS_USER_DEFINED_02,
            T_TCI_REGISTERS_USER_DEFINED_03,
            T_TCI_REGISTERS_USER_DEFINED_04,
            T_TCI_REGISTERS_USER_DEFINED_05,
            T_TCI_REGISTERS_USER_DEFINED_06,
            T_TCI_REGISTERS_USER_DEFINED_07,
            T_TCI_REGISTERS_USER_DEFINED_08,
            T_TCI_REGISTERS_USER_DEFINED_09,
        
/*0x0110*/  
        
/*0x0120*/  
        
/*0x0130*/  
        
/*0x0140*/  
        
/*0x0150*/  
        
/*0x0160*/  
        
/*0x0170*/  
        
/*0x0180*/  
        
/*0x0190*/  
        
/*0x01a0*/  
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_0        = 0x01a9,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_1,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_2,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_3,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_4,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_5,
            T_TCI_REGISTERS_AEC_AVG_WEIGHT_6,
/*0x01b0*/  T_TCI_REGISTERS_AEC_AMP_TARGET 			= 0x01b0,    //AEC
            T_TCI_REGISTERS_AEC_TINT_STEP_MAX,	  // per second
            T_TCI_REGISTERS_AEC_TINT_MAX,
            T_TCI_REGISTERS_AEC_K_P,
            T_TCI_REGISTERS_AEC_K_I,
            T_TCI_REGISTERS_AEC_K_D,
            T_TCI_REGISTERS_PECO_HEIGHT_THRESHOLD,    // PECO
            T_TCI_REGISTERS_PECO_COUNT_IN,
            T_TCI_REGISTERS_PECO_COUNT_OUT,
            T_TCI_REGISTERS_PECO_HEIGHT_MOUNTED,
            T_TCI_REGISTERS_PECO_HEIGHT_MEASURED,
            T_TCI_REGISTERS_PECO_FLAGS,
            T_TCI_REGISTERS_PECO_POINT_TIME_TO_DIE,
            T_TCI_REGISTERS_PECO_OBJ_MIN_VISIBLE,
            T_TCI_REGISTERS_PECO_OBJ_MIN_WIDTH,
            T_TCI_REGISTERS_PECO_OBJ_MIN_AREA,      // more PECO registers down below
/*0x01c0*/  T_TCI_REGISTERS_TEST_CONFIG             = 0x1c0,    // test commands
        
/*0x01d0*/  T_TCI_REGISTERS_FILE_UPDATE_CONFIG      = 0x1d0,    // file transfer
            T_TCI_REGISTERS_FILE_UPDATE_STATUS,
            T_TCI_REGISTERS_FILE_SIZE_LOW,
            T_TCI_REGISTERS_FILE_SIZE_HIGH,
            T_TCI_REGISTERS_FILE_FLASH_START_ADDR_LOW,
            T_TCI_REGISTERS_FILE_FLASH_START_ADDR_HIGH,
            T_TCI_REGISTERS_FILE_CRC_LOW,
            T_TCI_REGISTERS_FILE_CRC_HIGH,
            T_TCI_REGISTERS_FILE_LAST_PACKET_NR,
        
/*0x01e0*/  T_TCI_REGISTERS_IMG_PROC_CONFIG         = 0x1e0,    // Filter Configuration
            T_TCI_REGISTERS_FILTER_MEDIAN_CONFIG,
            T_TCI_REGISTERS_FILTER_AVG_CONFIG,
            T_TCI_REGISTERS_FILTER_GAUSS_CONFIG,
            T_TCI_REGISTERS_FILTER_BILATERAL_CONFIG,
            T_TCI_REGISTERS_FILTER_SLIDING_AVG_CONFIG,
        
/*0x01f0*/  
        
/*0x0200*/  T_TCI_REGISTERS_OHD_CONFIG              = 0x0200,    // Segmentation Object/Hole Detection
            T_TCI_REGISTERS_OHD_OBJECT_COUNT,
            T_TCI_REGISTERS_OHD_OBJECT_LIST,
            T_TCI_REGISTERS_OHD_THRESHOLD,
            T_TCI_REGISTERS_OHD_CALIB_CONFIG,
            T_TCI_REGISTERS_OHD_SAC_THRESOLD,
            T_TCI_REGISTERS_OHD_SAC_INLIER,
            T_TCI_REGISTERS_OHD_SAC_MAX_ITERATIONS,
            T_TCI_REGISTERS_OHD_SAC_MAX_RAND_ITERATIONS,
            T_TCI_REGISTERS_OHD_SAC_MAX_FAILED_ITERATIONS,
            T_TCI_REGISTERS_OHD_SAC_DOWNSAMPLING_RATE,
            T_TCI_REGISTERS_OHD_SAC_FLOOR_PLAIN_CONF,
            T_TCI_REGISTERS_OHD_ERROR               = 0x020f,
/*0x0210*/  T_TCI_REGISTERS_OBJECT_DISTANCE_0       = 0x0210,
            T_TCI_REGISTERS_OBJECT_DISTANCE_1,
            T_TCI_REGISTERS_OBJECT_DISTANCE_2,
            T_TCI_REGISTERS_OBJECT_DISTANCE_3,
            T_TCI_REGISTERS_OBJECT_DISTANCE_4,
            T_TCI_REGISTERS_OBJECT_DISTANCE_5,
            T_TCI_REGISTERS_OBJECT_DISTANCE_6,
            T_TCI_REGISTERS_OBJECT_DISTANCE_7,
            T_TCI_REGISTERS_OBJECT_DISTANCE_8,
            T_TCI_REGISTERS_OBJECT_DISTANCE_9,
            T_TCI_REGISTERS_OBJECT_DISTANCE_10,
            T_TCI_REGISTERS_OBJECT_DISTANCE_11,
            T_TCI_REGISTERS_OBJECT_DISTANCE_12,
            T_TCI_REGISTERS_OBJECT_DISTANCE_13,
            T_TCI_REGISTERS_OBJECT_DISTANCE_14,
            T_TCI_REGISTERS_OBJECT_DISTANCE_15,
/*0x0220*/  T_TCI_REGISTERS_OBJECT_DISTANCE_16,
            T_TCI_REGISTERS_OBJECT_DISTANCE_17,
            T_TCI_REGISTERS_OBJECT_DISTANCE_18,
            T_TCI_REGISTERS_OBJECT_DISTANCE_19,
            T_TCI_REGISTERS_OBJECT_DISTANCE_20,
            T_TCI_REGISTERS_OBJECT_DISTANCE_21,
            T_TCI_REGISTERS_OBJECT_DISTANCE_22,
            T_TCI_REGISTERS_OBJECT_DISTANCE_23,
            T_TCI_REGISTERS_OBJECT_DISTANCE_24,
            T_TCI_REGISTERS_OBJECT_DISTANCE_25,
            T_TCI_REGISTERS_OBJECT_DISTANCE_26,
            T_TCI_REGISTERS_OBJECT_DISTANCE_27,
            T_TCI_REGISTERS_OBJECT_DISTANCE_28,
            T_TCI_REGISTERS_OBJECT_DISTANCE_29,
            T_TCI_REGISTERS_OBJECT_DISTANCE_30,
            T_TCI_REGISTERS_OBJECT_DISTANCE_31,
/*0x0230*/  T_TCI_REGISTERS_PECO_OBJ_CURR_TRACKING      =0x0230,    // PECO
            T_TCI_REGISTERS_PECO_DEAD_POINTS_COUNT,
            T_TCI_REGISTERS_PECO_IMG_X_START,
            T_TCI_REGISTERS_PECO_IMG_X_END,
            T_TCI_REGISTERS_PECO_IMG_Y_START,
            T_TCI_REGISTERS_PECO_IMG_Y_END,
        
/*0x0240*/  T_TCI_REGISTERS_ETH0_CONFIG                 = 0x240,   // ethernet
            T_TCI_REGISTERS_ETH0_MAC_2,
            T_TCI_REGISTERS_ETH0_MAC_1,
            T_TCI_REGISTERS_ETH0_MAC_0,
            T_TCI_REGISTERS_ETH0_IP_0,
            T_TCI_REGISTERS_ETH0_IP_1,
            T_TCI_REGISTERS_ETH0_SNM_0,
            T_TCI_REGISTERS_ETH0_SNM_1,
            T_TCI_REGISTERS_ETH0_GATEWAY_0,
            T_TCI_REGISTERS_ETH0_GATEWAY_1,
            T_TCI_REGISTERS_ETH0_TCP_STREAM_PORT,
            T_TCI_REGISTERS_ETH0_TCP_CONFIG_PORT,
            T_TCI_REGISTERS_ETH0_UDP_STREAM_IP_0,
            T_TCI_REGISTERS_ETH0_UDP_STREAM_IP_1,
            T_TCI_REGISTERS_ETH0_UDP_STREAM_PORT,
    
            T_TCI_REGISTERS_MAX_NOF,
    
// file transfer register address where the data is written to
/*0x7000*/T_TCI_REGISTERS_FILE_TRANSFER = 0x7000,
} T_TCI_REGISTERS;










/******************************************************************************
*******************************************************************************
* TCI Register Flags                                                          *
*******************************************************************************
*******************************************************************************/

// mode 0 register
#define TCI_REGISTERS_MODE_0_VIDEO            		   		 	(1 << 0)
//#define TCI_REGISTERS_MODE_0_START_UPDATE                       (1 << 1)
#define TCI_REGISTERS_MODE_0_SLEEP_MODE         				(1 << 2)
#define TCI_REGISTERS_MODE_0_POWER_DOWN         				(1 << 3)
#define TCI_REGISTERS_MODE_0_MANUAL_TRIGGER  					(1 << 4)
//#define TCI_REGISTERS_MODE_0_RAW_OUTPUT                         (1 << 5)
#define TCI_REGISTERS_MODE_0_CLEAR_STATUS_REG					(1 << 6)
#ifdef TCI_USE_MODE_0_REBOOT_FLAG
  #define TCI_REGISTERS_MODE_0_REBOOT								(1 << 7)
#endif
#define TCI_REGISTERS_MODE_0_RUN_BOOTLOADER                     (1 << 8)

// status register
#define TCI_REGISTERS_STATUS_BOOTLOADER         				(1 << 0)
#define TCI_REGISTERS_STATUS_FRAME_READY        				(1 << 1)
#define TCI_REGISTERS_STATUS_ONGOING_CALIB      				(1 << 2)
#define TCI_REGISTERS_STATUS_LED_BOARD_ERROR					(1 << 3)
#define TCI_REGISTERS_STATUS_MAINB_TEMP_SENSOR_ERROR			(1 << 4)
#define TCI_REGISTERS_STATUS_NO_CALIBRATION_IN_NVM				(1 << 5)
#define TCI_REGISTERS_STATUS_LOADED_FACTORY_REG_MAP	            (1 << 6)
#define TCI_REGISTERS_STATUS_WDOG_REGMAP_RECOVERED 	            (1 << 7)
#define TCI_REGISTERS_STATUS_FRAME_FAULTY						(1 << 12)

// image format register
#define TCI_REGISTERS_IMG_FORMAT_MODE_SHIFT                     3
#define TCI_REGISTERS_IMG_FORMAT_MODE_SET(x)                    (x << TCI_REGISTERS_IMG_FORMAT_MODE_SHIFT)
#define TCI_REGISTERS_IMG_FORMAT_MODE_DIST_AMP       			0
#define TCI_REGISTERS_IMG_FORMAT_MODE_DIST_AMP_CONF  			1
//#define TCI_REGISTERS_IMG_FORMAT_MODE_RAW_PHASE_DATA    		2
#define TCI_REGISTERS_IMG_FORMAT_MODE_XYZ            			3
#define TCI_REGISTERS_IMG_FORMAT_MODE_XYZ_AMP           		4
#define TCI_REGISTERS_IMG_FORMAT_MODE_XYZ_COLOR           		5
#define TCI_REGISTERS_IMG_FORMAT_SOURCEDATA_FOR_PMD_SDK_COLLISION_IN_GSA 6
#define TCI_REGISTERS_IMG_FORMAT_MODE_PHASE_0_90_180_270        7
#define TCI_REGISTERS_IMG_FORMAT_MODE_PHASE_270_180_90_0        8
#define TCI_REGISTERS_IMG_FORMAT_MODE_XYZ_DIST                  9
#define TCI_REGISTERS_IMG_FORMAT_MODE_MASK                   0xff

// T_TCI_REGISTERS_CALIB_CMD
#define TCI_REGISTERS_CALIB_CMD_CODE_MASK                        0xff
#define TCI_REGISTERS_CALIB_CMD_CODE(x)                          (x & TCI_REGISTERS_CALIB_CMD_CODE_MASK)
#define TCI_REGISTERS_CALIB_CMD_NOP                              0
#define TCI_REGISTERS_CALIB_CMD_FPN_CALIB_CALCULATE				 1
#define TCI_REGISTERS_CALIB_CMD_DIST_CALIB_SAVE_DIST_IMG_0		 2
#define TCI_REGISTERS_CALIB_CMD_DIST_CALIB_SAVE_DIST_IMG_1		 3
#define TCI_REGISTERS_CALIB_CMD_DIST_CALIB_CALCULATE		     4
#define TCI_REGISTERS_CALIB_CMD_LENS_CALIB_SAVE_AMP_IMG_0		 5  // white wall, with lense
#define TCI_REGISTERS_CALIB_CMD_LENS_CALIB_SAVE_AMP_IMG_1		 6  // chess pattern, same distance, with lense
#define TCI_REGISTERS_CALIB_CMD_LENS_CALIB_CALCULATE		     7
#define TCI_REGISTERS_CALIB_CMD_DIST_LENS_CALIB_SAVE_DIST_IMG_0  8
#define TCI_REGISTERS_CALIB_CMD_DIST_LENS_CALIB_SAVE_AMP_IMG_0   9
#define TCI_REGISTERS_CALIB_CMD_DIST_LENS_CALIB_SAVE_DIST_IMG_1 10
#define TCI_REGISTERS_CALIB_CMD_DIST_LENS_CALIB_SAVE_AMP_IMG_1  11
#define TCI_REGISTERS_CALIB_CMD_DIST_LENS_CALIB_CALCULATE		12
#define TCI_REGISTERS_CALIB_CMD_FPPN_CALIB_CALCULATE            13
#define TCI_REGISTERS_CALIB_CMD_CENTER_DIST_CALIB_CALCULATE		14
#define TCI_REGISTERS_CALIB_CMD_CLEAR_FPN_DATA                  15
#define TCI_REGISTERS_CALIB_CMD_CLEAR_FPPN_DATA                 16
#define TCI_REGISTERS_CALIB_CMD_CLEAR_DIST_DATA                 17
#define TCI_REGISTERS_CALIB_CMD_CLEAR_LENS_DATA                 18
#define TCI_REGISTERS_CALIB_CMD_OFFSET_CALIB                    19
//#define TCI_REGISTERS_CALIB_CMD_GEN_CALIB_AUTO_EXPOSURE			(1 << 8)
#define TCI_REGISTERS_CALIB_CMD_CALIB_IMG_OUTPUT				(1 << 9)

// mode 1 register
#define TCI_REGISTERS_MODE_1_MACROCELL_ON    			   		(1 << 0)
#define TCI_REGISTERS_MODE_1_OHD_ON             				(1 << 1)
#define TCI_REGISTERS_MODE_1_HDR_ON             				(1 << 2)
#define TCI_REGISTERS_MODE_1_AEC_ON             				(1 << 3)
#define TCI_REGISTERS_MODE_1_UART_OUTPUT        				(1 << 4)
//#define TCI_REGISTERS_MODE_1_MEDIAN_OUTPUT      				(1 << 5)
//#define TCI_REGISTERS_MODE_1_APPLY_DIST_CALIB_REGISTERS         (1 << 6)  // T_TCI_REGISTERS_DIST_CALIB_* are applied to distance values
#define TCI_REGISTERS_MODE_1_MINMAX_ON                          (1 << 7)
#define TCI_REGISTERS_MODE_1_DISABLE_ALIVE_LED					(1 << 8)
//#define TCI_REGISTERS_MODE_1_OVERRULE_DIST_CALIB_REGISTERS      (1 << 9)  // 0: calibration data is summed up/multiplied with T_TCI_REGISTERS_DIST_CALIB_* (if TCI_REGISTERS_MODE_1_APPLY_DIST_CALIB_REGISTERS set) 1: calibration data in flash is ignored. only T_TCI_REGISTERS_DIST_CALIB_* apply (not if TCI_REGISTERS_MODE_1_APPLY_DIST_CALIB_REGISTERS not set)
#define TCI_REGISTERS_MODE_1_CALIB_FLOOR_LEVEL                  (1 << 10)
#define TCI_REGISTERS_MODE_1_MIN_REG_SLIDING_MEDIAN             (1 << 11)

// T_TCI_REGISTERS_CALIB_EXT_REG
#define TCI_REGISTERS_CALIB_EXT_REG_STATUS_MASK                 0xff
#define TCI_REGISTERS_CALIB_EXT_REG_STATUS(x)                   (x & TCI_REGISTERS_CALIB_EXT_REG_STATUS_MASK)
#define TCI_REGISTERS_CALIB_EXT_REG_IMG_NR_SHIFT                8
#define TCI_REGISTERS_CALIB_EXT_REG_IMG_NR_MASK                 (0x3 << TCI_REGISTERS_CALIB_EXT_REG_IMG_NR_SHIFT)
#define TCI_REGISTERS_CALIB_EXT_REG_IMG_NR(x)                   ((x & 0x3) << TCI_REGISTERS_CALIB_EXT_REG_IMG_NR_SHIFT)
#define TCI_REGISTERS_CALIB_EXT_REG_ERROR                       (1 << 10)
#define TCI_REGISTERS_CALIB_EXT_REG_NO_FPN_CALIB_IN_NVM         (1 << 11)
#define TCI_REGISTERS_CALIB_EXT_REG_NO_FPPN_CALIB_IN_NVM        (1 << 12)
#define TCI_REGISTERS_CALIB_EXT_REG_NO_DIST_CALIB_IN_NVM        (1 << 13)
#define TCI_REGISTERS_CALIB_EXT_REG_NO_LENS_CALIB_IN_NVM        (1 << 14)
#define TCI_REGISTERS_CALIB_EXT_REG_TEMP_COMP_ERROR             (1 << 15)
// state machine codes
#define TCI_REGISTERS_CALIB_EXT_REG_OK	                          0
#define TCI_REGISTERS_CALIB_EXT_REG_FPN_CAPTURE_CALC   		      1
//#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_EXPOSURE           2
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_FILTER             3
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_SAVE               4
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_LOAD               5
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_CALC_SAVE          6
//#define TCI_REGISTERS_CALIB_EXT_REG_LENS_CALIB_EXPOSURE           7
#define TCI_REGISTERS_CALIB_EXT_REG_LENS_CALIB_CHECK              8
#define TCI_REGISTERS_CALIB_EXT_REG_LENS_CALIB_SAVE               9
#define TCI_REGISTERS_CALIB_EXT_REG_LENS_CALIB_LOAD              10
#define TCI_REGISTERS_CALIB_EXT_REG_LENS_CALIB_CALC_SAVE         11
//#define TCI_REGISTERS_CALIB_EXT_REG_DIST_LENS_CALIB_EXPOSURE     12
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_LENS_CALIB_CHECK        13
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_LENS_CALIB_SAVE         14
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_LENS_CALIB_LOAD         15
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_LENS_CALIB_CALC_SAVE    16
#define TCI_REGISTERS_CALIB_EXT_REG_CENTER_DIST_CALIB_LOAD       17
#define TCI_REGISTERS_CALIB_EXT_REG_CENTER_DIST_CALIB_CALC_SAVE  18
#define TCI_REGISTERS_CALIB_EXT_REG_FPPN_CAPTURE_CALC   	     19
#define TCI_REGISTERS_CALIB_EXT_REG_ERASING_FLASH                20
#define TCI_REGISTERS_CALIB_EXT_REG_OFFSET_CALIB                 21
#define TCI_REGISTERS_CALIB_EXT_REG_DONE					   0xa1
// error codes
#define TCI_REGISTERS_CALIB_EXT_REG_GENERIC_ERROR		    	255
#define TCI_REGISTERS_CALIB_EXT_REG_NVM_ERROR		    		254
#define TCI_REGISTERS_CALIB_EXT_REG_DIST_CALIB_CALC_ERROR	    253
#define TCI_REGISTERS_CALIB_EXT_REG_OUT_OF_MEMORY		    	252
#define TCI_REGISTERS_CALIB_EXT_REG_PATTERN_NOT_RECOGNIZED      251
#define TCI_REGISTERS_CALIB_EXT_REG_WRONG_VERSION               250
#define TCI_REGISTERS_CALIB_EXT_REG_LED_BOARD_ERROR             249
#define TCI_REGISTERS_CALIB_EXT_REG_INVALID_MODULATION_FREQ     248
#define TCI_REGISTERS_CALIB_EXT_REG_HARDWARE_FAULT              247

// ohd calib configuration register
#define TCI_REGISTERS_OHD_CONF_START_CALIB      				(1 << 0)
#define TCI_REGISTERS_OHD_CONF_CALIBRATED       				(1 << 1)
#define TCI_REGISTERS_OHD_CONF_CALIB_STATUS(x)  				(x << 2)

// cmd enable password register
#define TCI_CMD_ENABLE_PASSWD									0x5e6b
#define TCI_CMD_ENABLE_PASSWD_XYZ_OUTPUT						0x21fd
#define TCI_CMD_ENABLE_PASSWD_REG_MAP_FLASH						0x4877

// T_TCI_REGISTERS_PECO_FLAGS
#define T_TCI_REGISTERS_PECO_FLAGS_DEATH_MARTRIX_ON             (1 << 0)

// T_TCI_REGISTERS_CMD_EXEC codes
#define T_TCI_REGISTERS_CMD_EXEC_REG_MAP_ERASE_FLASH            0xC2AE
#define T_TCI_REGISTERS_CMD_EXEC_REG_MAP_READ_FROM_FLASH        0x9E20
#define T_TCI_REGISTERS_CMD_EXEC_REG_MAP_READ_FACTORY           0x909A
#define T_TCI_REGISTERS_CMD_EXEC_REG_MAP_WRITE_TO_FLASH         0xDD9E

// T_TCI_REGISTERS_IMG_PROC_CONFIG
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_MEDIAN                    (1 << 0)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_AVG                       (1 << 1)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_GAUSS                     (1 << 2)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_BILATERAL                 (1 << 3)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_SLIDING_AVG               (1 << 4)
//#define T_TCI_REGISTERS_IMG_PROC_CONFIG_CORR_QUADRANT             (1 << 5)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_COMP_WIGGLING             (1 << 6)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_COMP_FPPN                 (1 << 7)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_SCALE_MOD_FREQ            (1 << 8)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_SCALE_MM                  (1 << 9)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_ADD_OFFSET                (1 << 10)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_COMP_TEMPERATURE          (1 << 11)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_SCALE_CUSTOM              (1 << 12)
#define T_TCI_REGISTERS_IMG_PROC_CONFIG_ADD_OFFSET_CUSTOM         (1 << 13)

// T_TCI_REGISTERS_FILTER_AVG_CONFIG
#define T_TCI_REGISTERS_FILTER_AVG_CONFIG_3X3                       0
#define T_TCI_REGISTERS_FILTER_AVG_CONFIG_5X5                       1

// T_TCI_REGISTERS_FILTER_GAUSS_CONFIG
#define T_TCI_REGISTERS_FILTER_GAUSS_CONFIG_3X3                     0
#define T_TCI_REGISTERS_FILTER_GAUSS_CONFIG_5X5                     1
// file transfer
#define T_TCI_REGISTERS_FILE_UPDATE_CONFIG_CMD_INIT_WRITE           1
#define T_TCI_REGISTERS_FILE_UPDATE_CONFIG_CMD_FLASH_FIRMWARE       2
#define T_TCI_REGISTERS_FILE_UPDATE_CONFIG_CMD_FLASH_BOOTLOADER     3
#define T_TCI_REGISTERS_FILE_UPDATE_CONFIG_CMD_FLASH_GENERIC_FILE   4
#define T_TCI_REGISTERS_FILE_UPDATE_CONFIG_CMD_FLASH_OTP            5

#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_NONE                     0
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_OK                       1           /// packet acknowledgement
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_MAX_FILESIZE_EXCEEDED    2
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_OUT_OF_MEMORY            3
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_BUFFER_OVERRUN           4
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_PACKET_CRC_ERROR         5
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FILE_CRC_ERROR           6
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FILE_OK                  7
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_ERASING_FLASH            8
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLASHING                 9
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_VERIFYING               10
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_ERASING_FAILED          11
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLASHING_FAILED         12
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_VERIFYING_FAILED        13
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_UPDATE_SUCCESS          14
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_WRONG_PACKET_NR         15
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_HEADER_VERSION_CONFLICT 16
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_MISSING_FW_IDENTIFIER   17
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_WRONG_FW_IDENTIFIER     18
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLASH_BOUNDARY_EXCEEDED 19
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_DATA_INCONSISTENT       20
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_IN_PROGRESS             21
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_PROTOCOL_VIOLATION     255
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_STATE_MASK             0x00ff

#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLAGS_SHIFT              8
#define T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLAG_INITIALIZED     (1 << (0 + T_TCI_REGISTERS_FILE_UPDATE_STATUS_FLAGS_SHIFT))

// test configuration
#define T_TCI_REGISTERS_TEST_CONFIG_CMD_MASK                       0xff
#define T_TCI_REGISTERS_TEST_CONFIG_FLAGS_SHIFT                    8

#define T_TCI_REGISTERS_TEST_CONFIG_CMD_CPLD_SEC_SHUTDOWN          1
#define T_TCI_REGISTERS_TEST_CONFIG_CMD_WATCHDOG                   2


//ethernet configuration
#define T_TCI_REGISTERS_ETH0_CONFIG_ENABLE_DHCP                     (1 << 0)
#define T_TCI_REGISTERS_ETH0_CONFIG_ENABLE_UDP_STREAMING            (1 << 1)
#define T_TCI_REGISTERS_ETH0_CONFIG_UDP_STREAMING_IGNORE_CRC        (1 << 2)


// build date time registers
#define T_TCI_REGISTERS_BUILD_YEAR_SHIFT                        4
#define T_TCI_REGISTERS_BUILD_MONTH_SHIFT                       0
#define T_TCI_REGISTERS_BUILD_DAY_SHIFT                         5
#define T_TCI_REGISTERS_BUILD_HOUR_SHIFT                        0
#define T_TCI_REGISTERS_BUILD_MINUTE_SHIFT                      6
#define T_TCI_REGISTERS_BUILD_SECOND_SHIFT                      0

#endif //_TOF_CONFIGURATION_INTERFACE_REGISTER_DEF_H_INCLUDED_
