%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: recordETH.m                                                       %
%                                                                         %
% brief: This is a example for recording 100 distances frames and save    %
%        them to a file.                                                  %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2014 Bluetechnix GmbH                                     %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

%define amount of frames to be saved.
N=100;

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.udpDataIpAddr = [224, 0, 0, 1];
configStruct.udpDataIpAddrLen = 4;
configStruct.udpDataPort = 10002;
configStruct.tcpDeviceIpAddr = [192, 168, 0, 10];
configStruct.tcpDeviceIpAddrLen = 4;
configStruct.tcpControlPort = 10001;
configStruct.frameMode = 1;
configStruct.frameQueueMode = 1;
configStruct.frameQueueLength = 5;

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end

% set the interval of the keep alive massages 
status = BTAsetKeepAliveMsgInterval(deviceHandle, 2);
if status ~= 0
    error('BTAsetKeepAliveMsgInterval failed. See "status" for error description');
end

% set framemode to DistAmp
status = BTAsetFrameMode(deviceHandle, 1);
if status ~= 0
    error('BTAsetFrameMode failed. See "status" for error description');
end
%wait some time that the changes take effect
pause(2); 

for i = 1 : N
    [status, frameHandle,  frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
    if status ~= 0
        statusClose = BTAclose(deviceHandle);
        error('BTAgetFrame failed. See "status" for error description');
    end
    %get distances
    [status, distData, integrationTime, modulationFrequency, unit] = BTAgetDistances(frameHandle);
    if status == 0
        FrameBuffer(i,:,:) = distData;
    end

    %free frame
    [status] = BTAfreeFrame(frameHandle);
    if status ~= 0
        error('BTAfreeFrame failed. See "status" for error description');
    end
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end

%store frame buffer
save('FrameBuffer','FrameBuffer');

clear all;




