
from enum import Enum
from enum import IntEnum
from ctypes import *
from PyBta.Frame import BtaFrame


InfoEventCb_Type = CFUNCTYPE(None, c_int32, c_char_p)
#InfoEventExCb_Type = CFUNCTYPE(None, c_void_p, c_int32, c_char_p)
#InfoEventEx2Cb_Type = CFUNCTYPE(None, c_void_p, c_int32, c_char_p, c_void_p)
#FrameArrivedCb_Type = CFUNCTYPE(None, POINTER(BtaFrame))
#FrameArrivedExCb_Type = CFUNCTYPE(None, c_void_p, POINTER(BtaFrame))
#FrameArrivedEx2Cb_Type = CFUNCTYPE(None, c_void_p, POINTER(BtaFrame), c_void_p)


# The Bta_Config structure has the members 8-byte aligned
class Bta_ConfigUnion(Union):
    _fields_ = [
        ("uint8", c_uint8),
        ("p_uint8", POINTER(c_uint8)),
        ("uint16", c_uint16),
        ("p_uint16", POINTER(c_uint16)),
        ("uint32", c_uint32),
        ("p_uint32", POINTER(c_uint32)),
        ("uint64", c_uint64),
        ("p_uint64", POINTER(c_uint64)),
        ("p_char", c_char_p),
        ("p_void", c_void_p),
        ("info_event_cb", InfoEventCb_Type),
        #("info_event_ex_cb", InfoEventExCb_Type),
        #("info_event_ex2_cb", InfoEventEx2Cb_Type),
        #("frame_arrived_cb", FrameArrivedCb_Type),
        #("frame_arrived_ex_cb", FrameArrivedExCb_Type),
        #("frame_arrived_ex2_cb", FrameArrivedEx2Cb_Type),
    ]


# Bta_Config structure
# The members are 8-Byte aligned for whatever reason
# Therefore the Bta_ConfigUnion is used as workaround to achieve 8-byte alignment
class BtaConfig(Structure):
    _fields_ = [
        ("udpDataIpAddr", Bta_ConfigUnion),                 # The IP address for the UDP data interface (The address the device is configured to stream to)
        ("udpDataIpAddrLen", Bta_ConfigUnion),              # The length of udpDataIpAddr buffer in [byte]
        ("udpDataPort", Bta_ConfigUnion),                   # The port for the UDP data interface (The port the device is configured to stream to)
        ("udpControlOutIpAddr", Bta_ConfigUnion),           # The IP address for the UDP control interface (outbound connection) (The IP address of the camera device)
        ("udpControlOutIpAddrLen", Bta_ConfigUnion),        # The length of udpControlOutIpAddr buffer in [byte]
        ("udpControlPort", Bta_ConfigUnion),                # The port for the UDP control interface (outbound connection) (The port where the device awaits commands at)
        ("udpControlInIpAddr", Bta_ConfigUnion),            # The callback IP address for the UDP control interface (inbound connection) (The address the device should answer to, usually the local IP address) [This parameter is optional since TIM-UP-19K-S3 - ETH Firmware v1.6]
        ("udpControlInIpAddrLen", Bta_ConfigUnion),         # The length of udpControlInIpAddr buffer in [byte]
        ("udpControlCallbackPort", Bta_ConfigUnion),        # The callback port for the UDP control interface (inbound connection) (The port the device should answer to) [This parameter is optional since TIM-UP-19K-S3 - ETH Firmware v1.6]
        ("tcpDeviceIpAddr", Bta_ConfigUnion),               # The IP address for the TCP data and control interface (The device's IP address)
        ("tcpDeviceIpAddrLen", Bta_ConfigUnion),            # The length of tcpDeviceIpAddr buffer in [byte]
        ("tcpDataPort", Bta_ConfigUnion),                   # The port for the TCP data interface (The port the device sends data to) (not supported yet)
        ("tcpControlPort", Bta_ConfigUnion),                # The port for the TCP control interface (The port the device awaits commands at)

        ("uartPortName", Bta_ConfigUnion),                  # The port name of the UART to use (ASCII coded)
        ("uartBaudRate", Bta_ConfigUnion),                  # The UART baud rate
        ("uartDataBits", Bta_ConfigUnion),                  # The number of UART data bits used
        ("uartStopBits", Bta_ConfigUnion),                  # 0: None, 1: One, 2: Two, 3: 1.5 stop bits
        ("uartParity", Bta_ConfigUnion),                    # 0: None, 1: Odd, 2: Even, 3: Mark, 4: Space Parity
        ("uartTransmitterAddress", Bta_ConfigUnion),        # The source address for UART communications
        ("uartReceiverAddress", Bta_ConfigUnion),           # The target address for UART communications

        ("deviceType", Bta_ConfigUnion),                    # The device type, when not left 0 implies the type of connection to use (Ethernet, USB (P100), UART, Bltstream, ...)
        ("pon", Bta_ConfigUnion),                           # Product Order Number of device to be opened (0 == not specified) (ASCII coded)
        ("serialNumber", Bta_ConfigUnion),                  # Serial number of device to be opened (0 == not specified)

        ("calibFileName", Bta_ConfigUnion),                 # Name of the lens calibration file to be loaded into SDK (ASCII coded). It is supported by P100 based cameras in order to generate XYZ channels
        ("zFactorsFileName", Bta_ConfigUnion),              # Specify a file with factors to be multiplied with the Z channel of a frame
        ("wigglingFileName", Bta_ConfigUnion),              # No longer supported, please use BTAwigglingUpdate()

        ("frameMode", Bta_ConfigUnion),                     # Frame mode to be set in SDK/device

        ("infoEvent", Bta_ConfigUnion),                     # Callback function pointer to the function to be called upon an informative event
        ("infoEventEx", Bta_ConfigUnion),                   # Callback function pointer to the function to be called upon an informative event
        ("infoEventEx2", Bta_ConfigUnion),                   # Callback function pointer to the function to be called upon an informative event
        ("verbosity", Bta_ConfigUnion),                     # A value to tell the library when and when not to generate InfoEvents (0: Only critical events, 10: Maximum amount of events)
        ("frameArrived", Bta_ConfigUnion),                  # Callback function pointer to the function to be called when a frame is ready
        ("frameArrivedEx", Bta_ConfigUnion),                # Callback function pointer to the function to be called when a frame is ready
        ("frameArrivedEx2", Bta_ConfigUnion),                # Callback function pointer to the function to be called when a frame is ready
        ("userArg", Bta_ConfigUnion),

        ("frameQueueLength", Bta_ConfigUnion),              # The library queues this amount of frames internally
        ("frameQueueMode", Bta_ConfigUnion),                # The frame queue configuration parameter

        ("averageWindowLength", Bta_ConfigUnion),           # The amount of frames to average. 0: do nothing, 1: turn averaging off (set 1 sequence), >1: averaging x sequences

        ("bltstreamFilename", Bta_ConfigUnion),             # Only for BtaStreamLib: Specify the file (containing the stream) to read from (ASCII coded)
        ("infoEventFilename", Bta_ConfigUnion)              # All infoEvents are appended to this file
    ]


class QueueMode(IntEnum):
    DoNotQueue = 0                # No queueing
    DropOldest = 1                # Before an overflow, the oldest item in the queue is removed
    DropCurrent = 2               # When full, the queue remains unchanged
    AvoidDrop = 3    


class LibParam(IntEnum):
    KeepAliveMsgInterval = 0
    CrcControlEnabled = 1

    BltStreamTotalFrameCount = 2
    BltStreamAutoPlaybackSpeed = 3
    BltStreamPos = 4
    BltStreamPosIncrement = 5

    TestPatternEnabled = 6                                           

    PauseCaptureThread = 7
    DisableDataScaling = 8
    UndistortRgb = 9

    InfoEventVerbosity = 10
    EnableJpgDecoding = 11

    DataStreamReadFailedCount = 12
    DataStreamBytesReceivedCount = 13
    DataStreamPacketsReceivedCount = 14
    DataStreamPacketsMissedCount = 15
    DataStreamPacketsToParse = 16
    DataStreamParseFrameDuration = 17
    DataStreamFrameCounterGapsCount = 18
    DataStreamFramesParsedCount = 19
    DataStreamFramesParsedPerSec = 20

    DataStreamRetrReqMode = 21
                                    
    DataStreamPacketWaitTimeout = 22
    DataStreamRetrReqIntervalMin = 23
    DataStreamRetrReqMaxAttempts = 24
    DataStreamRetrReqsCount = 25
    DataStreamRetransPacketsCount = 26
    DataStreamNdasReceived = 27
    DataStreamRedundantPacketCount = 28

    DataSockOptRcvtimeo = 29
    DataSockOptRcvbuf = 30

    DebugFlags01 = 5000
    DebugValue01 = 5001
    DebugValue02 = 5002
    DebugValue03 = 5003
    DebugValue04 = 5004
    DebugValue05 = 5005
    DebugValue06 = 5006
    DebugValue07 = 5007
    DebugValue08 = 5008
    DebugValue09 = 5009
    DebugValue10 = 5010