from PyBta.Bta import LibParam
from PyBta.Bta import QueueMode
from PyBta.BtaWrapper import BtaWrapper
from PyBta.BtaWrapper import BtaException
import cv2
import numpy as np
import scipy.constants as constant
import time

def infoEventHandler(status, msg):
    print("{0:20}: {1}".format(status, msg.decode("utf-8")))


if __name__ == "__main__":

	py_bta = BtaWrapper
	msg = py_bta.init()
	print(msg)
	
	# connect to an eth device
	py_bta.openEth('224.0.0.1', 10002, '192.168.0.10', None, 10001, 5, QueueMode.DropOldest, infoEventHandler, 15);
	# set UDP streaming Port from autoconfigured one to fixed one
	py_bta.write_register(0x24e,[10002])
	py_bta.close()
	#reconnect
	py_bta.openEth('224.0.0.1', 10002, '192.168.0.10', None, 10001, 5, QueueMode.DropOldest, infoEventHandler, 15);
	
	#record
	while True:
		
		frame = py_bta.get_frame(1000)
		# reshape frame
		distchannel = frame.channels[0].data.reshape(frame.channels[0].yRes,frame.channels[0].xRes,1)
		# all values below 10 are error codes => these pixels are invalid, set them all to 0
		distchannel[distchannel < 10] = 0
		# cv2 color function only supports values between 0 and 255 => scale distance values between 0 and unambigousrange to 0 and 255
		############################
		# calculate unambigousrange
		############################
		# Read modulation frequency and convert to hz (stored in 10khz)
		mod_freq = py_bta.read_register(0x9,1)[0] * 10000
		unambigousrange_mm = (constant.speed_of_light/(2*mod_freq))*1000
		assert(np.amax(distchannel) <= unambigousrange_mm)
		assert(np.amin(distchannel) >=  0)
		#scale values
		distchannel=distchannel*(255.0/unambigousrange_mm)
		assert(np.amax(distchannel) <= 255)
		assert(np.amin(distchannel) >=  0)
		distchannel=distchannel.astype('uint8')
		#color the image
		distchannel = cv2.applyColorMap(distchannel, cv2.COLORMAP_JET)
		# 0 ist mapped to (128,0,0) => color all invalid pixels black
		distchannel[np.all(distchannel == (128, 0, 0), axis=-1)] = (0,0,0)
		cv2.imshow('Color image', distchannel)
		cv2.waitKey(1)

			
			
	time.sleep(1)
	cv2.destroyAllWindows()
	py_bta.close()

	
	
