---------------------------------------------------------------------------------------------------
--! @brief Clock and reset powerup module test bench 
--! @details
--!
--!
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date October 12 2018 created
--! @date June 04 2019 last modify
--!
--! @version v0.1
--!
--!
--! @file ituClkRstTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;
use work.CslAxiPkg.all;
---------------------------------------------------------------------------------------------------
entity CmuClkRstTb is
end entity CmuClkRstTb;
---------------------------------------------------------------------------------------------------
architecture Bhv of CmuClkRstTb is
   -----------------------------
   -- Port Signals 
   -----------------------------
   -- Clock reset
   signal   CLK_USR_PERIOD_C : time    := 6.4 ns; --! clock period
   constant CLK_DELAY_C      : time    := 10 ns;  --! clock delay at startup 
                                              --
   constant TPD_C       : time     := 1 ns;   --! TPD constant
   constant HOLD_TIME_C : positive := 1000;   --! hold time for PowerupRst module

   signal userClkP_i  : sl := '0'; --! differential clock P line
   signal userClkN_i  : sl := '1'; --! differential clock N line
   signal gtFreeClk_o  : sl;        --! single ended clock output for GT transciever
   signal gtFreeRst_o : sl;
   signal clk_o       : sl; --! single ended clock output for user logic
   signal rst_o       : sl; --! reset ouptut synchronised to user clock

---------------------------------------------------------------------------------------------------
begin -- architecture Bhv

   -----------------------------
   -- Unit Under Test instantiation 
   -----------------------------
   uut_ituClkRst: entity work.CmuClkRst
   generic map (
      TPD_G       => TPD_C,
      HOLD_TIME_G => HOLD_TIME_C)
   port map (
      userClkP_i  => userClkP_i,
      userClkN_i  => userClkN_i,
      gtFreeClk_o => gtFreeClk_o,
      gtFreeRst_o => gtFreeRst_o,
      clk_o       => clk_o,
      rst_o       => rst_o);
   
      
      
   -- Clock generation in process
   process is
   begin
      wait for 200*CLK_DELAY_C;
      for i in 0 to 150000 loop
         userClkP_i <= not userClkP_i;
         userClkN_i <= not userClkN_i;
         wait for CLK_USR_PERIOD_C/2.0;
      end loop;
      wait for 20000*CLK_DELAY_C;
      for i in 0 to 200000 loop
         userClkP_i <= not userClkP_i;
         userClkN_i <= not userClkN_i;
         wait for CLK_USR_PERIOD_C/2.0;
      end loop;
      wait;
   end process;

   -- uut simulation process 
   StimuliProcess : process
   begin
      wait for 1000*CLK_USR_PERIOD_C;
      wait for 30004 ns;
      wait for 1000*CLK_USR_PERIOD_C;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 6.5 ns;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 6.6 ns;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 6.7 ns;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 7.0 ns;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 7.5 ns;
      wait for 10000*CLK_USR_PERIOD_C;

      CLK_USR_PERIOD_C <= 7.6 ns;
      wait for 40000*CLK_USR_PERIOD_C;

      wait;
   end process StimuliProcess;

end architecture Bhv;
---------------------------------------------------------------------------------------------------