---------------------------------------------------------------------------------------------------
--! @brief     Cosylab Direct Memory Access Core Package 
--! @details    
--!   All DMA types, functions, declarations are in this file. 
--!    
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date Feb 15 2019 created
--! @date Feb 15 2019 last modify
--!
--! @version v0.1
--!
--! @file CslDmaTypePkg.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;
---------------------------------------------------------------------------------------------------
package CslDmaTypePkg is
   ------------------------------------------------------------
   --! Dma stat type
   type DmaStatType is record
      buffEnd        : sl;
      addrPointer    : slv(31 downto 0);
   end record DmaStatType;
   
   constant DMA_STAT_INIT_C : DmaStatType := (
      buffEnd        => '0',
      addrPointer    => (others => '0')
   );
   ------------------------------------------------------------
   
   ------------------------------------------------------------
   --! Dma ctrl type
   type DmaCtrlType is record
      en             : sl;
      circular       : sl;
      startAddr      : slv(31 downto 0);
      size           : slv(31 downto 0);
      threshold      : slv(31 downto 0);
      transferLen    : slv(31 downto 0);
   end record DmaCtrlType;
   
   constant DMA_CTRL_INIT_C : DmaCtrlType := (
      en             => '0',
      circular       => '0',
      startAddr      => (others => '0'),
      size           => (others => '0'),
      threshold      => (others => '0'),
      transferLen    => (others => '1')
   );
   ------------------------------------------------------------
end CslDmaTypePkg;
---------------------------------------------------------------------------------------------------
package body CslDmaTypePkg is
end package body CslDmaTypePkg;
---------------------------------------------------------------------------------------------------