---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslAxilConfigTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;
use work.CslAxiPkg.all;
use work.CslAxilConfigPkg.all;

--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslAxilConfigTb is
end CslAxilConfigTb;
---------------------------------------------------------------------------------------------------
architecture behavior of CslAxilConfigTb is 
   
   --Inputs
   signal clk_i : sl := '0'; --! internal clock signal bus
   signal rst_i : sl := '0'; --! internal reset signal bus
   signal sig_i : sl := '0'; --! internal input signal bus
   
   --Outputs
   signal sig_o : sl; --! internal output signal bus
   
   -- uut signals

   constant TPD_C              : time     := 1 ns;
   constant READ_ARRAY_SIZE_C  : positive := 1;
   constant WRITE_ARRAY_SIZE_C : positive := 1;

   signal ready_o           : sl;
   signal axiReadValid_i    : sl;
   signal axiReadAddr_i     : CslAxilConfigArray(READ_ARRAY_SIZE_C - 1 downto 0);
   signal axiReadData_o     : CslAxilConfigArray(READ_ARRAY_SIZE_C - 1 downto 0);
   signal axiWriteValid_i   : sl;
   signal axiWriteAddr_i    : CslAxilConfigArray(WRITE_ARRAY_SIZE_C - 1 downto 0);
   signal axiWriteData_i    : CslAxilConfigArray(WRITE_ARRAY_SIZE_C - 1 downto 0);
   signal axilReadMaster_o  : AxiLiteReadMasterType;
   signal axilReadSlave_i   : AxiLiteReadSlaveType := AXI_LITE_READ_SLAVE_INIT_C;
   signal axilWriteSlave_i  : AxiLiteWriteSlaveType := AXI_LITE_WRITE_SLAVE_INIT_C;
   signal axilWriteMaster_o : AxiLiteWriteMasterType; 
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant	
   ---------------------------------------------------------------------------------------------------
begin
   
    uut_CslAxilConfig : entity work.CslAxilConfig
        generic map (
            TPD_G              => TPD_C,
            READ_ARRAY_SIZE_G  => READ_ARRAY_SIZE_C,
            WRITE_ARRAY_SIZE_G => WRITE_ARRAY_SIZE_C
        )
        port map (
            clk_i             => clk_i,
            rst_i             => rst_i,
            ready_o           => ready_o,
            axiReadValid_i    => axiReadValid_i,
            axiReadAddr_i     => axiReadAddr_i,
            axiReadData_o     => axiReadData_o,
            axiWriteValid_i   => axiWriteValid_i,
            axiWriteAddr_i    => axiWriteAddr_i,
            axiWriteData_i    => axiWriteData_i,
            axilReadMaster_o  => axilReadMaster_o,
            axilReadSlave_i   => axilReadSlave_i,
            axilWriteSlave_i  => axilWriteSlave_i,
            axilWriteMaster_o => axilWriteMaster_o
        );
   
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0';
      wait for T_C/2;
      clk_i <= '1';
      wait for T_C/2;
   end process;
   
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
      
      -- input signals
      rst_i <= '0';
      wait for T_C * 10;
      
      -- reset
      rst_i <= '1';
      wait for T_C * 10;
      
      rst_i <= '0';
      wait for T_C * 10;
      
      -- simulate
      
      wait for T_C * 1000;
      
      -- Stop simulation
      assert false report "SIMULATION COMPLEATED" severity failure;
      
   end process;
end;
---------------------------------------------------------------------------------------------------
