---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslAxisMuxTb.vhd
---------------------------------------------------------------------------------------------------
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use ieee.math_real.all; 
use work.CslStdRtlPkg.all; 
use work.CslAxiPkg.all; 
use work.CslDmaPkg.all; 
use work.CslDmaTypePkg.all; 
use work.MemoryManagerPkg.all; 
--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslAxisMuxTb is
end CslAxisMuxTb; 
---------------------------------------------------------------------------------------------------
architecture behavior of CslAxisMuxTb is 
   
   --Inputs
   signal clk_i : sl := '0'; --! internal clock signal bus
   signal rst_i : sl := '0'; --! internal reset signal bus
   
   constant TPD_G          : time     := 1 ns; 
   constant CHANNELS_G     : positive := 4; 
   constant AXIS_SIZE_G    : positive := 2; 
   constant PIPELINE_G     : natural  := 1; 
   constant BRAM_G         : boolean  := true; 
   constant AWIDTH_G       : positive := 5; 
   constant THRESHOLD_G    : positive := 16; 
   constant TUSER_NORMAL_G : boolean  := true; 
   constant TID_WIDTH_G    : positive := 8; 
   constant TDEST_WIDTH_G  : positive := 8; 
   constant TUSER_WIDTH_G  : positive := 8; 
   constant BYTES_SLV_G    : positive := 8; 
   constant BYTES_MST_G    : positive := 4; 
   
   signal en_i           : sl := '0'; 
   signal sAxisClks_i    : slv(CHANNELS_G-1 downto 0); 
   signal sAxisRsts_i    : slv(CHANNELS_G-1 downto 0); 
   signal sAxisMasters_i : work.CslAxiPkg.AxiStreamMasterArray(CHANNELS_G-1 downto 0) := (others => work.CslAxiPkg.AXI_STREAM_MASTER_INIT_C); 
   signal sAxisSlaves_o  : work.CslAxiPkg.AxiStreamSlaveArray(CHANNELS_G-1 downto 0); 
   signal mAxisClk_i     : sl; 
   signal mAxisRst_i     : sl; 
   signal mAxisMaster_o  : work.CslAxiPkg.AxiStreamMasterType; 
   signal mAxisSlave_i   : work.CslAxiPkg.AxiStreamSlaveType := work.CslAxiPkg.AXI_STREAM_SLAVE_INIT_C; 
   
   signal axis64WriteMastersArray_i : axis64WriteMasterArrayType := (others => AXIS_64_WRITE_MASTER_CH_INIT_C); 
   signal axis64WriteSlavesArray_o  : axis64WriteSlaveArrayType  := (others => AXIS_64_WRITE_SLAVE_CH_INIT_C); 
   signal axis32ReadSlave_i         : work.CslAxiPkg.AxiStreamSlaveType; 
   signal axis32ReadMaster_o        : work.CslAxiPkg.AxiStreamMasterType; 
   
   signal dmaReadData     : slv(31 downto 0); 
   signal dmaReadData32   : slv(31 downto 0); 
   signal dataCnt         : integer := 1; 
   constant NUM_OF_DATA_C : integer := 200; 
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant
                                   ---------------------------------------------------------------------------------------------------
begin
   
   sAxisClks_i <= (others => clk_i); 
   sAxisRsts_i <= (others => rst_i); 
   mAxisClk_i  <= clk_i; 
   mAxisRst_i  <= rst_i; 
   
   uut_CslAxisMux : entity work.CslAxisMux
      generic map (
         TPD_G          => TPD_G,
         CHANNELS_G     => CHANNELS_G,
         AXIS_SIZE_G    => AXIS_SIZE_G,
         PIPELINE_G     => PIPELINE_G,
         BRAM_G         => BRAM_G,
         AWIDTH_G       => AWIDTH_G,
         THRESHOLD_G    => THRESHOLD_G,
         TUSER_NORMAL_G => TUSER_NORMAL_G,
         TID_WIDTH_G    => TID_WIDTH_G,
         TDEST_WIDTH_G  => TDEST_WIDTH_G,
         TUSER_WIDTH_G  => TUSER_WIDTH_G,
         BYTES_SLV_G    => BYTES_SLV_G,
         BYTES_MST_G    => BYTES_MST_G
      )
      port map (
         en_i           => en_i,
         sAxisClks_i    => sAxisClks_i,
         sAxisRsts_i    => sAxisRsts_i,
         sAxisMasters_i => sAxisMasters_i,
         sAxisSlaves_o  => sAxisSlaves_o,
         mAxisClk_i     => mAxisClk_i,
         mAxisRst_i     => mAxisRst_i,
         mAxisMaster_o  => mAxisMaster_o,
         mAxisSlave_i   => mAxisSlave_i
      ); 
   
   uut_dmaWriteChParser : entity work.dmaWriteChParser
      generic map (
         TPD_G => TPD_G
      )
      port map (
         clk_i                     => mAxisClk_i,
         rst_i                     => mAxisRst_i,
         axis64WriteMastersArray_i => axis64WriteMastersArray_i,
         axis64WriteSlavesArray_o  => axis64WriteSlavesArray_o,
         axis32ReadSlave_i         => axis32ReadSlave_i,
         axis32ReadMaster_o        => axis32ReadMaster_o
      ); 
   
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0'; 
      wait for T_C/2; 
      clk_i <= '1'; 
      wait for T_C/2; 
   end process; 
   
   dmaReadData   <= mAxisMaster_o.tdata(31 downto 0); 
   dmaReadData32 <= axis32ReadMaster_o.tdata(31 downto 0); 
   
   axis32ReadSlave_i.tready <= mAxisSlave_i.tReady; 
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
      
      for i in 0 to CHANNELS_G-1 loop
         if i /= 2 then 
            sAxisMasters_i(i).tValid        <= '0'; 
            axis64WriteMastersArray_i(i).en <= '1'; 
            
            for j in 0 to BYTES_SLV_G-1 loop
               sAxisMasters_i(i).tuser(7+j*8 downto j*8)                       <= slv(to_unsigned(i,8)); 
               axis64WriteMastersArray_i(i).axisMaster.tuser(7+j*8 downto j*8) <= slv(to_unsigned(i,8)); 
            end loop; 
         end if; 
      end loop; 
      mAxisSlave_i.tReady <= '1'; 
      en_i                <= '1'; 
      
      wait until clk_i = '1'; 
      wait for TPD_G; 
      
      -- input signals
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      -- reset
      rst_i <= '1'; 
      wait for T_C * 10; 
      
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      dataCnt <= 1; 
      
      while (dataCnt <= NUM_OF_DATA_C) loop
         for i in 0 to CHANNELS_G-1 loop
            if i /= 2 then 
               if (sAxisSlaves_o(i).tReady = '1') then
                  axis64WriteMastersArray_i(i).axisMaster.tValid <= '1'; 
                  sAxisMasters_i(i).tValid                       <= '1'; 
                  axis64WriteMastersArray_i(i).axisMaster.tData(63 downto 32) <= slv(to_unsigned(dataCnt, 32)); 
                  axis64WriteMastersArray_i(i).axisMaster.tData(31 downto 0)  <= slv(to_unsigned(dataCnt, 32)); 
                  sAxisMasters_i(i).tData(63 downto 32)                       <= slv(to_unsigned(dataCnt, 32)); 
                  sAxisMasters_i(i).tData(31 downto 0)                        <= slv(to_unsigned(dataCnt, 32)); 
                  dataCnt                                                     <= dataCnt + 1; 
                  wait for T_C * 1; 
                  sAxisMasters_i(i).tValid                       <= '0'; 
                  axis64WriteMastersArray_i(i).axisMaster.tValid <= '0'; 
               else
                  wait for T_C * 1; 
               end if; 
            end if; 
         end loop; 
      end loop; 
      
      for i in 0 to CHANNELS_G-1 loop
         sAxisMasters_i(i).tValid                       <= '0'; 
         axis64WriteMastersArray_i(i).axisMaster.tValid <= '0'; 
      end loop; 
      
      dataCnt <= 1; 
      wait for T_C * 500; 
      
      mAxisSlave_i.tReady <= '1'; 
      
      wait for T_C * 1000; 
   end process; 
end; 
---------------------------------------------------------------------------------------------------
