---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslDmaTb.vhd
---------------------------------------------------------------------------------------------------
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use ieee.math_real.all; 
use work.CslStdRtlPkg.all; 
use work.CslAxiPkg.all; 
use work.CslDmaTypePkg.all; 
--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslDmaTestTb is
end CslDmaTestTb; 
---------------------------------------------------------------------------------------------------
architecture behavior of CslDmaTestTb is 
   
   --Inputs
   signal clk_i : sl := '0'; --! internal clock signal bus
   signal rst_i : sl := '0'; --! internal reset signal bus
   
   -- uut signals
   --constant TPD_C              : time     := 1 ns;
   --constant READ_ARRAY_SIZE_C  : positive := 2;
   --constant WRITE_ARRAY_SIZE_C : positive := 2;
   
   constant TPD_G             : time              := 1 ns; 
   constant AWIDTH_G          : positive          := 8;  --! Address width
   constant DWIDTH_G          : positive          := 32; --! Data width
   constant PIPELINE_G        : natural           := 0;  --! delay in clock cycles of output data
   constant WRITE_FIRST_G     : boolean           := false; 
   constant BRAM_G            : boolean           := false; --! false             =>             LUT RAM, true             =>             BRAM
   constant DMA_CH_ADDR_STT_G : slv (31 downto 0) := x"0000_0040"; 
   constant DMA_CH_ADDR_END_G : slv (31 downto 0) := x"0004_0000"; 
   
   signal axiWriteMaster_o : AxiWriteMasterType; 
   signal axiWriteSlave_i  : AxiWriteSlaveType; 
   signal axiReadMaster_o  : AxiReadMasterType; 
   signal axiReadSlave_i   : AxiReadSlaveType; 
   
   signal axilReadMaster_o  : AxiLiteReadMasterType; 
   signal axilReadSlave_i   : AxiLiteReadSlaveType  := AXI_LITE_READ_SLAVE_INIT_C; 
   signal axilWriteSlave_i  : AxiLiteWriteSlaveType := AXI_LITE_WRITE_SLAVE_INIT_C; 
   signal axilWriteMaster_o : AxiLiteWriteMasterType; 
   
   signal axisWriteMaster_i : AxiStreamMasterType := AXI_STREAM_MASTER_INIT_C; 
   signal axisWriteSlave_o  : AxiStreamSlaveType  := AXI_STREAM_SLAVE_INIT_C; 
   signal axisReadMaster_o  : AxiStreamMasterType := AXI_STREAM_MASTER_INIT_C; 
   signal axisReadSlave_i   : AxiStreamSlaveType  := AXI_STREAM_SLAVE_INIT_C; 
   
   signal dmaWriteCtrl_i : DmaCtrlType := DMA_CTRL_INIT_C; 
   signal dmaWriteStat_o : DmaStatType; 
   
   signal dmaReadCtrl_i : DmaCtrlType := DMA_CTRL_INIT_C; 
   signal dmaReadStat_o : DmaStatType; 
   
   signal mm2sMaster : AxiStreamMasterType := AXI_STREAM_MASTER_INIT_C; 
   signal mm2sSlave  : AxiStreamSlaveType  := AXI_STREAM_SLAVE_INIT_C; 
   
   signal s2mmMaster : AxiStreamMasterType := AXI_STREAM_MASTER_INIT_C; 
   signal s2mmSlave  : AxiStreamSlaveType  := AXI_STREAM_SLAVE_INIT_C; 
   
   signal dbgReadReq_i    : sl; 
   signal dbgReadAxisData : slv(31 downto 0); 
   
   -- test design signals
   signal axi_resetn_0             : sl; 
   signal mm2s_introut_0           : sl; 
   signal mm2s_prmry_reset_out_n_0 : sl; 
   signal rsta_busy_0              : sl; 
   signal s2mm_introut_0           : sl; 
   signal s2mm_prmry_reset_out_n_0 : sl; 
   signal s_axi_aclk_0             : sl; 
   
   signal dmaReadData     : slv(31 downto 0); 
   signal dataCnt         : integer := 1; 
   constant NUM_OF_DATA_C : integer := 200; 
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant
                                   ---------------------------------------------------------------------------------------------------
begin
   
   u_dmaAxi4Test_wrapper : entity work.Axi4BramTest_wrapper
      port map (
         S_AXI_0_araddr   => axiReadMaster_o.araddr(31 downto 0), --  in STD_LOGIC_VECTOR ( 31 downto 0 );
         S_AXI_0_arburst  => axiReadMaster_o.arburst,             --  in STD_LOGIC_VECTOR ( 1 downto 0 );
         S_AXI_0_arcache  => axiReadMaster_o.arcache,             --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_arid     => axiReadMaster_o.arid(3 downto 0),
         S_AXI_0_arlen    => axiReadMaster_o.arlen,                --  in STD_LOGIC_VECTOR ( 7 downto 0 );
         S_AXI_0_arlock   => axiReadMaster_o.arlock(0 downto 0),   --  in STD_LOGIC_VECTOR ( 0 to 0 );
         S_AXI_0_arprot   => axiReadMaster_o.arprot,               --  in STD_LOGIC_VECTOR ( 2 downto 0 );
         S_AXI_0_arqos    => axiReadMaster_o.arqos,                --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_arready  => axiReadSlave_i.arready,               --  out STD_LOGIC;
         S_AXI_0_arregion => axiReadMaster_o.arregion,             --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_arsize   => axiReadMaster_o.arsize,               --  in STD_LOGIC_VECTOR ( 2 downto 0 );
         S_AXI_0_arvalid  => axiReadMaster_o.arvalid,              --  in STD_LOGIC;
         S_AXI_0_awaddr   => axiWriteMaster_o.awaddr(31 downto 0), --  in STD_LOGIC_VECTOR ( 31 downto 0 );
         S_AXI_0_awburst  => axiWriteMaster_o.awburst,             --  in STD_LOGIC_VECTOR ( 1 downto 0 );
         S_AXI_0_awcache  => axiWriteMaster_o.awcache,             --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_awid     => axiWriteMaster_o.awid(3 downto 0),
         S_AXI_0_awlen    => axiWriteMaster_o.awlen,              --  in STD_LOGIC_VECTOR ( 7 downto 0 );
         S_AXI_0_awlock   => axiWriteMaster_o.awlock(0 downto 0), --  in STD_LOGIC_VECTOR ( 0 to 0 );
         S_AXI_0_awprot   => axiWriteMaster_o.awprot,             --  in STD_LOGIC_VECTOR ( 2 downto 0 );
         S_AXI_0_awqos    => axiWriteMaster_o.awqos,              --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_awready  => axiWriteSlave_i.awready,             --  out STD_LOGIC;
         S_AXI_0_awregion => axiWriteMaster_o.awregion,           --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_awsize   => axiWriteMaster_o.awsize,             --  in STD_LOGIC_VECTOR ( 2 downto 0 );
         S_AXI_0_awvalid  => axiWriteMaster_o.awvalid,            --  in STD_LOGIC;
         S_AXI_0_bid      => axiWriteSlave_i.bid(3 downto 0),
         S_AXI_0_bready   => axiWriteMaster_o.bready,           --  in STD_LOGIC;
         S_AXI_0_bresp    => axiWriteSlave_i.bresp,             --  out STD_LOGIC_VECTOR ( 1 downto 0 );
         S_AXI_0_bvalid   => axiWriteSlave_i.bvalid,            --  out STD_LOGIC;
         S_AXI_0_rdata    => axiReadSlave_i.rdata(31 downto 0), --  out STD_LOGIC_VECTOR ( 31 downto 0 );
         S_AXI_0_rid      => axiReadSlave_i.rid(3 downto 0), 
         S_AXI_0_rlast    => axiReadSlave_i.rlast,                --  out STD_LOGIC;
         S_AXI_0_rready   => axiReadMaster_o.rready,              --  in STD_LOGIC;
         S_AXI_0_rresp    => axiReadSlave_i.rresp,                --  out STD_LOGIC_VECTOR ( 1 downto 0 );
         S_AXI_0_rvalid   => axiReadSlave_i.rvalid,               --  out STD_LOGIC;
         S_AXI_0_wdata    => axiWriteMaster_o.wdata(31 downto 0), --  in STD_LOGIC_VECTOR ( 31 downto 0 );
         S_AXI_0_wlast    => axiWriteMaster_o.wlast,              --  in STD_LOGIC;
         S_AXI_0_wready   => axiWriteSlave_i.wready,              --  out STD_LOGIC;
         S_AXI_0_wstrb    => axiWriteMaster_o.wstrb(3 downto 0),  --  in STD_LOGIC_VECTOR ( 3 downto 0 );
         S_AXI_0_wvalid   => axiWriteMaster_o.wvalid,             --  in STD_LOGIC;
         axi_resetn_0     => axi_resetn_0,                                --  in STD_LOGIC;
         rsta_busy_0      => rsta_busy_0,                                --  out STD_LOGIC;
         s_axi_aclk_0     => s_axi_aclk_0                                --  in STD_LOGIC
      ); 
   
   uut_CslDmaWrite : entity work.CslDmaWrite
      generic map (
         TPD_G         => TPD_G,
         AWIDTH_G      => AWIDTH_G,
         DWIDTH_G      => DWIDTH_G,
         WRITE_FIRST_G => WRITE_FIRST_G)
      port map (
         clk_i             => clk_i,
         rst_i             => rst_i,
         axisWriteMaster_i => axisWriteMaster_i,
         axisWriteSlave_o  => axisWriteSlave_o,
         dmaWriteCtrl_i    => dmaWriteCtrl_i,
         dmaWriteStat_o    => dmaWriteStat_o,
         axiWriteMaster_o  => axiWriteMaster_o,
         axiWriteSlave_i   => axiWriteSlave_i
      ); 
   
   uut_CslDmaRead : entity work.CslDmaRead
      generic map (
         TPD_G         => TPD_G,
         AWIDTH_G      => AWIDTH_G,
         DWIDTH_G      => DWIDTH_G,
         PIPELINE_G    => 0,
         WRITE_FIRST_G => WRITE_FIRST_G,
         BRAM_G        => BRAM_G)
      port map (
         clk_i            => clk_i,
         rst_i            => rst_i,
         axisReadMaster_o => axisReadMaster_o,
         axisReadSlave_i  => axisReadSlave_i,
         dmaReadCtrl_i    => dmaReadCtrl_i,
         dmaReadStat_o    => dmaReadStat_o,
         axiReadMaster_o  => axiReadMaster_o,
         axiReadSlave_i   => axiReadSlave_i
      ); 
   
   axi_resetn_0 <= not rst_i; 
   s_axi_aclk_0 <= clk_i; 
   
   
   dbgReadAxisData <= axisReadMaster_o.tdata(31 downto 0); 
   
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0'; 
      wait for T_C/2; 
      clk_i <= '1'; 
      wait for T_C/2; 
   end process; 
   
   dmaReadData <= axisReadMaster_o.tdata(31 downto 0); 
   
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
      
      dmaWriteCtrl_i.en        <= '1'; 
      dmaWriteCtrl_i.threshold <= x"0000_0005"; 
      dmaWriteCtrl_i.startAddr <= x"0000_0000"; 
      dmaWriteCtrl_i.size      <= slv(to_unsigned(300,32)); 
      dmaWriteCtrl_i.circular  <= '1'; 
      axisWriteMaster_i.tValid <= '0'; 
      
      dmaReadCtrl_i.en        <= '0'; 
      dmaReadCtrl_i.threshold <= x"0000_000A"; 
      dmaReadCtrl_i.startAddr <= x"0000_0000"; 
      dmaReadCtrl_i.size      <= slv(to_unsigned(300,32)); 
      dmaReadCtrl_i.circular  <= '0'; 
      axisReadSlave_i.tReady  <= '0'; 
      
      wait until clk_i = '1'; 
      wait for TPD_G; 
      
      -- input signals
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      -- reset
      rst_i <= '1'; 
      wait for T_C * 10; 
      
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      dataCnt <= 1; 
      
      while (dataCnt < NUM_OF_DATA_C) loop
         
         axisWriteMaster_i.tValid             <= '1'; 
         axisWriteMaster_i.tData(31 downto 0) <= slv(to_unsigned(dataCnt, 32)); 
         
         if (axisWriteSlave_o.tReady = '1') then
            dataCnt <= dataCnt + 1; 
            wait for T_C * 1; 
         end if; 
      end loop; 
      axisWriteMaster_i.tValid <= '0'; 
      
      -- Enable read channel
      wait for T_C * 100; 
      dmaReadCtrl_i.en <= '1'; 
      dataCnt          <= 1; 
      wait for T_C * 100; 
      
      axisReadSlave_i.tReady <= '1'; 
      wait for T_C * 1; 
      
      while (dataCnt < NUM_OF_DATA_C) loop
         
         -- Check out read channel
         if (axisReadMaster_o.tValid = '1') then
            
            if (dmaReadData /= slv(to_unsigned(dataCnt, 32))) then
               wait for T_C; 
               assert false report "SIMULATION FAILED" severity failure; 
            end if; 
            
            dataCnt <= dataCnt + 1; 
         end if; 
         
         wait for T_C * 1; 
         
      end loop; 
      
      wait for T_C * 10; 
      
      ---- Stop simulation
      assert false report "SIMULATION COMPLEATED" severity failure; 
      
   end process; 
end; 
---------------------------------------------------------------------------------------------------
