---------------------------------------------------------------------------------------------------
--! @brief      Signal Vector Synchronizer module
--! @details The module shifts input signal through a series of D flip flops.
--! With generic DEPTH_G the number of D flip flop is determined and with WIDTH_G data width 
--! is determined
--!
--! Warning! This module should only be used to synchronise a vector of independent signals!  
--!          To synchronise dependant signals such as data and address CslSyncVec should be used.
--! 
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date January 8 2018 created
--! @date March 28 2018 last modify
--!
--! @version v1.0
--!
--! @par Modifications:
--! jkokalj, January 8 2018: Created
--! jkokalj, March 28 2018: design iteration
--!
--! @file CslSyncVec.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;

--! @brief  Signal Vector Synchronizer Module
--! @details The module shifts input signal through a series of D flip flops.
--! With generic DEPTH_G the number of D flip flop is determined and with WIDTH_G data width 
--! is determined
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
---------------------------------------------------------------------------------------------------
entity CslSyncVec is
   generic(
      TPD_G  : time   := 1 ns;
      WIDTH_G: positive:= 8 ;	--! width of data at intput/output bus
      DEPTH_G: natural:= 3	--! number of FF's
   );
   Port ( 
      --global input signals
      clk_i : in  sl;  --! input clock bus
      rst_i : in  sl;  --! Input reset bus
      sig_i : in  slv (WIDTH_G - 1 downto 0);    --! Input vector signal bus
      --global output signals
      sig_o : out  slv (WIDTH_G - 1 downto 0));   --! Output vector signal bus
end CslSyncVec;
---------------------------------------------------------------------------------------------------
architecture rtl of CslSyncVec is
---------------------------------------------------------------------------------------------------
begin

   GEN_SYNC_VEC: for i in 0 to WIDTH_G - 1 generate 
      --generated Sync component for input bits
      ux_SyncBit: entity work.CslSync 
         generic map(
            TPD_G => TPD_G,
            DEPTH_G => DEPTH_G
            )
         port map (
            clk_i => clk_i,
            rst_i => rst_i,
            sig_i => sig_i(i),
            sig_o => sig_o(i)
         ); 
   end generate GEN_SYNC_VEC;
   
end rtl;
---------------------------------------------------------------------------------------------------
