---------------------------------------------------------------------------------------------------
--! @brief     Fiber Package 
--! @details    
--!   Gt type definition for FiberLinkMap and GT fiber connection in general. 
--!    
--! @author Uros Legat, Cosylab (uros.legat@cosylab.com)
--!
--! @date Oct 15 2018 created
--! @date Jan 23 2019 last modify
--!
--! @version v0.1
--!
--! @file FiberPkg.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.CslStdRtlPkg.all;

---------------------------------------------------------------------------------------------------
package FiberPkg is  
  ------------------------------------------------------------
   --! GT type  
   type GtType is record
      data        : slv(15 downto 0);
      char        : slv(1 downto 0);
      clkCorrEn   : sl;
      rstDone     : sl;
      dispErr     : sl;
      decErr      : sl;
      byteAlig    : sl;
      byteReAlig  : sl;
      cdrStable   : sl;
   end record GtType;

   constant GT_INIT_C : GtType := (
      data        => x"00BC",
      char        => "01",
      clkCorrEn   => '1',
      rstDone     => '1',
      dispErr     => '0',
      decErr      => '0',
      byteAlig    => '1',
      byteReAlig  => '0',
      cdrStable   => '1'
   );
   
   type GtArray is array (natural range<>) of GtType;
   ------------------------------------------------------------
   
end package FiberPkg;
---------------------------------------------------------------------------------------------------