//------------------------------------------------------------------------------
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor: Xilinx
// \   \   \/     Version : 3.6
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : gt_sfp_init.v
// /___/   /\      
// \   \  /  \ 
//  \___\/\___\
//
//  Description : This module instantiates the modules required for
//                reset and initialisation of the Transceiver
//
// Module gt_sfp_init
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`timescale 1ns / 1ps
`define DLY #1

//***********************************Entity Declaration************************
(* DowngradeIPIdentifiedWarnings="yes" *)
module gt_sfp_init #
(
    parameter EXAMPLE_SIM_GTRESET_SPEEDUP            = "FALSE",     // Simulation setting for GT SecureIP model
    parameter EXAMPLE_SIMULATION                     =  0,         // Set to 1 for simulation
    parameter STABLE_CLOCK_PERIOD                    = 10,         //Period of the stable clock driving this state-machine, unit is [ns]
    parameter EXAMPLE_USE_CHIPSCOPE                  =  0          // Set to 1 to use Chipscope to drive resets

)
(
input           sysclk_in,
input           soft_reset_tx_in,
input           soft_reset_rx_in,
input           dont_reset_on_data_error_in,
output          gt0_drp_busy_out,
output          gt0_tx_fsm_reset_done_out,
output          gt0_rx_fsm_reset_done_out,
input           gt0_data_valid_in,
output          gt1_drp_busy_out,
output          gt1_tx_fsm_reset_done_out,
output          gt1_rx_fsm_reset_done_out,
input           gt1_data_valid_in,
output          gt2_drp_busy_out,
output          gt2_tx_fsm_reset_done_out,
output          gt2_rx_fsm_reset_done_out,
input           gt2_data_valid_in,
output          gt3_drp_busy_out,
output          gt3_tx_fsm_reset_done_out,
output          gt3_rx_fsm_reset_done_out,
input           gt3_data_valid_in,

    //_________________________________________________________________________
    //GT0  (X1Y12)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt0_gtnorthrefclk0_in,
    input           gt0_gtnorthrefclk1_in,
    input           gt0_gtsouthrefclk0_in,
    input           gt0_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt0_drpaddr_in,
    input           gt0_drpclk_in,
    input   [15:0]  gt0_drpdi_in,
    output  [15:0]  gt0_drpdo_out,
    input           gt0_drpen_in,
    output          gt0_drprdy_out,
    input           gt0_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt0_eyescanreset_in,
    input           gt0_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt0_eyescandataerror_out,
    input           gt0_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt0_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt0_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX Interface Ports -----------------
    input           gt0_rxusrclk_in,
    input           gt0_rxusrclk2_in,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt0_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt0_rxdisperr_out,
    output  [1:0]   gt0_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt0_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt0_rxmonitorout_out,
    input   [1:0]   gt0_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt0_rxoutclk_out,
    output          gt0_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt0_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt0_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt0_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt0_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt0_gttxreset_in,
    input           gt0_txuserrdy_in,
    //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
    input           gt0_txusrclk_in,
    input           gt0_txusrclk2_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt0_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt0_gthtxn_out,
    output          gt0_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt0_txoutclk_out,
    output          gt0_txoutclkfabric_out,
    output          gt0_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt0_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt0_txcharisk_in,

    //GT1  (X1Y13)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt1_gtnorthrefclk0_in,
    input           gt1_gtnorthrefclk1_in,
    input           gt1_gtsouthrefclk0_in,
    input           gt1_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt1_drpaddr_in,
    input           gt1_drpclk_in,
    input   [15:0]  gt1_drpdi_in,
    output  [15:0]  gt1_drpdo_out,
    input           gt1_drpen_in,
    output          gt1_drprdy_out,
    input           gt1_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt1_eyescanreset_in,
    input           gt1_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt1_eyescandataerror_out,
    input           gt1_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt1_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt1_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX Interface Ports -----------------
    input           gt1_rxusrclk_in,
    input           gt1_rxusrclk2_in,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt1_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt1_rxdisperr_out,
    output  [1:0]   gt1_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt1_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt1_rxmonitorout_out,
    input   [1:0]   gt1_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt1_rxoutclk_out,
    output          gt1_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt1_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt1_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt1_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt1_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt1_gttxreset_in,
    input           gt1_txuserrdy_in,
    //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
    input           gt1_txusrclk_in,
    input           gt1_txusrclk2_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt1_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt1_gthtxn_out,
    output          gt1_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt1_txoutclk_out,
    output          gt1_txoutclkfabric_out,
    output          gt1_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt1_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt1_txcharisk_in,

    //GT2  (X1Y14)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt2_gtnorthrefclk0_in,
    input           gt2_gtnorthrefclk1_in,
    input           gt2_gtsouthrefclk0_in,
    input           gt2_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt2_drpaddr_in,
    input           gt2_drpclk_in,
    input   [15:0]  gt2_drpdi_in,
    output  [15:0]  gt2_drpdo_out,
    input           gt2_drpen_in,
    output          gt2_drprdy_out,
    input           gt2_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt2_eyescanreset_in,
    input           gt2_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt2_eyescandataerror_out,
    input           gt2_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt2_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt2_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX Interface Ports -----------------
    input           gt2_rxusrclk_in,
    input           gt2_rxusrclk2_in,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt2_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt2_rxdisperr_out,
    output  [1:0]   gt2_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt2_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt2_rxmonitorout_out,
    input   [1:0]   gt2_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt2_rxoutclk_out,
    output          gt2_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt2_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt2_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt2_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt2_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt2_gttxreset_in,
    input           gt2_txuserrdy_in,
    //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
    input           gt2_txusrclk_in,
    input           gt2_txusrclk2_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt2_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt2_gthtxn_out,
    output          gt2_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt2_txoutclk_out,
    output          gt2_txoutclkfabric_out,
    output          gt2_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt2_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt2_txcharisk_in,

    //GT3  (X1Y15)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt3_gtnorthrefclk0_in,
    input           gt3_gtnorthrefclk1_in,
    input           gt3_gtsouthrefclk0_in,
    input           gt3_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt3_drpaddr_in,
    input           gt3_drpclk_in,
    input   [15:0]  gt3_drpdi_in,
    output  [15:0]  gt3_drpdo_out,
    input           gt3_drpen_in,
    output          gt3_drprdy_out,
    input           gt3_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt3_eyescanreset_in,
    input           gt3_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt3_eyescandataerror_out,
    input           gt3_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt3_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt3_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX Interface Ports -----------------
    input           gt3_rxusrclk_in,
    input           gt3_rxusrclk2_in,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt3_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt3_rxdisperr_out,
    output  [1:0]   gt3_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt3_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt3_rxmonitorout_out,
    input   [1:0]   gt3_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt3_rxoutclk_out,
    output          gt3_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt3_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt3_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt3_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt3_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt3_gttxreset_in,
    input           gt3_txuserrdy_in,
    //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
    input           gt3_txusrclk_in,
    input           gt3_txusrclk2_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt3_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt3_gthtxn_out,
    output          gt3_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt3_txoutclk_out,
    output          gt3_txoutclkfabric_out,
    output          gt3_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt3_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt3_txcharisk_in,


    //____________________________COMMON PORTS________________________________
    input      gt0_qplllock_in,
    input      gt0_qpllrefclklost_in,
    output     gt0_qpllreset_out,
    input      gt0_qplloutclk_in,
    input      gt0_qplloutrefclk_in

);



//***********************************Parameter Declarations********************


    //Typical CDRLOCK Time is 50,000UI, as per DS183
    localparam RX_CDRLOCK_TIME      = (EXAMPLE_SIMULATION == 1) ? 1000 : 100000/2.00;
       
    localparam integer   WAIT_TIME_CDRLOCK    = RX_CDRLOCK_TIME / STABLE_CLOCK_PERIOD;      

//-------------------------- GT Wrapper Wires ------------------------------
    wire           gt0_rxpmaresetdone_i;
    wire           gt0_txpmaresetdone_i;
    wire           gt0_txresetdone_i;
    wire           gt0_txresetdone_ii;
    wire           gt0_rxresetdone_i;
    wire           gt0_rxresetdone_ii;
    wire           gt0_gttxreset_i;
    wire           gt0_gttxreset_t;
    wire           gt0_gtrxreset_i;
    wire           gt0_gtrxreset_t;
    wire           gt0_txuserrdy_i;
    wire           gt0_txuserrdy_t;
    wire           gt0_rxuserrdy_i;
    wire           gt0_rxuserrdy_t;

    wire           gt0_rxdfeagchold_i;
    wire           gt0_rxdfelfhold_i;
    wire           gt0_rxlpmlfhold_i;
    wire           gt0_rxlpmhfhold_i;


    wire           gt1_rxpmaresetdone_i;
    wire           gt1_txpmaresetdone_i;
    wire           gt1_txresetdone_i;
    wire           gt1_txresetdone_ii;
    wire           gt1_rxresetdone_i;
    wire           gt1_rxresetdone_ii;
    wire           gt1_gttxreset_i;
    wire           gt1_gttxreset_t;
    wire           gt1_gtrxreset_i;
    wire           gt1_gtrxreset_t;
    wire           gt1_txuserrdy_i;
    wire           gt1_txuserrdy_t;
    wire           gt1_rxuserrdy_i;
    wire           gt1_rxuserrdy_t;

    wire           gt1_rxdfeagchold_i;
    wire           gt1_rxdfelfhold_i;
    wire           gt1_rxlpmlfhold_i;
    wire           gt1_rxlpmhfhold_i;


    wire           gt2_rxpmaresetdone_i;
    wire           gt2_txpmaresetdone_i;
    wire           gt2_txresetdone_i;
    wire           gt2_txresetdone_ii;
    wire           gt2_rxresetdone_i;
    wire           gt2_rxresetdone_ii;
    wire           gt2_gttxreset_i;
    wire           gt2_gttxreset_t;
    wire           gt2_gtrxreset_i;
    wire           gt2_gtrxreset_t;
    wire           gt2_txuserrdy_i;
    wire           gt2_txuserrdy_t;
    wire           gt2_rxuserrdy_i;
    wire           gt2_rxuserrdy_t;

    wire           gt2_rxdfeagchold_i;
    wire           gt2_rxdfelfhold_i;
    wire           gt2_rxlpmlfhold_i;
    wire           gt2_rxlpmhfhold_i;


    wire           gt3_rxpmaresetdone_i;
    wire           gt3_txpmaresetdone_i;
    wire           gt3_txresetdone_i;
    wire           gt3_txresetdone_ii;
    wire           gt3_rxresetdone_i;
    wire           gt3_rxresetdone_ii;
    wire           gt3_gttxreset_i;
    wire           gt3_gttxreset_t;
    wire           gt3_gtrxreset_i;
    wire           gt3_gtrxreset_t;
    wire           gt3_txuserrdy_i;
    wire           gt3_txuserrdy_t;
    wire           gt3_rxuserrdy_i;
    wire           gt3_rxuserrdy_t;

    wire           gt3_rxdfeagchold_i;
    wire           gt3_rxdfelfhold_i;
    wire           gt3_rxlpmlfhold_i;
    wire           gt3_rxlpmhfhold_i;



    wire           gt0_qpllreset_i;
    wire           gt0_qpllreset_t;
    wire           gt0_qpllrefclklost_i;
    wire           gt0_qplllock_i;


//------------------------------- Global Signals -----------------------------
    wire          tied_to_ground_i;
    wire          tied_to_vcc_i;

    wire           gt0_txoutclk_i;
    wire           gt0_rxoutclk_i;
    wire           gt0_rxoutclk_i2;
    wire           gt0_txoutclk_i2;
    wire           gt0_recclk_stable_i;
    reg            gt0_rx_cdrlocked;
    integer  gt0_rx_cdrlock_counter= 0;

    wire           gt1_txoutclk_i;
    wire           gt1_rxoutclk_i;
    wire           gt1_rxoutclk_i2;
    wire           gt1_txoutclk_i2;
    wire           gt1_recclk_stable_i;
    reg            gt1_rx_cdrlocked;
    integer  gt1_rx_cdrlock_counter= 0;

    wire           gt2_txoutclk_i;
    wire           gt2_rxoutclk_i;
    wire           gt2_rxoutclk_i2;
    wire           gt2_txoutclk_i2;
    wire           gt2_recclk_stable_i;
    reg            gt2_rx_cdrlocked;
    integer  gt2_rx_cdrlock_counter= 0;

    wire           gt3_txoutclk_i;
    wire           gt3_rxoutclk_i;
    wire           gt3_rxoutclk_i2;
    wire           gt3_txoutclk_i2;
    wire           gt3_recclk_stable_i;
    reg            gt3_rx_cdrlocked;
    integer  gt3_rx_cdrlock_counter= 0;







reg              rx_cdrlocked;


 


//**************************** Main Body of Code *******************************
    //  Static signal Assigments
assign  tied_to_ground_i                     =  1'b0;
assign  tied_to_vcc_i                        =  1'b1;

//    ----------------------------- The GT Wrapper -----------------------------
    
    // Use the instantiation template in the example directory to add the GT wrapper to your design.
    // In this example, the wrapper is wired up for basic operation with a frame generator and frame 
    // checker. The GTs will reset, then attempt to align and transmit data. If channel bonding is 
    // enabled, bonding should occur after alignment.


    gt_sfp_multi_gt #
    (
        .EXAMPLE_SIMULATION             (EXAMPLE_SIMULATION),
        .WRAPPER_SIM_GTRESET_SPEEDUP    (EXAMPLE_SIM_GTRESET_SPEEDUP)
    )
    gt_sfp_i
    (
        .gt0_drp_busy_out               (gt0_drp_busy_out),
        .gt0_rxpmaresetdone_out         (gt0_rxpmaresetdone_i),
        .gt0_txpmaresetdone_out         (gt0_txpmaresetdone_i),
 
        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT0  (X1Y12)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt0_gtnorthrefclk0_in          (gt0_gtnorthrefclk0_in), // input wire gt0_gtnorthrefclk0_in
        .gt0_gtnorthrefclk1_in          (gt0_gtnorthrefclk1_in), // input wire gt0_gtnorthrefclk1_in
        .gt0_gtsouthrefclk0_in          (gt0_gtsouthrefclk0_in), // input wire gt0_gtsouthrefclk0_in
        .gt0_gtsouthrefclk1_in          (gt0_gtsouthrefclk1_in), // input wire gt0_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt0_drpaddr_in                 (gt0_drpaddr_in), // input wire [8:0] gt0_drpaddr_in
        .gt0_drpclk_in                  (gt0_drpclk_in), // input wire gt0_drpclk_in
        .gt0_drpdi_in                   (gt0_drpdi_in), // input wire [15:0] gt0_drpdi_in
        .gt0_drpdo_out                  (gt0_drpdo_out), // output wire [15:0] gt0_drpdo_out
        .gt0_drpen_in                   (gt0_drpen_in), // input wire gt0_drpen_in
        .gt0_drprdy_out                 (gt0_drprdy_out), // output wire gt0_drprdy_out
        .gt0_drpwe_in                   (gt0_drpwe_in), // input wire gt0_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt0_eyescanreset_in            (gt0_eyescanreset_in), // input wire gt0_eyescanreset_in
        .gt0_rxuserrdy_in               (gt0_rxuserrdy_i), // input wire gt0_rxuserrdy_i
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt0_eyescandataerror_out       (gt0_eyescandataerror_out), // output wire gt0_eyescandataerror_out
        .gt0_eyescantrigger_in          (gt0_eyescantrigger_in), // input wire gt0_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt0_rxclkcorcnt_out            (gt0_rxclkcorcnt_out), // output wire [1:0] gt0_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt0_dmonitorout_out            (gt0_dmonitorout_out), // output wire [14:0] gt0_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt0_rxusrclk_in                (gt0_rxusrclk_in), // input wire gt0_rxusrclk_in
        .gt0_rxusrclk2_in               (gt0_rxusrclk2_in), // input wire gt0_rxusrclk2_in
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt0_rxdata_out                 (gt0_rxdata_out), // output wire [15:0] gt0_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt0_rxdisperr_out              (gt0_rxdisperr_out), // output wire [1:0] gt0_rxdisperr_out
        .gt0_rxnotintable_out           (gt0_rxnotintable_out), // output wire [1:0] gt0_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt0_gthrxn_in                  (gt0_gthrxn_in), // input wire gt0_gthrxn_in
        //------------------ Receive Ports - RX Equailizer Ports -------------------
        .gt0_rxlpmhfhold_in             (gt0_rxlpmhfhold_i), // input wire gt0_rxlpmhfhold_i
        .gt0_rxlpmlfhold_in             (gt0_rxlpmlfhold_i), // input wire gt0_rxlpmlfhold_i
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt0_rxmonitorout_out           (gt0_rxmonitorout_out), // output wire [6:0] gt0_rxmonitorout_out
        .gt0_rxmonitorsel_in            (gt0_rxmonitorsel_in), // input wire [1:0] gt0_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt0_rxoutclk_out               (gt0_rxoutclk_i), // output wire gt0_rxoutclk_i
        .gt0_rxoutclkfabric_out         (gt0_rxoutclkfabric_out), // output wire gt0_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt0_gtrxreset_in               (gt0_gtrxreset_i), // input wire gt0_gtrxreset_i
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt0_rxcharisk_out              (gt0_rxcharisk_out), // output wire [1:0] gt0_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt0_gthrxp_in                  (gt0_gthrxp_in), // input wire gt0_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt0_rxresetdone_out            (gt0_rxresetdone_i), // output wire gt0_rxresetdone_i
        //------------------- TX Initialization and Reset Ports --------------------
        .gt0_gttxreset_in               (gt0_gttxreset_i), // input wire gt0_gttxreset_i
        .gt0_txuserrdy_in               (gt0_txuserrdy_i), // input wire gt0_txuserrdy_i
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt0_txusrclk_in                (gt0_txusrclk_in), // input wire gt0_txusrclk_in
        .gt0_txusrclk2_in               (gt0_txusrclk2_in), // input wire gt0_txusrclk2_in
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt0_txdata_in                  (gt0_txdata_in), // input wire [15:0] gt0_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt0_gthtxn_out                 (gt0_gthtxn_out), // output wire gt0_gthtxn_out
        .gt0_gthtxp_out                 (gt0_gthtxp_out), // output wire gt0_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt0_txoutclk_out               (gt0_txoutclk_i), // output wire gt0_txoutclk_i
        .gt0_txoutclkfabric_out         (gt0_txoutclkfabric_out), // output wire gt0_txoutclkfabric_out
        .gt0_txoutclkpcs_out            (gt0_txoutclkpcs_out), // output wire gt0_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt0_txresetdone_out            (gt0_txresetdone_i), // output wire gt0_txresetdone_i
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt0_txcharisk_in               (gt0_txcharisk_in), // input wire [1:0] gt0_txcharisk_in


        .gt1_drp_busy_out               (gt1_drp_busy_out),
        .gt1_rxpmaresetdone_out         (gt1_rxpmaresetdone_i),
        .gt1_txpmaresetdone_out         (gt1_txpmaresetdone_i),
 
        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT1  (X1Y13)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt1_gtnorthrefclk0_in          (gt1_gtnorthrefclk0_in), // input wire gt1_gtnorthrefclk0_in
        .gt1_gtnorthrefclk1_in          (gt1_gtnorthrefclk1_in), // input wire gt1_gtnorthrefclk1_in
        .gt1_gtsouthrefclk0_in          (gt1_gtsouthrefclk0_in), // input wire gt1_gtsouthrefclk0_in
        .gt1_gtsouthrefclk1_in          (gt1_gtsouthrefclk1_in), // input wire gt1_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt1_drpaddr_in                 (gt1_drpaddr_in), // input wire [8:0] gt1_drpaddr_in
        .gt1_drpclk_in                  (gt1_drpclk_in), // input wire gt1_drpclk_in
        .gt1_drpdi_in                   (gt1_drpdi_in), // input wire [15:0] gt1_drpdi_in
        .gt1_drpdo_out                  (gt1_drpdo_out), // output wire [15:0] gt1_drpdo_out
        .gt1_drpen_in                   (gt1_drpen_in), // input wire gt1_drpen_in
        .gt1_drprdy_out                 (gt1_drprdy_out), // output wire gt1_drprdy_out
        .gt1_drpwe_in                   (gt1_drpwe_in), // input wire gt1_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt1_eyescanreset_in            (gt1_eyescanreset_in), // input wire gt1_eyescanreset_in
        .gt1_rxuserrdy_in               (gt1_rxuserrdy_i), // input wire gt1_rxuserrdy_i
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt1_eyescandataerror_out       (gt1_eyescandataerror_out), // output wire gt1_eyescandataerror_out
        .gt1_eyescantrigger_in          (gt1_eyescantrigger_in), // input wire gt1_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt1_rxclkcorcnt_out            (gt1_rxclkcorcnt_out), // output wire [1:0] gt1_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt1_dmonitorout_out            (gt1_dmonitorout_out), // output wire [14:0] gt1_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt1_rxusrclk_in                (gt1_rxusrclk_in), // input wire gt1_rxusrclk_in
        .gt1_rxusrclk2_in               (gt1_rxusrclk2_in), // input wire gt1_rxusrclk2_in
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt1_rxdata_out                 (gt1_rxdata_out), // output wire [15:0] gt1_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt1_rxdisperr_out              (gt1_rxdisperr_out), // output wire [1:0] gt1_rxdisperr_out
        .gt1_rxnotintable_out           (gt1_rxnotintable_out), // output wire [1:0] gt1_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt1_gthrxn_in                  (gt1_gthrxn_in), // input wire gt1_gthrxn_in
        //------------------ Receive Ports - RX Equailizer Ports -------------------
        .gt1_rxlpmhfhold_in             (gt1_rxlpmhfhold_i), // input wire gt1_rxlpmhfhold_i
        .gt1_rxlpmlfhold_in             (gt1_rxlpmlfhold_i), // input wire gt1_rxlpmlfhold_i
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt1_rxmonitorout_out           (gt1_rxmonitorout_out), // output wire [6:0] gt1_rxmonitorout_out
        .gt1_rxmonitorsel_in            (gt1_rxmonitorsel_in), // input wire [1:0] gt1_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt1_rxoutclk_out               (gt1_rxoutclk_i), // output wire gt1_rxoutclk_i
        .gt1_rxoutclkfabric_out         (gt1_rxoutclkfabric_out), // output wire gt1_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt1_gtrxreset_in               (gt1_gtrxreset_i), // input wire gt1_gtrxreset_i
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt1_rxcharisk_out              (gt1_rxcharisk_out), // output wire [1:0] gt1_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt1_gthrxp_in                  (gt1_gthrxp_in), // input wire gt1_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt1_rxresetdone_out            (gt1_rxresetdone_i), // output wire gt1_rxresetdone_i
        //------------------- TX Initialization and Reset Ports --------------------
        .gt1_gttxreset_in               (gt1_gttxreset_i), // input wire gt1_gttxreset_i
        .gt1_txuserrdy_in               (gt1_txuserrdy_i), // input wire gt1_txuserrdy_i
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt1_txusrclk_in                (gt1_txusrclk_in), // input wire gt1_txusrclk_in
        .gt1_txusrclk2_in               (gt1_txusrclk2_in), // input wire gt1_txusrclk2_in
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt1_txdata_in                  (gt1_txdata_in), // input wire [15:0] gt1_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt1_gthtxn_out                 (gt1_gthtxn_out), // output wire gt1_gthtxn_out
        .gt1_gthtxp_out                 (gt1_gthtxp_out), // output wire gt1_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt1_txoutclk_out               (gt1_txoutclk_i), // output wire gt1_txoutclk_i
        .gt1_txoutclkfabric_out         (gt1_txoutclkfabric_out), // output wire gt1_txoutclkfabric_out
        .gt1_txoutclkpcs_out            (gt1_txoutclkpcs_out), // output wire gt1_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt1_txresetdone_out            (gt1_txresetdone_i), // output wire gt1_txresetdone_i
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt1_txcharisk_in               (gt1_txcharisk_in), // input wire [1:0] gt1_txcharisk_in


        .gt2_drp_busy_out               (gt2_drp_busy_out),
        .gt2_rxpmaresetdone_out         (gt2_rxpmaresetdone_i),
        .gt2_txpmaresetdone_out         (gt2_txpmaresetdone_i),
 
        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT2  (X1Y14)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt2_gtnorthrefclk0_in          (gt2_gtnorthrefclk0_in), // input wire gt2_gtnorthrefclk0_in
        .gt2_gtnorthrefclk1_in          (gt2_gtnorthrefclk1_in), // input wire gt2_gtnorthrefclk1_in
        .gt2_gtsouthrefclk0_in          (gt2_gtsouthrefclk0_in), // input wire gt2_gtsouthrefclk0_in
        .gt2_gtsouthrefclk1_in          (gt2_gtsouthrefclk1_in), // input wire gt2_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt2_drpaddr_in                 (gt2_drpaddr_in), // input wire [8:0] gt2_drpaddr_in
        .gt2_drpclk_in                  (gt2_drpclk_in), // input wire gt2_drpclk_in
        .gt2_drpdi_in                   (gt2_drpdi_in), // input wire [15:0] gt2_drpdi_in
        .gt2_drpdo_out                  (gt2_drpdo_out), // output wire [15:0] gt2_drpdo_out
        .gt2_drpen_in                   (gt2_drpen_in), // input wire gt2_drpen_in
        .gt2_drprdy_out                 (gt2_drprdy_out), // output wire gt2_drprdy_out
        .gt2_drpwe_in                   (gt2_drpwe_in), // input wire gt2_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt2_eyescanreset_in            (gt2_eyescanreset_in), // input wire gt2_eyescanreset_in
        .gt2_rxuserrdy_in               (gt2_rxuserrdy_i), // input wire gt2_rxuserrdy_i
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt2_eyescandataerror_out       (gt2_eyescandataerror_out), // output wire gt2_eyescandataerror_out
        .gt2_eyescantrigger_in          (gt2_eyescantrigger_in), // input wire gt2_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt2_rxclkcorcnt_out            (gt2_rxclkcorcnt_out), // output wire [1:0] gt2_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt2_dmonitorout_out            (gt2_dmonitorout_out), // output wire [14:0] gt2_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt2_rxusrclk_in                (gt2_rxusrclk_in), // input wire gt2_rxusrclk_in
        .gt2_rxusrclk2_in               (gt2_rxusrclk2_in), // input wire gt2_rxusrclk2_in
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt2_rxdata_out                 (gt2_rxdata_out), // output wire [15:0] gt2_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt2_rxdisperr_out              (gt2_rxdisperr_out), // output wire [1:0] gt2_rxdisperr_out
        .gt2_rxnotintable_out           (gt2_rxnotintable_out), // output wire [1:0] gt2_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt2_gthrxn_in                  (gt2_gthrxn_in), // input wire gt2_gthrxn_in
        //------------------ Receive Ports - RX Equailizer Ports -------------------
        .gt2_rxlpmhfhold_in             (gt2_rxlpmhfhold_i), // input wire gt2_rxlpmhfhold_i
        .gt2_rxlpmlfhold_in             (gt2_rxlpmlfhold_i), // input wire gt2_rxlpmlfhold_i
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt2_rxmonitorout_out           (gt2_rxmonitorout_out), // output wire [6:0] gt2_rxmonitorout_out
        .gt2_rxmonitorsel_in            (gt2_rxmonitorsel_in), // input wire [1:0] gt2_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt2_rxoutclk_out               (gt2_rxoutclk_i), // output wire gt2_rxoutclk_i
        .gt2_rxoutclkfabric_out         (gt2_rxoutclkfabric_out), // output wire gt2_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt2_gtrxreset_in               (gt2_gtrxreset_i), // input wire gt2_gtrxreset_i
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt2_rxcharisk_out              (gt2_rxcharisk_out), // output wire [1:0] gt2_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt2_gthrxp_in                  (gt2_gthrxp_in), // input wire gt2_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt2_rxresetdone_out            (gt2_rxresetdone_i), // output wire gt2_rxresetdone_i
        //------------------- TX Initialization and Reset Ports --------------------
        .gt2_gttxreset_in               (gt2_gttxreset_i), // input wire gt2_gttxreset_i
        .gt2_txuserrdy_in               (gt2_txuserrdy_i), // input wire gt2_txuserrdy_i
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt2_txusrclk_in                (gt2_txusrclk_in), // input wire gt2_txusrclk_in
        .gt2_txusrclk2_in               (gt2_txusrclk2_in), // input wire gt2_txusrclk2_in
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt2_txdata_in                  (gt2_txdata_in), // input wire [15:0] gt2_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt2_gthtxn_out                 (gt2_gthtxn_out), // output wire gt2_gthtxn_out
        .gt2_gthtxp_out                 (gt2_gthtxp_out), // output wire gt2_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt2_txoutclk_out               (gt2_txoutclk_i), // output wire gt2_txoutclk_i
        .gt2_txoutclkfabric_out         (gt2_txoutclkfabric_out), // output wire gt2_txoutclkfabric_out
        .gt2_txoutclkpcs_out            (gt2_txoutclkpcs_out), // output wire gt2_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt2_txresetdone_out            (gt2_txresetdone_i), // output wire gt2_txresetdone_i
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt2_txcharisk_in               (gt2_txcharisk_in), // input wire [1:0] gt2_txcharisk_in


        .gt3_drp_busy_out               (gt3_drp_busy_out),
        .gt3_rxpmaresetdone_out         (gt3_rxpmaresetdone_i),
        .gt3_txpmaresetdone_out         (gt3_txpmaresetdone_i),
 
        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT3  (X1Y15)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt3_gtnorthrefclk0_in          (gt3_gtnorthrefclk0_in), // input wire gt3_gtnorthrefclk0_in
        .gt3_gtnorthrefclk1_in          (gt3_gtnorthrefclk1_in), // input wire gt3_gtnorthrefclk1_in
        .gt3_gtsouthrefclk0_in          (gt3_gtsouthrefclk0_in), // input wire gt3_gtsouthrefclk0_in
        .gt3_gtsouthrefclk1_in          (gt3_gtsouthrefclk1_in), // input wire gt3_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt3_drpaddr_in                 (gt3_drpaddr_in), // input wire [8:0] gt3_drpaddr_in
        .gt3_drpclk_in                  (gt3_drpclk_in), // input wire gt3_drpclk_in
        .gt3_drpdi_in                   (gt3_drpdi_in), // input wire [15:0] gt3_drpdi_in
        .gt3_drpdo_out                  (gt3_drpdo_out), // output wire [15:0] gt3_drpdo_out
        .gt3_drpen_in                   (gt3_drpen_in), // input wire gt3_drpen_in
        .gt3_drprdy_out                 (gt3_drprdy_out), // output wire gt3_drprdy_out
        .gt3_drpwe_in                   (gt3_drpwe_in), // input wire gt3_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt3_eyescanreset_in            (gt3_eyescanreset_in), // input wire gt3_eyescanreset_in
        .gt3_rxuserrdy_in               (gt3_rxuserrdy_i), // input wire gt3_rxuserrdy_i
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt3_eyescandataerror_out       (gt3_eyescandataerror_out), // output wire gt3_eyescandataerror_out
        .gt3_eyescantrigger_in          (gt3_eyescantrigger_in), // input wire gt3_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt3_rxclkcorcnt_out            (gt3_rxclkcorcnt_out), // output wire [1:0] gt3_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt3_dmonitorout_out            (gt3_dmonitorout_out), // output wire [14:0] gt3_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt3_rxusrclk_in                (gt3_rxusrclk_in), // input wire gt3_rxusrclk_in
        .gt3_rxusrclk2_in               (gt3_rxusrclk2_in), // input wire gt3_rxusrclk2_in
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt3_rxdata_out                 (gt3_rxdata_out), // output wire [15:0] gt3_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt3_rxdisperr_out              (gt3_rxdisperr_out), // output wire [1:0] gt3_rxdisperr_out
        .gt3_rxnotintable_out           (gt3_rxnotintable_out), // output wire [1:0] gt3_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt3_gthrxn_in                  (gt3_gthrxn_in), // input wire gt3_gthrxn_in
        //------------------ Receive Ports - RX Equailizer Ports -------------------
        .gt3_rxlpmhfhold_in             (gt3_rxlpmhfhold_i), // input wire gt3_rxlpmhfhold_i
        .gt3_rxlpmlfhold_in             (gt3_rxlpmlfhold_i), // input wire gt3_rxlpmlfhold_i
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt3_rxmonitorout_out           (gt3_rxmonitorout_out), // output wire [6:0] gt3_rxmonitorout_out
        .gt3_rxmonitorsel_in            (gt3_rxmonitorsel_in), // input wire [1:0] gt3_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt3_rxoutclk_out               (gt3_rxoutclk_i), // output wire gt3_rxoutclk_i
        .gt3_rxoutclkfabric_out         (gt3_rxoutclkfabric_out), // output wire gt3_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt3_gtrxreset_in               (gt3_gtrxreset_i), // input wire gt3_gtrxreset_i
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt3_rxcharisk_out              (gt3_rxcharisk_out), // output wire [1:0] gt3_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt3_gthrxp_in                  (gt3_gthrxp_in), // input wire gt3_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt3_rxresetdone_out            (gt3_rxresetdone_i), // output wire gt3_rxresetdone_i
        //------------------- TX Initialization and Reset Ports --------------------
        .gt3_gttxreset_in               (gt3_gttxreset_i), // input wire gt3_gttxreset_i
        .gt3_txuserrdy_in               (gt3_txuserrdy_i), // input wire gt3_txuserrdy_i
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt3_txusrclk_in                (gt3_txusrclk_in), // input wire gt3_txusrclk_in
        .gt3_txusrclk2_in               (gt3_txusrclk2_in), // input wire gt3_txusrclk2_in
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt3_txdata_in                  (gt3_txdata_in), // input wire [15:0] gt3_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt3_gthtxn_out                 (gt3_gthtxn_out), // output wire gt3_gthtxn_out
        .gt3_gthtxp_out                 (gt3_gthtxp_out), // output wire gt3_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt3_txoutclk_out               (gt3_txoutclk_i), // output wire gt3_txoutclk_i
        .gt3_txoutclkfabric_out         (gt3_txoutclkfabric_out), // output wire gt3_txoutclkfabric_out
        .gt3_txoutclkpcs_out            (gt3_txoutclkpcs_out), // output wire gt3_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt3_txresetdone_out            (gt3_txresetdone_i), // output wire gt3_txresetdone_i
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt3_txcharisk_in               (gt3_txcharisk_in), // input wire [1:0] gt3_txcharisk_in




    //____________________________COMMON PORTS________________________________
        .gt0_qpllreset_in               (gt0_qpllreset_t),
        .gt0_qplloutclk_in              (gt0_qplloutclk_in),
        .gt0_qplloutrefclk_in           (gt0_qplloutrefclk_in)

    );




assign  gt0_txresetdone_out                  =  gt0_txresetdone_i;
assign  gt0_rxresetdone_out                  =  gt0_rxresetdone_i;
assign  gt0_rxoutclk_out                     =  gt0_rxoutclk_i;
assign  gt0_txoutclk_out                     =  gt0_txoutclk_i;
assign  gt1_txresetdone_out                  =  gt1_txresetdone_i;
assign  gt1_rxresetdone_out                  =  gt1_rxresetdone_i;
assign  gt1_rxoutclk_out                     =  gt1_rxoutclk_i;
assign  gt1_txoutclk_out                     =  gt1_txoutclk_i;
assign  gt2_txresetdone_out                  =  gt2_txresetdone_i;
assign  gt2_rxresetdone_out                  =  gt2_rxresetdone_i;
assign  gt2_rxoutclk_out                     =  gt2_rxoutclk_i;
assign  gt2_txoutclk_out                     =  gt2_txoutclk_i;
assign  gt3_txresetdone_out                  =  gt3_txresetdone_i;
assign  gt3_rxresetdone_out                  =  gt3_rxresetdone_i;
assign  gt3_rxoutclk_out                     =  gt3_rxoutclk_i;
assign  gt3_txoutclk_out                     =  gt3_txoutclk_i;
assign  gt0_qpllreset_out                    =  gt0_qpllreset_t;

generate
if (EXAMPLE_USE_CHIPSCOPE == 1) 
begin : chipscope
assign  gt0_gttxreset_i                      =  gt0_gttxreset_in || gt0_gttxreset_t;
assign  gt0_gtrxreset_i                      =  gt0_gtrxreset_in || gt0_gtrxreset_t;
assign  gt0_txuserrdy_i                      =  gt0_txuserrdy_in && gt0_txuserrdy_t;
assign  gt0_rxuserrdy_i                      =  gt0_rxuserrdy_in && gt0_rxuserrdy_t;
assign  gt1_gttxreset_i                      =  gt1_gttxreset_in || gt1_gttxreset_t;
assign  gt1_gtrxreset_i                      =  gt1_gtrxreset_in || gt1_gtrxreset_t;
assign  gt1_txuserrdy_i                      =  gt1_txuserrdy_in && gt1_txuserrdy_t;
assign  gt1_rxuserrdy_i                      =  gt1_rxuserrdy_in && gt1_rxuserrdy_t;
assign  gt2_gttxreset_i                      =  gt2_gttxreset_in || gt2_gttxreset_t;
assign  gt2_gtrxreset_i                      =  gt2_gtrxreset_in || gt2_gtrxreset_t;
assign  gt2_txuserrdy_i                      =  gt2_txuserrdy_in && gt2_txuserrdy_t;
assign  gt2_rxuserrdy_i                      =  gt2_rxuserrdy_in && gt2_rxuserrdy_t;
assign  gt3_gttxreset_i                      =  gt3_gttxreset_in || gt3_gttxreset_t;
assign  gt3_gtrxreset_i                      =  gt3_gtrxreset_in || gt3_gtrxreset_t;
assign  gt3_txuserrdy_i                      =  gt3_txuserrdy_in && gt3_txuserrdy_t;
assign  gt3_rxuserrdy_i                      =  gt3_rxuserrdy_in && gt3_rxuserrdy_t;
end
endgenerate 

generate
if (EXAMPLE_USE_CHIPSCOPE == 0) 
begin : no_chipscope
assign  gt0_gttxreset_i                      =  gt0_gttxreset_t;
assign  gt0_gtrxreset_i                      =  gt0_gtrxreset_t;
assign  gt0_txuserrdy_i                      =  gt0_txuserrdy_t;
assign  gt0_rxuserrdy_i                      =  gt0_rxuserrdy_t;
assign  gt1_gttxreset_i                      =  gt1_gttxreset_t;
assign  gt1_gtrxreset_i                      =  gt1_gtrxreset_t;
assign  gt1_txuserrdy_i                      =  gt1_txuserrdy_t;
assign  gt1_rxuserrdy_i                      =  gt1_rxuserrdy_t;
assign  gt2_gttxreset_i                      =  gt2_gttxreset_t;
assign  gt2_gtrxreset_i                      =  gt2_gtrxreset_t;
assign  gt2_txuserrdy_i                      =  gt2_txuserrdy_t;
assign  gt2_rxuserrdy_i                      =  gt2_rxuserrdy_t;
assign  gt3_gttxreset_i                      =  gt3_gttxreset_t;
assign  gt3_gtrxreset_i                      =  gt3_gtrxreset_t;
assign  gt3_txuserrdy_i                      =  gt3_txuserrdy_t;
assign  gt3_rxuserrdy_i                      =  gt3_rxuserrdy_t;
end
endgenerate 


gt_sfp_TX_STARTUP_FSM #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),           // Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                        // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                        // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")               // Decision if a manual phase-alignment is necessary or the automatic 
                                                                     // is enough. For single-lane applications the automatic alignment is 
                                                                     // sufficient              
             ) 
gt0_txresetfsm_i      
            ( 
        .STABLE_CLOCK                   (sysclk_in),
        .TXUSERCLK                      (gt0_txusrclk_in),
        .SOFT_RESET                     (soft_reset_tx_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .TXRESETDONE                    (gt0_txresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .GTTXRESET                      (gt0_gttxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (gt0_qpllreset_t),
        .CPLL_RESET                     (),
        .TX_FSM_RESET_DONE              (gt0_tx_fsm_reset_done_out),
        .TXUSERRDY                      (gt0_txuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RETRY_COUNTER                  ()
           );


gt_sfp_TX_STARTUP_FSM #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),           // Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                        // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                        // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")               // Decision if a manual phase-alignment is necessary or the automatic 
                                                                     // is enough. For single-lane applications the automatic alignment is 
                                                                     // sufficient              
             ) 
gt1_txresetfsm_i      
            ( 
        .STABLE_CLOCK                   (sysclk_in),
        .TXUSERCLK                      (gt1_txusrclk_in),
        .SOFT_RESET                     (soft_reset_tx_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .TXRESETDONE                    (gt1_txresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .GTTXRESET                      (gt1_gttxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .TX_FSM_RESET_DONE              (gt1_tx_fsm_reset_done_out),
        .TXUSERRDY                      (gt1_txuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RETRY_COUNTER                  ()
           );


gt_sfp_TX_STARTUP_FSM #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),           // Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                        // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                        // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")               // Decision if a manual phase-alignment is necessary or the automatic 
                                                                     // is enough. For single-lane applications the automatic alignment is 
                                                                     // sufficient              
             ) 
gt2_txresetfsm_i      
            ( 
        .STABLE_CLOCK                   (sysclk_in),
        .TXUSERCLK                      (gt2_txusrclk_in),
        .SOFT_RESET                     (soft_reset_tx_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .TXRESETDONE                    (gt2_txresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .GTTXRESET                      (gt2_gttxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .TX_FSM_RESET_DONE              (gt2_tx_fsm_reset_done_out),
        .TXUSERRDY                      (gt2_txuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RETRY_COUNTER                  ()
           );


gt_sfp_TX_STARTUP_FSM #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),           // Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                        // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                        // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")               // Decision if a manual phase-alignment is necessary or the automatic 
                                                                     // is enough. For single-lane applications the automatic alignment is 
                                                                     // sufficient              
             ) 
gt3_txresetfsm_i      
            ( 
        .STABLE_CLOCK                   (sysclk_in),
        .TXUSERCLK                      (gt3_txusrclk_in),
        .SOFT_RESET                     (soft_reset_tx_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .TXRESETDONE                    (gt3_txresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .GTTXRESET                      (gt3_gttxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .TX_FSM_RESET_DONE              (gt3_tx_fsm_reset_done_out),
        .TXUSERRDY                      (gt3_txuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RETRY_COUNTER                  ()
           );





gt_sfp_RX_STARTUP_FSM  #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .EQ_MODE                  ("LPM"),                   //Rx Equalization Mode - Set to DFE or LPM
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),              //Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                           // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                           // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")                 // Decision if a manual phase-alignment is necessary or the automatic 
                                                                         // is enough. For single-lane applications the automatic alignment is 
                                                                         // sufficient              
             )     
gt0_rxresetfsm_i
             ( 
        .STABLE_CLOCK                   (sysclk_in),
        .RXUSERCLK                      (gt0_rxusrclk_in),
        .SOFT_RESET                     (soft_reset_rx_in),
        .RXPMARESETDONE                 (gt0_rxpmaresetdone_i),
        .RXOUTCLK                       (gt0_rxusrclk_in),
        .DONT_RESET_ON_DATA_ERROR       (dont_reset_on_data_error_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .RXRESETDONE                    (gt0_rxresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .RECCLK_STABLE                  (gt0_recclk_stable_i),
        .RECCLK_MONITOR_RESTART         (tied_to_ground_i),
        .DATA_VALID                     (gt0_data_valid_in),
        .TXUSERRDY                      (tied_to_vcc_i),
        .GTRXRESET                      (gt0_gtrxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .RX_FSM_RESET_DONE              (gt0_rx_fsm_reset_done_out),
        .RXUSERRDY                      (gt0_rxuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RXDFEAGCHOLD                   (gt0_rxdfeagchold_i),
        .RXDFELFHOLD                    (gt0_rxdfelfhold_i),
        .RXLPMLFHOLD                    (gt0_rxlpmlfhold_i),
        .RXLPMHFHOLD                    (gt0_rxlpmhfhold_i),
        .RETRY_COUNTER                  ()
           );

gt_sfp_RX_STARTUP_FSM  #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .EQ_MODE                  ("LPM"),                   //Rx Equalization Mode - Set to DFE or LPM
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),              //Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                           // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                           // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")                 // Decision if a manual phase-alignment is necessary or the automatic 
                                                                         // is enough. For single-lane applications the automatic alignment is 
                                                                         // sufficient              
             )     
gt1_rxresetfsm_i
             ( 
        .STABLE_CLOCK                   (sysclk_in),
        .RXUSERCLK                      (gt1_rxusrclk_in),
        .SOFT_RESET                     (soft_reset_rx_in),
        .RXPMARESETDONE                 (gt1_rxpmaresetdone_i),
        .RXOUTCLK                       (gt1_rxusrclk_in),
        .DONT_RESET_ON_DATA_ERROR       (dont_reset_on_data_error_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .RXRESETDONE                    (gt1_rxresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .RECCLK_STABLE                  (gt1_recclk_stable_i),
        .RECCLK_MONITOR_RESTART         (tied_to_ground_i),
        .DATA_VALID                     (gt1_data_valid_in),
        .TXUSERRDY                      (tied_to_vcc_i),
        .GTRXRESET                      (gt1_gtrxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .RX_FSM_RESET_DONE              (gt1_rx_fsm_reset_done_out),
        .RXUSERRDY                      (gt1_rxuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RXDFEAGCHOLD                   (gt1_rxdfeagchold_i),
        .RXDFELFHOLD                    (gt1_rxdfelfhold_i),
        .RXLPMLFHOLD                    (gt1_rxlpmlfhold_i),
        .RXLPMHFHOLD                    (gt1_rxlpmhfhold_i),
        .RETRY_COUNTER                  ()
           );

gt_sfp_RX_STARTUP_FSM  #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .EQ_MODE                  ("LPM"),                   //Rx Equalization Mode - Set to DFE or LPM
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),              //Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                           // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                           // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")                 // Decision if a manual phase-alignment is necessary or the automatic 
                                                                         // is enough. For single-lane applications the automatic alignment is 
                                                                         // sufficient              
             )     
gt2_rxresetfsm_i
             ( 
        .STABLE_CLOCK                   (sysclk_in),
        .RXUSERCLK                      (gt2_rxusrclk_in),
        .SOFT_RESET                     (soft_reset_rx_in),
        .RXPMARESETDONE                 (gt2_rxpmaresetdone_i),
        .RXOUTCLK                       (gt2_rxusrclk_in),
        .DONT_RESET_ON_DATA_ERROR       (dont_reset_on_data_error_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .RXRESETDONE                    (gt2_rxresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .RECCLK_STABLE                  (gt2_recclk_stable_i),
        .RECCLK_MONITOR_RESTART         (tied_to_ground_i),
        .DATA_VALID                     (gt2_data_valid_in),
        .TXUSERRDY                      (tied_to_vcc_i),
        .GTRXRESET                      (gt2_gtrxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .RX_FSM_RESET_DONE              (gt2_rx_fsm_reset_done_out),
        .RXUSERRDY                      (gt2_rxuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RXDFEAGCHOLD                   (gt2_rxdfeagchold_i),
        .RXDFELFHOLD                    (gt2_rxdfelfhold_i),
        .RXLPMLFHOLD                    (gt2_rxlpmlfhold_i),
        .RXLPMHFHOLD                    (gt2_rxlpmhfhold_i),
        .RETRY_COUNTER                  ()
           );

gt_sfp_RX_STARTUP_FSM  #
          (
           .EXAMPLE_SIMULATION       (EXAMPLE_SIMULATION),
           .EQ_MODE                  ("LPM"),                   //Rx Equalization Mode - Set to DFE or LPM
           .STABLE_CLOCK_PERIOD      (STABLE_CLOCK_PERIOD),              //Period of the stable clock driving this state-machine, unit is [ns]
           .RETRY_COUNTER_BITWIDTH   (8), 
           .TX_QPLL_USED             ("TRUE"),                           // the TX and RX Reset FSMs must 
           .RX_QPLL_USED             ("TRUE"),                           // share these two generic values
           .PHASE_ALIGNMENT_MANUAL   ("FALSE")                 // Decision if a manual phase-alignment is necessary or the automatic 
                                                                         // is enough. For single-lane applications the automatic alignment is 
                                                                         // sufficient              
             )     
gt3_rxresetfsm_i
             ( 
        .STABLE_CLOCK                   (sysclk_in),
        .RXUSERCLK                      (gt3_rxusrclk_in),
        .SOFT_RESET                     (soft_reset_rx_in),
        .RXPMARESETDONE                 (gt3_rxpmaresetdone_i),
        .RXOUTCLK                       (gt3_rxusrclk_in),
        .DONT_RESET_ON_DATA_ERROR       (dont_reset_on_data_error_in),
        .QPLLREFCLKLOST                 (gt0_qpllrefclklost_in),
        .CPLLREFCLKLOST                 (tied_to_ground_i),
        .QPLLLOCK                       (gt0_qplllock_in),
        .CPLLLOCK                       (tied_to_vcc_i),
        .RXRESETDONE                    (gt3_rxresetdone_i),
        .MMCM_LOCK                      (tied_to_vcc_i),
        .RECCLK_STABLE                  (gt3_recclk_stable_i),
        .RECCLK_MONITOR_RESTART         (tied_to_ground_i),
        .DATA_VALID                     (gt3_data_valid_in),
        .TXUSERRDY                      (tied_to_vcc_i),
        .GTRXRESET                      (gt3_gtrxreset_t),
        .MMCM_RESET                     (),
        .QPLL_RESET                     (),
        .CPLL_RESET                     (),
        .RX_FSM_RESET_DONE              (gt3_rx_fsm_reset_done_out),
        .RXUSERRDY                      (gt3_rxuserrdy_t),
        .RUN_PHALIGNMENT                (),
        .RESET_PHALIGNMENT              (),
        .PHALIGNMENT_DONE               (tied_to_vcc_i),
        .RXDFEAGCHOLD                   (gt3_rxdfeagchold_i),
        .RXDFELFHOLD                    (gt3_rxdfelfhold_i),
        .RXLPMLFHOLD                    (gt3_rxlpmlfhold_i),
        .RXLPMHFHOLD                    (gt3_rxlpmhfhold_i),
        .RETRY_COUNTER                  ()
           );

  always @(posedge sysclk_in)
  begin
        if(gt0_gtrxreset_i)
        begin
          gt0_rx_cdrlocked       <= `DLY    1'b0;
          gt0_rx_cdrlock_counter <= `DLY    0;      
        end                
        else if (gt0_rx_cdrlock_counter == WAIT_TIME_CDRLOCK) 
        begin
          gt0_rx_cdrlocked       <= `DLY    1'b1;
          gt0_rx_cdrlock_counter <= `DLY    gt0_rx_cdrlock_counter;
        end
        else
          gt0_rx_cdrlock_counter <= `DLY    gt0_rx_cdrlock_counter + 1;
  end 

  always @(posedge sysclk_in)
  begin
        if(gt1_gtrxreset_i)
        begin
          gt1_rx_cdrlocked       <= `DLY    1'b0;
          gt1_rx_cdrlock_counter <= `DLY    0;      
        end                
        else if (gt1_rx_cdrlock_counter == WAIT_TIME_CDRLOCK) 
        begin
          gt1_rx_cdrlocked       <= `DLY    1'b1;
          gt1_rx_cdrlock_counter <= `DLY    gt1_rx_cdrlock_counter;
        end
        else
          gt1_rx_cdrlock_counter <= `DLY    gt1_rx_cdrlock_counter + 1;
  end 

  always @(posedge sysclk_in)
  begin
        if(gt2_gtrxreset_i)
        begin
          gt2_rx_cdrlocked       <= `DLY    1'b0;
          gt2_rx_cdrlock_counter <= `DLY    0;      
        end                
        else if (gt2_rx_cdrlock_counter == WAIT_TIME_CDRLOCK) 
        begin
          gt2_rx_cdrlocked       <= `DLY    1'b1;
          gt2_rx_cdrlock_counter <= `DLY    gt2_rx_cdrlock_counter;
        end
        else
          gt2_rx_cdrlock_counter <= `DLY    gt2_rx_cdrlock_counter + 1;
  end 

  always @(posedge sysclk_in)
  begin
        if(gt3_gtrxreset_i)
        begin
          gt3_rx_cdrlocked       <= `DLY    1'b0;
          gt3_rx_cdrlock_counter <= `DLY    0;      
        end                
        else if (gt3_rx_cdrlock_counter == WAIT_TIME_CDRLOCK) 
        begin
          gt3_rx_cdrlocked       <= `DLY    1'b1;
          gt3_rx_cdrlock_counter <= `DLY    gt3_rx_cdrlock_counter;
        end
        else
          gt3_rx_cdrlock_counter <= `DLY    gt3_rx_cdrlock_counter + 1;
  end 

assign  gt0_recclk_stable_i                  =  gt0_rx_cdrlocked;
assign  gt1_recclk_stable_i                  =  gt1_rx_cdrlocked;
assign  gt2_recclk_stable_i                  =  gt2_rx_cdrlocked;
assign  gt3_recclk_stable_i                  =  gt3_rx_cdrlocked;







endmodule


