////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 3.6
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : gt_sfp_support.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module gt_sfp_support
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`timescale 1ns / 1ps
`define DLY #1

(* DowngradeIPIdentifiedWarnings="yes" *)
//***********************************Entity Declaration************************
(* CORE_GENERATION_INFO = "gt_sfp,gtwizard_v3_6_13,{protocol_file=Start_from_scratch}" *)
module gt_sfp_support #
(
    parameter EXAMPLE_SIM_GTRESET_SPEEDUP            = "TRUE",     // Simulation setting for GT SecureIP model
    parameter STABLE_CLOCK_PERIOD                    = 10         //Period of the stable clock driving this state-machine, unit is [ns]

)
(
input           soft_reset_tx_in,
input           soft_reset_rx_in,
input           dont_reset_on_data_error_in,
    input  q3_clk1_gtrefclk_pad_n_in,
    input  q3_clk1_gtrefclk_pad_p_in,
output          gt0_tx_fsm_reset_done_out,
output          gt0_rx_fsm_reset_done_out,
input           gt0_data_valid_in,
output          gt1_tx_fsm_reset_done_out,
output          gt1_rx_fsm_reset_done_out,
input           gt1_data_valid_in,
output          gt2_tx_fsm_reset_done_out,
output          gt2_rx_fsm_reset_done_out,
input           gt2_data_valid_in,
output          gt3_tx_fsm_reset_done_out,
output          gt3_rx_fsm_reset_done_out,
input           gt3_data_valid_in,
 
    output   gt0_txusrclk_out,
    output   gt0_txusrclk2_out,
    output   gt0_rxusrclk_out,
    output   gt0_rxusrclk2_out,
 
    output   gt1_txusrclk_out,
    output   gt1_txusrclk2_out,
    output   gt1_rxusrclk_out,
    output   gt1_rxusrclk2_out,
 
    output   gt2_txusrclk_out,
    output   gt2_txusrclk2_out,
    output   gt2_rxusrclk_out,
    output   gt2_rxusrclk2_out,
 
    output   gt3_txusrclk_out,
    output   gt3_txusrclk2_out,
    output   gt3_rxusrclk_out,
    output   gt3_rxusrclk2_out,
    //_________________________________________________________________________
    //GT0  (X1Y12)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt0_gtnorthrefclk0_in,
    input           gt0_gtnorthrefclk1_in,
    input           gt0_gtsouthrefclk0_in,
    input           gt0_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt0_drpaddr_in,
    input   [15:0]  gt0_drpdi_in,
    output  [15:0]  gt0_drpdo_out,
    input           gt0_drpen_in,
    output          gt0_drprdy_out,
    input           gt0_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt0_eyescanreset_in,
    input           gt0_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt0_eyescandataerror_out,
    input           gt0_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt0_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt0_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt0_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt0_rxdisperr_out,
    output  [1:0]   gt0_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt0_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt0_rxmonitorout_out,
    input   [1:0]   gt0_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt0_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt0_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt0_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt0_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt0_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt0_gttxreset_in,
    input           gt0_txuserrdy_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt0_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt0_gthtxn_out,
    output          gt0_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt0_txoutclkfabric_out,
    output          gt0_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt0_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt0_txcharisk_in,

    //GT1  (X1Y13)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt1_gtnorthrefclk0_in,
    input           gt1_gtnorthrefclk1_in,
    input           gt1_gtsouthrefclk0_in,
    input           gt1_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt1_drpaddr_in,
    input   [15:0]  gt1_drpdi_in,
    output  [15:0]  gt1_drpdo_out,
    input           gt1_drpen_in,
    output          gt1_drprdy_out,
    input           gt1_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt1_eyescanreset_in,
    input           gt1_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt1_eyescandataerror_out,
    input           gt1_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt1_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt1_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt1_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt1_rxdisperr_out,
    output  [1:0]   gt1_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt1_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt1_rxmonitorout_out,
    input   [1:0]   gt1_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt1_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt1_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt1_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt1_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt1_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt1_gttxreset_in,
    input           gt1_txuserrdy_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt1_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt1_gthtxn_out,
    output          gt1_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt1_txoutclkfabric_out,
    output          gt1_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt1_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt1_txcharisk_in,

    //GT2  (X1Y14)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt2_gtnorthrefclk0_in,
    input           gt2_gtnorthrefclk1_in,
    input           gt2_gtsouthrefclk0_in,
    input           gt2_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt2_drpaddr_in,
    input   [15:0]  gt2_drpdi_in,
    output  [15:0]  gt2_drpdo_out,
    input           gt2_drpen_in,
    output          gt2_drprdy_out,
    input           gt2_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt2_eyescanreset_in,
    input           gt2_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt2_eyescandataerror_out,
    input           gt2_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt2_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt2_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt2_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt2_rxdisperr_out,
    output  [1:0]   gt2_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt2_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt2_rxmonitorout_out,
    input   [1:0]   gt2_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt2_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt2_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt2_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt2_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt2_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt2_gttxreset_in,
    input           gt2_txuserrdy_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt2_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt2_gthtxn_out,
    output          gt2_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt2_txoutclkfabric_out,
    output          gt2_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt2_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt2_txcharisk_in,

    //GT3  (X1Y15)
    //____________________________CHANNEL PORTS________________________________
    //------------------------ Channel - Clocking Ports ------------------------
    input           gt3_gtnorthrefclk0_in,
    input           gt3_gtnorthrefclk1_in,
    input           gt3_gtsouthrefclk0_in,
    input           gt3_gtsouthrefclk1_in,
    //-------------------------- Channel - DRP Ports  --------------------------
    input   [8:0]   gt3_drpaddr_in,
    input   [15:0]  gt3_drpdi_in,
    output  [15:0]  gt3_drpdo_out,
    input           gt3_drpen_in,
    output          gt3_drprdy_out,
    input           gt3_drpwe_in,
    //------------------- RX Initialization and Reset Ports --------------------
    input           gt3_eyescanreset_in,
    input           gt3_rxuserrdy_in,
    //------------------------ RX Margin Analysis Ports ------------------------
    output          gt3_eyescandataerror_out,
    input           gt3_eyescantrigger_in,
    //----------------- Receive Ports - Clock Correction Ports -----------------
    output  [1:0]   gt3_rxclkcorcnt_out,
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    output  [14:0]  gt3_dmonitorout_out,
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    output  [15:0]  gt3_rxdata_out,
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    output  [1:0]   gt3_rxdisperr_out,
    output  [1:0]   gt3_rxnotintable_out,
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    input           gt3_gthrxn_in,
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    output  [6:0]   gt3_rxmonitorout_out,
    input   [1:0]   gt3_rxmonitorsel_in,
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    output          gt3_rxoutclkfabric_out,
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    input           gt3_gtrxreset_in,
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    output  [1:0]   gt3_rxcharisk_out,
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    input           gt3_gthrxp_in,
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    output          gt3_rxresetdone_out,
    //------------------- TX Initialization and Reset Ports --------------------
    input           gt3_gttxreset_in,
    input           gt3_txuserrdy_in,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  gt3_txdata_in,
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    output          gt3_gthtxn_out,
    output          gt3_gthtxp_out,
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    output          gt3_txoutclkfabric_out,
    output          gt3_txoutclkpcs_out,
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    output          gt3_txresetdone_out,
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    input   [1:0]   gt3_txcharisk_in,

    //____________________________COMMON PORTS________________________________
    output      gt0_qplllock_out,
    output      gt0_qpllrefclklost_out,
    output     gt0_qpllreset_out,
    output      gt0_qplloutclk_out,
    output      gt0_qplloutrefclk_out,
    input          sysclk_in

);


//**************************** Wire Declarations ******************************//
    //------------------------ GT Wrapper Wires ------------------------------
    //________________________________________________________________________
    //________________________________________________________________________
    //GT0  (X1Y12)
    //------------------------ Channel - Clocking Ports ------------------------
    wire            gt0_gtnorthrefclk0_i;
    wire            gt0_gtnorthrefclk1_i;
    wire            gt0_gtsouthrefclk0_i;
    wire            gt0_gtsouthrefclk1_i;
    //-------------------------- Channel - DRP Ports  --------------------------
    wire    [8:0]   gt0_drpaddr_i;
    wire    [15:0]  gt0_drpdi_i;
    wire    [15:0]  gt0_drpdo_i;
    wire            gt0_drpen_i;
    wire            gt0_drprdy_i;
    wire            gt0_drpwe_i;
    //------------------- RX Initialization and Reset Ports --------------------
    wire            gt0_eyescanreset_i;
    wire            gt0_rxuserrdy_i;
    //------------------------ RX Margin Analysis Ports ------------------------
    wire            gt0_eyescandataerror_i;
    wire            gt0_eyescantrigger_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt0_rxclkcorcnt_i;
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    wire    [14:0]  gt0_dmonitorout_i;
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    wire    [15:0]  gt0_rxdata_i;
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    wire    [1:0]   gt0_rxdisperr_i;
    wire    [1:0]   gt0_rxnotintable_i;
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    wire            gt0_gthrxn_i;
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    wire    [6:0]   gt0_rxmonitorout_i;
    wire    [1:0]   gt0_rxmonitorsel_i;
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    wire            gt0_rxoutclk_i;
    wire            gt0_rxoutclkfabric_i;
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    wire            gt0_gtrxreset_i;
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    wire    [1:0]   gt0_rxcharisk_i;
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    wire            gt0_gthrxp_i;
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    wire            gt0_rxresetdone_i;
    //------------------- TX Initialization and Reset Ports --------------------
    wire            gt0_gttxreset_i;
    wire            gt0_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  gt0_txdata_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt0_gthtxn_i;
    wire            gt0_gthtxp_i;
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    wire            gt0_txoutclk_i;
    wire            gt0_txoutclkfabric_i;
    wire            gt0_txoutclkpcs_i;
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    wire            gt0_txresetdone_i;
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    wire    [1:0]   gt0_txcharisk_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT1  (X1Y13)
    //------------------------ Channel - Clocking Ports ------------------------
    wire            gt1_gtnorthrefclk0_i;
    wire            gt1_gtnorthrefclk1_i;
    wire            gt1_gtsouthrefclk0_i;
    wire            gt1_gtsouthrefclk1_i;
    //-------------------------- Channel - DRP Ports  --------------------------
    wire    [8:0]   gt1_drpaddr_i;
    wire    [15:0]  gt1_drpdi_i;
    wire    [15:0]  gt1_drpdo_i;
    wire            gt1_drpen_i;
    wire            gt1_drprdy_i;
    wire            gt1_drpwe_i;
    //------------------- RX Initialization and Reset Ports --------------------
    wire            gt1_eyescanreset_i;
    wire            gt1_rxuserrdy_i;
    //------------------------ RX Margin Analysis Ports ------------------------
    wire            gt1_eyescandataerror_i;
    wire            gt1_eyescantrigger_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt1_rxclkcorcnt_i;
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    wire    [14:0]  gt1_dmonitorout_i;
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    wire    [15:0]  gt1_rxdata_i;
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    wire    [1:0]   gt1_rxdisperr_i;
    wire    [1:0]   gt1_rxnotintable_i;
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    wire            gt1_gthrxn_i;
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    wire    [6:0]   gt1_rxmonitorout_i;
    wire    [1:0]   gt1_rxmonitorsel_i;
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    wire            gt1_rxoutclk_i;
    wire            gt1_rxoutclkfabric_i;
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    wire            gt1_gtrxreset_i;
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    wire    [1:0]   gt1_rxcharisk_i;
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    wire            gt1_gthrxp_i;
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    wire            gt1_rxresetdone_i;
    //------------------- TX Initialization and Reset Ports --------------------
    wire            gt1_gttxreset_i;
    wire            gt1_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  gt1_txdata_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt1_gthtxn_i;
    wire            gt1_gthtxp_i;
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    wire            gt1_txoutclk_i;
    wire            gt1_txoutclkfabric_i;
    wire            gt1_txoutclkpcs_i;
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    wire            gt1_txresetdone_i;
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    wire    [1:0]   gt1_txcharisk_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT2  (X1Y14)
    //------------------------ Channel - Clocking Ports ------------------------
    wire            gt2_gtnorthrefclk0_i;
    wire            gt2_gtnorthrefclk1_i;
    wire            gt2_gtsouthrefclk0_i;
    wire            gt2_gtsouthrefclk1_i;
    //-------------------------- Channel - DRP Ports  --------------------------
    wire    [8:0]   gt2_drpaddr_i;
    wire    [15:0]  gt2_drpdi_i;
    wire    [15:0]  gt2_drpdo_i;
    wire            gt2_drpen_i;
    wire            gt2_drprdy_i;
    wire            gt2_drpwe_i;
    //------------------- RX Initialization and Reset Ports --------------------
    wire            gt2_eyescanreset_i;
    wire            gt2_rxuserrdy_i;
    //------------------------ RX Margin Analysis Ports ------------------------
    wire            gt2_eyescandataerror_i;
    wire            gt2_eyescantrigger_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt2_rxclkcorcnt_i;
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    wire    [14:0]  gt2_dmonitorout_i;
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    wire    [15:0]  gt2_rxdata_i;
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    wire    [1:0]   gt2_rxdisperr_i;
    wire    [1:0]   gt2_rxnotintable_i;
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    wire            gt2_gthrxn_i;
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    wire    [6:0]   gt2_rxmonitorout_i;
    wire    [1:0]   gt2_rxmonitorsel_i;
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    wire            gt2_rxoutclk_i;
    wire            gt2_rxoutclkfabric_i;
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    wire            gt2_gtrxreset_i;
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    wire    [1:0]   gt2_rxcharisk_i;
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    wire            gt2_gthrxp_i;
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    wire            gt2_rxresetdone_i;
    //------------------- TX Initialization and Reset Ports --------------------
    wire            gt2_gttxreset_i;
    wire            gt2_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  gt2_txdata_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt2_gthtxn_i;
    wire            gt2_gthtxp_i;
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    wire            gt2_txoutclk_i;
    wire            gt2_txoutclkfabric_i;
    wire            gt2_txoutclkpcs_i;
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    wire            gt2_txresetdone_i;
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    wire    [1:0]   gt2_txcharisk_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT3  (X1Y15)
    //------------------------ Channel - Clocking Ports ------------------------
    wire            gt3_gtnorthrefclk0_i;
    wire            gt3_gtnorthrefclk1_i;
    wire            gt3_gtsouthrefclk0_i;
    wire            gt3_gtsouthrefclk1_i;
    //-------------------------- Channel - DRP Ports  --------------------------
    wire    [8:0]   gt3_drpaddr_i;
    wire    [15:0]  gt3_drpdi_i;
    wire    [15:0]  gt3_drpdo_i;
    wire            gt3_drpen_i;
    wire            gt3_drprdy_i;
    wire            gt3_drpwe_i;
    //------------------- RX Initialization and Reset Ports --------------------
    wire            gt3_eyescanreset_i;
    wire            gt3_rxuserrdy_i;
    //------------------------ RX Margin Analysis Ports ------------------------
    wire            gt3_eyescandataerror_i;
    wire            gt3_eyescantrigger_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt3_rxclkcorcnt_i;
    //----------------- Receive Ports - Digital Monitor Ports ------------------
    wire    [14:0]  gt3_dmonitorout_i;
    //---------------- Receive Ports - FPGA RX interface Ports -----------------
    wire    [15:0]  gt3_rxdata_i;
    //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
    wire    [1:0]   gt3_rxdisperr_i;
    wire    [1:0]   gt3_rxnotintable_i;
    //---------------------- Receive Ports - RX AFE Ports ----------------------
    wire            gt3_gthrxn_i;
    //------------------- Receive Ports - RX Equalizer Ports -------------------
    wire    [6:0]   gt3_rxmonitorout_i;
    wire    [1:0]   gt3_rxmonitorsel_i;
    //------------- Receive Ports - RX Fabric Output Control Ports -------------
    wire            gt3_rxoutclk_i;
    wire            gt3_rxoutclkfabric_i;
    //----------- Receive Ports - RX Initialization and Reset Ports ------------
    wire            gt3_gtrxreset_i;
    //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    wire    [1:0]   gt3_rxcharisk_i;
    //---------------------- Receive Ports -RX AFE Ports -----------------------
    wire            gt3_gthrxp_i;
    //------------ Receive Ports -RX Initialization and Reset Ports ------------
    wire            gt3_rxresetdone_i;
    //------------------- TX Initialization and Reset Ports --------------------
    wire            gt3_gttxreset_i;
    wire            gt3_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  gt3_txdata_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt3_gthtxn_i;
    wire            gt3_gthtxp_i;
    //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    wire            gt3_txoutclk_i;
    wire            gt3_txoutclkfabric_i;
    wire            gt3_txoutclkpcs_i;
    //----------- Transmit Ports - TX Initialization and Reset Ports -----------
    wire            gt3_txresetdone_i;
    //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    wire    [1:0]   gt3_txcharisk_i;

   wire  gt0_qplllock_i;
   wire  gt0_qpllrefclklost_i  ;
   wire  gt0_qpllreset_i  ;
   wire  gt0_qpllreset_t  ;
   wire  gt0_qplloutclk_i  ;
   wire  gt0_qplloutrefclk_i ;

    //----------------------------- Global Signals -----------------------------

    wire            sysclk_in_i;
    wire            gt0_tx_system_reset_c;
    wire            gt0_rx_system_reset_c;
    wire            gt1_tx_system_reset_c;
    wire            gt1_rx_system_reset_c;
    wire            gt2_tx_system_reset_c;
    wire            gt2_rx_system_reset_c;
    wire            gt3_tx_system_reset_c;
    wire            gt3_rx_system_reset_c;
    wire            tied_to_ground_i;
    wire    [63:0]  tied_to_ground_vec_i;
    wire            tied_to_vcc_i;
    wire    [7:0]   tied_to_vcc_vec_i;
    wire            GTTXRESET_IN;
    wire            GTRXRESET_IN;
    wire            QPLLRESET_IN;

     //--------------------------- User Clocks ---------------------------------
     wire            gt0_txusrclk_i; 
     wire            gt0_txusrclk2_i; 
     wire            gt0_rxusrclk_i; 
     wire            gt0_rxusrclk2_i; 
     wire            gt1_txusrclk_i; 
     wire            gt1_txusrclk2_i; 
     wire            gt1_rxusrclk_i; 
     wire            gt1_rxusrclk2_i; 
     wire            gt2_txusrclk_i; 
     wire            gt2_txusrclk2_i; 
     wire            gt2_rxusrclk_i; 
     wire            gt2_rxusrclk2_i; 
     wire            gt3_txusrclk_i; 
     wire            gt3_txusrclk2_i; 
     wire            gt3_rxusrclk_i; 
     wire            gt3_rxusrclk2_i; 
 
    //--------------------------- Reference Clocks ----------------------------
    
    wire            q3_clk1_refclk_i;

    wire         gt0_gtgrefclk_common_i;
    wire         gt0_gtnorthrefclk0_common_i;
    wire         gt0_gtnorthrefclk1_common_i;
    wire         gt0_gtrefclk1_common_i;
    wire         gt0_gtsouthrefclk0_common_i;
    wire         gt0_gtsouthrefclk1_common_i;
    wire commonreset_i;
    wire commonreset_t;

//**************************** Main Body of Code *******************************

    //  Static signal Assigments    
    assign tied_to_ground_i             = 1'b0;
    assign tied_to_ground_vec_i         = 64'h0000000000000000;
    assign tied_to_vcc_i                = 1'b1;
    assign tied_to_vcc_vec_i            = 8'hff;

 

     assign gt0_qplllock_out  = gt0_qplllock_i;
     assign gt0_qpllrefclklost_out = gt0_qpllrefclklost_i;
     assign gt0_qpllreset_t = commonreset_i | gt0_qpllreset_i;
     
    assign gt0_qpllreset_out = commonreset_i | gt0_qpllreset_i;
    assign gt0_qplloutclk_out = gt0_qplloutclk_i;
    assign gt0_qplloutrefclk_out = gt0_qplloutrefclk_i;


 
    assign  gt0_txusrclk_out = gt0_txusrclk_i; 
    assign  gt0_txusrclk2_out = gt0_txusrclk2_i;
    assign  gt0_rxusrclk_out = gt0_rxusrclk_i;
    assign  gt0_rxusrclk2_out = gt0_rxusrclk2_i;
 
    assign  gt1_txusrclk_out = gt1_txusrclk_i; 
    assign  gt1_txusrclk2_out = gt1_txusrclk2_i;
    assign  gt1_rxusrclk_out = gt1_rxusrclk_i;
    assign  gt1_rxusrclk2_out = gt1_rxusrclk2_i;
 
    assign  gt2_txusrclk_out = gt2_txusrclk_i; 
    assign  gt2_txusrclk2_out = gt2_txusrclk2_i;
    assign  gt2_rxusrclk_out = gt2_rxusrclk_i;
    assign  gt2_rxusrclk2_out = gt2_rxusrclk2_i;
 
    assign  gt3_txusrclk_out = gt3_txusrclk_i; 
    assign  gt3_txusrclk2_out = gt3_txusrclk2_i;
    assign  gt3_rxusrclk_out = gt3_rxusrclk_i;
    assign  gt3_rxusrclk2_out = gt3_rxusrclk2_i;


    gt_sfp_GT_USRCLK_SOURCE gt_usrclk_source
   (
 
    .GT0_TXUSRCLK_OUT    (gt0_txusrclk_i),
    .GT0_TXUSRCLK2_OUT   (gt0_txusrclk2_i),
    .GT0_TXOUTCLK_IN     (gt0_txoutclk_i),
    .GT0_RXUSRCLK_OUT    (gt0_rxusrclk_i),
    .GT0_RXUSRCLK2_OUT   (gt0_rxusrclk2_i),
    .GT0_RXOUTCLK_IN     (gt0_rxoutclk_i),
 
 
    .GT1_TXUSRCLK_OUT    (gt1_txusrclk_i),
    .GT1_TXUSRCLK2_OUT   (gt1_txusrclk2_i),
    .GT1_TXOUTCLK_IN     (gt1_txoutclk_i),
    .GT1_RXUSRCLK_OUT    (gt1_rxusrclk_i),
    .GT1_RXUSRCLK2_OUT   (gt1_rxusrclk2_i),
    .GT1_RXOUTCLK_IN     (gt1_rxoutclk_i),
 
 
    .GT2_TXUSRCLK_OUT    (gt2_txusrclk_i),
    .GT2_TXUSRCLK2_OUT   (gt2_txusrclk2_i),
    .GT2_TXOUTCLK_IN     (gt2_txoutclk_i),
    .GT2_RXUSRCLK_OUT    (gt2_rxusrclk_i),
    .GT2_RXUSRCLK2_OUT   (gt2_rxusrclk2_i),
    .GT2_RXOUTCLK_IN     (gt2_rxoutclk_i),
 
 
    .GT3_TXUSRCLK_OUT    (gt3_txusrclk_i),
    .GT3_TXUSRCLK2_OUT   (gt3_txusrclk2_i),
    .GT3_TXOUTCLK_IN     (gt3_txoutclk_i),
    .GT3_RXUSRCLK_OUT    (gt3_rxusrclk_i),
    .GT3_RXUSRCLK2_OUT   (gt3_rxusrclk2_i),
    .GT3_RXOUTCLK_IN     (gt3_rxoutclk_i),
 
    .Q3_CLK1_GTREFCLK_PAD_N_IN  (q3_clk1_gtrefclk_pad_n_in),
    .Q3_CLK1_GTREFCLK_PAD_P_IN  (q3_clk1_gtrefclk_pad_p_in),
    .Q3_CLK1_GTREFCLK_OUT       (q3_clk1_refclk_i)
);
assign  sysclk_in_i = sysclk_in;
    gt_sfp_common #
  (
   .WRAPPER_SIM_GTRESET_SPEEDUP(EXAMPLE_SIM_GTRESET_SPEEDUP),
   .SIM_QPLLREFCLK_SEL(3'b010)
  )
 common0_i
   (
    .GTGREFCLK_IN(gt0_gtgrefclk_common_i),
    .GTNORTHREFCLK0_IN(gt0_gtnorthrefclk0_common_i),
    .GTNORTHREFCLK1_IN(gt0_gtnorthrefclk1_common_i),
    .GTSOUTHREFCLK0_IN(gt0_gtsouthrefclk0_common_i),
    .GTSOUTHREFCLK1_IN(gt0_gtsouthrefclk1_common_i),
    .QPLLREFCLKSEL_IN(3'b010),
    .GTREFCLK0_IN(tied_to_ground_i),
    .GTREFCLK1_IN(q3_clk1_refclk_i),
    .QPLLLOCK_OUT(gt0_qplllock_i),
    .QPLLLOCKDETCLK_IN(sysclk_in_i),
    .QPLLOUTCLK_OUT(gt0_qplloutclk_i),
    .QPLLOUTREFCLK_OUT(gt0_qplloutrefclk_i),
    .QPLLREFCLKLOST_OUT(gt0_qpllrefclklost_i),    
    .QPLLRESET_IN(gt0_qpllreset_t)

);

    gt_sfp_common_reset # 
   (
      .STABLE_CLOCK_PERIOD (STABLE_CLOCK_PERIOD)        // Period of the stable clock driving this state-machine, unit is [ns]
   )
   common_reset_i
   (    
      .STABLE_CLOCK(sysclk_in_i),             //Stable Clock, either a stable clock from the PCB
      .SOFT_RESET(soft_reset_tx_in),               //User Reset, can be pulled any time
      .COMMON_RESET(commonreset_i)              //Reset QPLL
   );


    
    gt_sfp_init gt_sfp_init_i
    (
        .sysclk_in                      (sysclk_in_i),
        .soft_reset_tx_in               (soft_reset_tx_in),
        .soft_reset_rx_in               (soft_reset_rx_in),
        .dont_reset_on_data_error_in    (dont_reset_on_data_error_in),
        .gt0_drp_busy_out               (),
        .gt0_tx_fsm_reset_done_out      (gt0_tx_fsm_reset_done_out),
        .gt0_rx_fsm_reset_done_out      (gt0_rx_fsm_reset_done_out),
        .gt0_data_valid_in              (gt0_data_valid_in),
        .gt1_drp_busy_out               (),
        .gt1_tx_fsm_reset_done_out      (gt1_tx_fsm_reset_done_out),
        .gt1_rx_fsm_reset_done_out      (gt1_rx_fsm_reset_done_out),
        .gt1_data_valid_in              (gt1_data_valid_in),
        .gt2_drp_busy_out               (),
        .gt2_tx_fsm_reset_done_out      (gt2_tx_fsm_reset_done_out),
        .gt2_rx_fsm_reset_done_out      (gt2_rx_fsm_reset_done_out),
        .gt2_data_valid_in              (gt2_data_valid_in),
        .gt3_drp_busy_out               (),
        .gt3_tx_fsm_reset_done_out      (gt3_tx_fsm_reset_done_out),
        .gt3_rx_fsm_reset_done_out      (gt3_rx_fsm_reset_done_out),
        .gt3_data_valid_in              (gt3_data_valid_in),

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT0  (X1Y12)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt0_gtnorthrefclk0_in          (gt0_gtnorthrefclk0_in), // input wire gt0_gtnorthrefclk0_in
        .gt0_gtnorthrefclk1_in          (gt0_gtnorthrefclk1_in), // input wire gt0_gtnorthrefclk1_in
        .gt0_gtsouthrefclk0_in          (gt0_gtsouthrefclk0_in), // input wire gt0_gtsouthrefclk0_in
        .gt0_gtsouthrefclk1_in          (gt0_gtsouthrefclk1_in), // input wire gt0_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt0_drpaddr_in                 (gt0_drpaddr_in), // input wire [8:0] gt0_drpaddr_in
        .gt0_drpclk_in                  (sysclk_in_i), // input wire sysclk_in_i
        .gt0_drpdi_in                   (gt0_drpdi_in), // input wire [15:0] gt0_drpdi_in
        .gt0_drpdo_out                  (gt0_drpdo_out), // output wire [15:0] gt0_drpdo_out
        .gt0_drpen_in                   (gt0_drpen_in), // input wire gt0_drpen_in
        .gt0_drprdy_out                 (gt0_drprdy_out), // output wire gt0_drprdy_out
        .gt0_drpwe_in                   (gt0_drpwe_in), // input wire gt0_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt0_eyescanreset_in            (gt0_eyescanreset_in), // input wire gt0_eyescanreset_in
        .gt0_rxuserrdy_in               (gt0_rxuserrdy_in), // input wire gt0_rxuserrdy_in
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt0_eyescandataerror_out       (gt0_eyescandataerror_out), // output wire gt0_eyescandataerror_out
        .gt0_eyescantrigger_in          (gt0_eyescantrigger_in), // input wire gt0_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt0_rxclkcorcnt_out            (gt0_rxclkcorcnt_out), // output wire [1:0] gt0_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt0_dmonitorout_out            (gt0_dmonitorout_out), // output wire [14:0] gt0_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt0_rxusrclk_in                (gt0_rxusrclk_i), // input wire gt0_rxusrclk_i
        .gt0_rxusrclk2_in               (gt0_rxusrclk2_i), // input wire gt0_rxusrclk2_i
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt0_rxdata_out                 (gt0_rxdata_out), // output wire [15:0] gt0_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt0_rxdisperr_out              (gt0_rxdisperr_out), // output wire [1:0] gt0_rxdisperr_out
        .gt0_rxnotintable_out           (gt0_rxnotintable_out), // output wire [1:0] gt0_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt0_gthrxn_in                  (gt0_gthrxn_in), // input wire gt0_gthrxn_in
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt0_rxmonitorout_out           (gt0_rxmonitorout_out), // output wire [6:0] gt0_rxmonitorout_out
        .gt0_rxmonitorsel_in            (gt0_rxmonitorsel_in), // input wire [1:0] gt0_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt0_rxoutclk_out               (gt0_rxoutclk_i), // output wire gt0_rxoutclk_i
        .gt0_rxoutclkfabric_out         (gt0_rxoutclkfabric_out), // output wire gt0_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt0_gtrxreset_in               (gt0_gtrxreset_in), // input wire gt0_gtrxreset_in
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt0_rxcharisk_out              (gt0_rxcharisk_out), // output wire [1:0] gt0_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt0_gthrxp_in                  (gt0_gthrxp_in), // input wire gt0_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt0_rxresetdone_out            (gt0_rxresetdone_out), // output wire gt0_rxresetdone_out
        //------------------- TX Initialization and Reset Ports --------------------
        .gt0_gttxreset_in               (gt0_gttxreset_in), // input wire gt0_gttxreset_in
        .gt0_txuserrdy_in               (gt0_txuserrdy_in), // input wire gt0_txuserrdy_in
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt0_txusrclk_in                (gt0_txusrclk_i), // input wire gt0_txusrclk_i
        .gt0_txusrclk2_in               (gt0_txusrclk2_i), // input wire gt0_txusrclk2_i
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt0_txdata_in                  (gt0_txdata_in), // input wire [15:0] gt0_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt0_gthtxn_out                 (gt0_gthtxn_out), // output wire gt0_gthtxn_out
        .gt0_gthtxp_out                 (gt0_gthtxp_out), // output wire gt0_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt0_txoutclk_out               (gt0_txoutclk_i), // output wire gt0_txoutclk_i
        .gt0_txoutclkfabric_out         (gt0_txoutclkfabric_out), // output wire gt0_txoutclkfabric_out
        .gt0_txoutclkpcs_out            (gt0_txoutclkpcs_out), // output wire gt0_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt0_txresetdone_out            (gt0_txresetdone_out), // output wire gt0_txresetdone_out
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt0_txcharisk_in               (gt0_txcharisk_in), // input wire [1:0] gt0_txcharisk_in



        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT1  (X1Y13)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt1_gtnorthrefclk0_in          (gt1_gtnorthrefclk0_in), // input wire gt1_gtnorthrefclk0_in
        .gt1_gtnorthrefclk1_in          (gt1_gtnorthrefclk1_in), // input wire gt1_gtnorthrefclk1_in
        .gt1_gtsouthrefclk0_in          (gt1_gtsouthrefclk0_in), // input wire gt1_gtsouthrefclk0_in
        .gt1_gtsouthrefclk1_in          (gt1_gtsouthrefclk1_in), // input wire gt1_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt1_drpaddr_in                 (gt1_drpaddr_in), // input wire [8:0] gt1_drpaddr_in
        .gt1_drpclk_in                  (sysclk_in_i), // input wire sysclk_in_i
        .gt1_drpdi_in                   (gt1_drpdi_in), // input wire [15:0] gt1_drpdi_in
        .gt1_drpdo_out                  (gt1_drpdo_out), // output wire [15:0] gt1_drpdo_out
        .gt1_drpen_in                   (gt1_drpen_in), // input wire gt1_drpen_in
        .gt1_drprdy_out                 (gt1_drprdy_out), // output wire gt1_drprdy_out
        .gt1_drpwe_in                   (gt1_drpwe_in), // input wire gt1_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt1_eyescanreset_in            (gt1_eyescanreset_in), // input wire gt1_eyescanreset_in
        .gt1_rxuserrdy_in               (gt1_rxuserrdy_in), // input wire gt1_rxuserrdy_in
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt1_eyescandataerror_out       (gt1_eyescandataerror_out), // output wire gt1_eyescandataerror_out
        .gt1_eyescantrigger_in          (gt1_eyescantrigger_in), // input wire gt1_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt1_rxclkcorcnt_out            (gt1_rxclkcorcnt_out), // output wire [1:0] gt1_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt1_dmonitorout_out            (gt1_dmonitorout_out), // output wire [14:0] gt1_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt1_rxusrclk_in                (gt1_rxusrclk_i), // input wire gt1_rxusrclk_i
        .gt1_rxusrclk2_in               (gt1_rxusrclk2_i), // input wire gt1_rxusrclk2_i
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt1_rxdata_out                 (gt1_rxdata_out), // output wire [15:0] gt1_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt1_rxdisperr_out              (gt1_rxdisperr_out), // output wire [1:0] gt1_rxdisperr_out
        .gt1_rxnotintable_out           (gt1_rxnotintable_out), // output wire [1:0] gt1_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt1_gthrxn_in                  (gt1_gthrxn_in), // input wire gt1_gthrxn_in
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt1_rxmonitorout_out           (gt1_rxmonitorout_out), // output wire [6:0] gt1_rxmonitorout_out
        .gt1_rxmonitorsel_in            (gt1_rxmonitorsel_in), // input wire [1:0] gt1_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt1_rxoutclk_out               (gt1_rxoutclk_i), // output wire gt1_rxoutclk_i
        .gt1_rxoutclkfabric_out         (gt1_rxoutclkfabric_out), // output wire gt1_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt1_gtrxreset_in               (gt1_gtrxreset_in), // input wire gt1_gtrxreset_in
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt1_rxcharisk_out              (gt1_rxcharisk_out), // output wire [1:0] gt1_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt1_gthrxp_in                  (gt1_gthrxp_in), // input wire gt1_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt1_rxresetdone_out            (gt1_rxresetdone_out), // output wire gt1_rxresetdone_out
        //------------------- TX Initialization and Reset Ports --------------------
        .gt1_gttxreset_in               (gt1_gttxreset_in), // input wire gt1_gttxreset_in
        .gt1_txuserrdy_in               (gt1_txuserrdy_in), // input wire gt1_txuserrdy_in
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt1_txusrclk_in                (gt1_txusrclk_i), // input wire gt1_txusrclk_i
        .gt1_txusrclk2_in               (gt1_txusrclk2_i), // input wire gt1_txusrclk2_i
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt1_txdata_in                  (gt1_txdata_in), // input wire [15:0] gt1_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt1_gthtxn_out                 (gt1_gthtxn_out), // output wire gt1_gthtxn_out
        .gt1_gthtxp_out                 (gt1_gthtxp_out), // output wire gt1_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt1_txoutclk_out               (gt1_txoutclk_i), // output wire gt1_txoutclk_i
        .gt1_txoutclkfabric_out         (gt1_txoutclkfabric_out), // output wire gt1_txoutclkfabric_out
        .gt1_txoutclkpcs_out            (gt1_txoutclkpcs_out), // output wire gt1_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt1_txresetdone_out            (gt1_txresetdone_out), // output wire gt1_txresetdone_out
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt1_txcharisk_in               (gt1_txcharisk_in), // input wire [1:0] gt1_txcharisk_in



        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT2  (X1Y14)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt2_gtnorthrefclk0_in          (gt2_gtnorthrefclk0_in), // input wire gt2_gtnorthrefclk0_in
        .gt2_gtnorthrefclk1_in          (gt2_gtnorthrefclk1_in), // input wire gt2_gtnorthrefclk1_in
        .gt2_gtsouthrefclk0_in          (gt2_gtsouthrefclk0_in), // input wire gt2_gtsouthrefclk0_in
        .gt2_gtsouthrefclk1_in          (gt2_gtsouthrefclk1_in), // input wire gt2_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt2_drpaddr_in                 (gt2_drpaddr_in), // input wire [8:0] gt2_drpaddr_in
        .gt2_drpclk_in                  (sysclk_in_i), // input wire sysclk_in_i
        .gt2_drpdi_in                   (gt2_drpdi_in), // input wire [15:0] gt2_drpdi_in
        .gt2_drpdo_out                  (gt2_drpdo_out), // output wire [15:0] gt2_drpdo_out
        .gt2_drpen_in                   (gt2_drpen_in), // input wire gt2_drpen_in
        .gt2_drprdy_out                 (gt2_drprdy_out), // output wire gt2_drprdy_out
        .gt2_drpwe_in                   (gt2_drpwe_in), // input wire gt2_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt2_eyescanreset_in            (gt2_eyescanreset_in), // input wire gt2_eyescanreset_in
        .gt2_rxuserrdy_in               (gt2_rxuserrdy_in), // input wire gt2_rxuserrdy_in
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt2_eyescandataerror_out       (gt2_eyescandataerror_out), // output wire gt2_eyescandataerror_out
        .gt2_eyescantrigger_in          (gt2_eyescantrigger_in), // input wire gt2_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt2_rxclkcorcnt_out            (gt2_rxclkcorcnt_out), // output wire [1:0] gt2_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt2_dmonitorout_out            (gt2_dmonitorout_out), // output wire [14:0] gt2_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt2_rxusrclk_in                (gt2_rxusrclk_i), // input wire gt2_rxusrclk_i
        .gt2_rxusrclk2_in               (gt2_rxusrclk2_i), // input wire gt2_rxusrclk2_i
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt2_rxdata_out                 (gt2_rxdata_out), // output wire [15:0] gt2_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt2_rxdisperr_out              (gt2_rxdisperr_out), // output wire [1:0] gt2_rxdisperr_out
        .gt2_rxnotintable_out           (gt2_rxnotintable_out), // output wire [1:0] gt2_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt2_gthrxn_in                  (gt2_gthrxn_in), // input wire gt2_gthrxn_in
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt2_rxmonitorout_out           (gt2_rxmonitorout_out), // output wire [6:0] gt2_rxmonitorout_out
        .gt2_rxmonitorsel_in            (gt2_rxmonitorsel_in), // input wire [1:0] gt2_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt2_rxoutclk_out               (gt2_rxoutclk_i), // output wire gt2_rxoutclk_i
        .gt2_rxoutclkfabric_out         (gt2_rxoutclkfabric_out), // output wire gt2_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt2_gtrxreset_in               (gt2_gtrxreset_in), // input wire gt2_gtrxreset_in
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt2_rxcharisk_out              (gt2_rxcharisk_out), // output wire [1:0] gt2_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt2_gthrxp_in                  (gt2_gthrxp_in), // input wire gt2_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt2_rxresetdone_out            (gt2_rxresetdone_out), // output wire gt2_rxresetdone_out
        //------------------- TX Initialization and Reset Ports --------------------
        .gt2_gttxreset_in               (gt2_gttxreset_in), // input wire gt2_gttxreset_in
        .gt2_txuserrdy_in               (gt2_txuserrdy_in), // input wire gt2_txuserrdy_in
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt2_txusrclk_in                (gt2_txusrclk_i), // input wire gt2_txusrclk_i
        .gt2_txusrclk2_in               (gt2_txusrclk2_i), // input wire gt2_txusrclk2_i
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt2_txdata_in                  (gt2_txdata_in), // input wire [15:0] gt2_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt2_gthtxn_out                 (gt2_gthtxn_out), // output wire gt2_gthtxn_out
        .gt2_gthtxp_out                 (gt2_gthtxp_out), // output wire gt2_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt2_txoutclk_out               (gt2_txoutclk_i), // output wire gt2_txoutclk_i
        .gt2_txoutclkfabric_out         (gt2_txoutclkfabric_out), // output wire gt2_txoutclkfabric_out
        .gt2_txoutclkpcs_out            (gt2_txoutclkpcs_out), // output wire gt2_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt2_txresetdone_out            (gt2_txresetdone_out), // output wire gt2_txresetdone_out
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt2_txcharisk_in               (gt2_txcharisk_in), // input wire [1:0] gt2_txcharisk_in



        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT3  (X1Y15)

        //------------------------ Channel - Clocking Ports ------------------------
        .gt3_gtnorthrefclk0_in          (gt3_gtnorthrefclk0_in), // input wire gt3_gtnorthrefclk0_in
        .gt3_gtnorthrefclk1_in          (gt3_gtnorthrefclk1_in), // input wire gt3_gtnorthrefclk1_in
        .gt3_gtsouthrefclk0_in          (gt3_gtsouthrefclk0_in), // input wire gt3_gtsouthrefclk0_in
        .gt3_gtsouthrefclk1_in          (gt3_gtsouthrefclk1_in), // input wire gt3_gtsouthrefclk1_in
        //-------------------------- Channel - DRP Ports  --------------------------
        .gt3_drpaddr_in                 (gt3_drpaddr_in), // input wire [8:0] gt3_drpaddr_in
        .gt3_drpclk_in                  (sysclk_in_i), // input wire sysclk_in_i
        .gt3_drpdi_in                   (gt3_drpdi_in), // input wire [15:0] gt3_drpdi_in
        .gt3_drpdo_out                  (gt3_drpdo_out), // output wire [15:0] gt3_drpdo_out
        .gt3_drpen_in                   (gt3_drpen_in), // input wire gt3_drpen_in
        .gt3_drprdy_out                 (gt3_drprdy_out), // output wire gt3_drprdy_out
        .gt3_drpwe_in                   (gt3_drpwe_in), // input wire gt3_drpwe_in
        //------------------- RX Initialization and Reset Ports --------------------
        .gt3_eyescanreset_in            (gt3_eyescanreset_in), // input wire gt3_eyescanreset_in
        .gt3_rxuserrdy_in               (gt3_rxuserrdy_in), // input wire gt3_rxuserrdy_in
        //------------------------ RX Margin Analysis Ports ------------------------
        .gt3_eyescandataerror_out       (gt3_eyescandataerror_out), // output wire gt3_eyescandataerror_out
        .gt3_eyescantrigger_in          (gt3_eyescantrigger_in), // input wire gt3_eyescantrigger_in
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .gt3_rxclkcorcnt_out            (gt3_rxclkcorcnt_out), // output wire [1:0] gt3_rxclkcorcnt_out
        //----------------- Receive Ports - Digital Monitor Ports ------------------
        .gt3_dmonitorout_out            (gt3_dmonitorout_out), // output wire [14:0] gt3_dmonitorout_out
        //---------------- Receive Ports - FPGA RX Interface Ports -----------------
        .gt3_rxusrclk_in                (gt3_rxusrclk_i), // input wire gt3_rxusrclk_i
        .gt3_rxusrclk2_in               (gt3_rxusrclk2_i), // input wire gt3_rxusrclk2_i
        //---------------- Receive Ports - FPGA RX interface Ports -----------------
        .gt3_rxdata_out                 (gt3_rxdata_out), // output wire [15:0] gt3_rxdata_out
        //---------------- Receive Ports - RX 8B/10B Decoder Ports -----------------
        .gt3_rxdisperr_out              (gt3_rxdisperr_out), // output wire [1:0] gt3_rxdisperr_out
        .gt3_rxnotintable_out           (gt3_rxnotintable_out), // output wire [1:0] gt3_rxnotintable_out
        //---------------------- Receive Ports - RX AFE Ports ----------------------
        .gt3_gthrxn_in                  (gt3_gthrxn_in), // input wire gt3_gthrxn_in
        //------------------- Receive Ports - RX Equalizer Ports -------------------
        .gt3_rxmonitorout_out           (gt3_rxmonitorout_out), // output wire [6:0] gt3_rxmonitorout_out
        .gt3_rxmonitorsel_in            (gt3_rxmonitorsel_in), // input wire [1:0] gt3_rxmonitorsel_in
        //------------- Receive Ports - RX Fabric Output Control Ports -------------
        .gt3_rxoutclk_out               (gt3_rxoutclk_i), // output wire gt3_rxoutclk_i
        .gt3_rxoutclkfabric_out         (gt3_rxoutclkfabric_out), // output wire gt3_rxoutclkfabric_out
        //----------- Receive Ports - RX Initialization and Reset Ports ------------
        .gt3_gtrxreset_in               (gt3_gtrxreset_in), // input wire gt3_gtrxreset_in
        //----------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        .gt3_rxcharisk_out              (gt3_rxcharisk_out), // output wire [1:0] gt3_rxcharisk_out
        //---------------------- Receive Ports -RX AFE Ports -----------------------
        .gt3_gthrxp_in                  (gt3_gthrxp_in), // input wire gt3_gthrxp_in
        //------------ Receive Ports -RX Initialization and Reset Ports ------------
        .gt3_rxresetdone_out            (gt3_rxresetdone_out), // output wire gt3_rxresetdone_out
        //------------------- TX Initialization and Reset Ports --------------------
        .gt3_gttxreset_in               (gt3_gttxreset_in), // input wire gt3_gttxreset_in
        .gt3_txuserrdy_in               (gt3_txuserrdy_in), // input wire gt3_txuserrdy_in
        //---------------- Transmit Ports - FPGA TX Interface Ports ----------------
        .gt3_txusrclk_in                (gt3_txusrclk_i), // input wire gt3_txusrclk_i
        .gt3_txusrclk2_in               (gt3_txusrclk2_i), // input wire gt3_txusrclk2_i
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .gt3_txdata_in                  (gt3_txdata_in), // input wire [15:0] gt3_txdata_in
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .gt3_gthtxn_out                 (gt3_gthtxn_out), // output wire gt3_gthtxn_out
        .gt3_gthtxp_out                 (gt3_gthtxp_out), // output wire gt3_gthtxp_out
        //--------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        .gt3_txoutclk_out               (gt3_txoutclk_i), // output wire gt3_txoutclk_i
        .gt3_txoutclkfabric_out         (gt3_txoutclkfabric_out), // output wire gt3_txoutclkfabric_out
        .gt3_txoutclkpcs_out            (gt3_txoutclkpcs_out), // output wire gt3_txoutclkpcs_out
        //----------- Transmit Ports - TX Initialization and Reset Ports -----------
        .gt3_txresetdone_out            (gt3_txresetdone_out), // output wire gt3_txresetdone_out
        //--------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        .gt3_txcharisk_in               (gt3_txcharisk_in), // input wire [1:0] gt3_txcharisk_in



    .gt0_qplllock_in(gt0_qplllock_i),
    .gt0_qpllrefclklost_in(gt0_qpllrefclklost_i),
    .gt0_qpllreset_out(gt0_qpllreset_i),
    .gt0_qplloutclk_in(gt0_qplloutclk_i),
    .gt0_qplloutrefclk_in(gt0_qplloutrefclk_i)
    );



 
endmodule
    

