------------------------------------------------------------------------------
--   ____  ____ 
--  /   /\/   /
-- /___/  \  /    Vendor: Xilinx
-- \   \   \/     Version : 3.6
--  \   \         Application : 7 Series FPGAs Transceivers Wizard
--  /   /         Filename : gtwizard_0_rxrate_seq.vhd
-- /___/   /\     
-- \   \  /  \ 
--  \___\/\___\
--
--
-- Module gtwizard_0_rxrate_seq
-- Generated by Xilinx 7 Series FPGAs Transceivers Wizard
-- 
-- 
-- (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


ENTITY gtwizard_0_rxrate_seq IS
  port ( 
    RST                : IN  std_logic;--Please add a synchroniser if it is not generated in DRPCLK domain.
    RXRATE_IN          : IN  std_logic_vector(2 downto 0);    
    RXPMARESETDONE     : IN  std_logic;
    RXRATE_OUT         : OUT std_logic_vector(2 downto 0);

    DRPCLK             : IN  std_logic;
    DRPADDR            : OUT std_logic_vector(8 downto 0);
    DRPDO              : IN  std_logic_vector(15 downto 0);
    DRPDI              : OUT std_logic_vector(15 downto 0);
    DRPRDY             : IN  std_logic;
    DRPEN              : OUT std_logic;
    DRPWE              : OUT std_logic;
    DRP_BUSY_IN        : IN  std_logic;
    DRP_RATE_BUSY_OUT  : OUT std_logic
);
END gtwizard_0_rxrate_seq;

ARCHITECTURE Behavioral of gtwizard_0_rxrate_seq is

  component gtwizard_0_sync_block
   generic (
     INITIALISE : bit_vector(5 downto 0) := "000000"
   );
   port  (
             clk           : in  std_logic;
             data_in       : in  std_logic;
             data_out      : out std_logic
          );
   end component;

  constant DLY                : time := 1 ns;
  type state_type is (idle,
                      drp_rd,
                      wait_rd_data,
                      wr_16,
                      wait_wr_done1,
                      wait_pmareset,
                      wr_20,
                      wait_wr_done2);

  signal  state               : state_type := idle;
  signal  next_state          : state_type := idle;
  signal  rxrate_ss           : std_logic_vector(2 downto 0);
  signal  rxrate_sss          : std_logic_vector(2 downto 0) := "000";
  signal  rxpmaresetdone_ss   : std_logic;
  signal  rd_data             : std_logic_vector(15 downto 0);
  signal  next_rd_data        : std_logic_vector(15 downto 0);
  signal  original_rd_data        : std_logic_vector(15 downto 0);
  signal  rxrate_i            : std_logic_vector(2 downto 0);
  signal  rxrate_o            : std_logic_vector(2 downto 0);
  signal  old_rxrate          : std_logic_vector(2 downto 0);
signal  flag                :std_logic := '0';
  signal  drpen_o             : std_logic;
  signal  drpwe_o             : std_logic;
  signal  drpaddr_o           : std_logic_vector(8 downto 0);
  signal  drpdi_o             : std_logic_vector(15 downto 0);
  signal  drp_rate_busy_i     : std_logic;

BEGIN
 sync2_RXPMARESETDONE : gtwizard_0_sync_block
  port map
         (
            clk             =>  DRPCLK,
            data_in         =>  RXPMARESETDONE,
            data_out        =>  rxpmaresetdone_ss
         );

 cdc_rxrate: for i in 0 to 2 generate
 sync_RXRATE : gtwizard_0_sync_block
  port map
         (
            clk             =>  DRPCLK,
            data_in         =>  RXRATE_IN(i),
            data_out        =>  rxrate_ss(i)
         );

  end generate;


--output assignment	
  RXRATE_OUT          <= rxrate_o;
  DRPEN               <= drpen_o;
  DRPWE               <= drpwe_o;
  DRPADDR             <= drpaddr_o;
  DRPDI               <= drpdi_o;
  DRP_RATE_BUSY_OUT   <= drp_rate_busy_i;

  PROCESS (DRPCLK,RST)
  BEGIN
    IF (RST = '1') THEN
      state               <= idle              after DLY;
      rxrate_sss          <= "000"             after DLY;
      rd_data             <= x"0000"           after DLY;
      old_rxrate          <= "000"             after DLY;
      rxrate_o            <= "000"             after DLY;
    ELSIF (DRPCLK'event and DRPCLK='1') THEN
      state               <= next_state        after DLY;
      rxrate_sss          <= rxrate_ss         after DLY;
      rd_data             <= next_rd_data      after DLY;
      rxrate_o            <= rxrate_i          after DLY;

      IF (rxrate_ss /= rxrate_sss) THEN
         old_rxrate           <=  rxrate_sss   after DLY;
      ELSE
         old_rxrate           <=  old_rxrate   after DLY;
      END IF;
    END IF;
  END PROCESS;


  PROCESS (rxrate_ss,rxrate_sss,DRPRDY,state,rxpmaresetdone_ss)
  BEGIN
    CASE state IS

      WHEN idle         =>
        IF (rxrate_ss /= rxrate_sss) THEN
          next_state <= drp_rd;
        ELSE
          next_state <= idle;
	END IF;

      WHEN drp_rd       =>
	next_state<= wait_rd_data;

      WHEN wait_rd_data =>
        IF (DRPRDY='1')THEN
          next_state <= wr_16;
        ELSE
          next_state <= wait_rd_data;
        END IF;

      WHEN wr_16 => 
	next_state <= wait_wr_done1;

      WHEN wait_wr_done1 => 
	IF (DRPRDY='1') THEN
	  next_state <= wait_pmareset;
        ELSE
	  next_state <= wait_wr_done1;
        END IF;

      WHEN wait_pmareset =>
	IF (rxpmaresetdone_ss = '0') THEN
          next_state <= wr_20;
        ELSE
          next_state <= wait_pmareset;
        END IF;

      WHEN wr_20         =>
        next_state <= wait_wr_done2;

      WHEN wait_wr_done2 =>
	IF (DRPRDY='1' ) THEN
          next_state <= idle;
        ELSE
          next_state <= wait_wr_done2;
	END IF;

      WHEN others=>
          next_state <= idle;
    END CASE;
  END PROCESS;

-- drives DRP interface and RXRATE_OUT
  PROCESS(DRPRDY,state,rd_data,DRPDO,DRP_BUSY_IN,old_rxrate,rxrate_ss,rxrate_sss,flag,original_rd_data)
  BEGIN
-- RX_DATA_WIDTH is located at addr x"0011", [13 downto 11]
-- encoding is this : /16 = x "2", /20 = x"3", /32 = x"4", /40 = x"5"
    --rxrate_i     <= rxrate_ss;
    drpaddr_o    <= '0'& x"11"; -- 000010001
    drpen_o      <= '0';
    drpwe_o      <= '0';
    drpdi_o      <= x"0000";
    next_rd_data <= rd_data;

    CASE state IS 

     --do nothing to DRP or reset
      WHEN idle   => 
         drp_rate_busy_i <= '0';
         IF (rxrate_ss /= rxrate_sss) THEN
            rxrate_i           <=  old_rxrate   ;
         ELSE
            rxrate_i           <=  rxrate_ss   ;
         END IF;


      --assert reset and issue rd
      WHEN drp_rd => 
         rxrate_i       <= old_rxrate;
         if(DRP_BUSY_IN = '0') then
          drp_rate_busy_i <= '1';
       	  drpen_o        <= '1';
	  drpwe_o        <= '0';
         else
          drp_rate_busy_i <= '0';
       	  drpen_o        <= '0';
	  drpwe_o        <= '0';
         end if;

      -- wait to load rd data
      WHEN wait_rd_data =>  
         rxrate_i       <= old_rxrate;
         drp_rate_busy_i <= '1';

         IF (DRPRDY='1' and flag = '0') THEN
            next_rd_data <= DRPDO;
         ELSIF (DRPRDY='1' and flag = '1') THEN
            next_rd_data <= original_rd_data;
         ELSE
            next_rd_data <= rd_data;
         END IF;

      -- write to 16-bit mode
      WHEN wr_16=>
         rxrate_i       <= old_rxrate;
         drp_rate_busy_i <= '1';
         drpen_o    <= '1';
         drpwe_o    <= '1';
         -- Addr "00001001" [11] = '0' puts width mode in /16 or /32
         drpdi_o <= rd_data(15 downto 12) & '0' & rd_data(10 downto 0);
       
      --wait for write to 16-bit mode is complete
      WHEN wait_wr_done1=> 
         rxrate_i       <= old_rxrate;
         drp_rate_busy_i <= '1';

      -- wait for rxpmaresetdone to go low
      WHEN wait_pmareset => null;
         drp_rate_busy_i <= '1';
         rxrate_i        <= rxrate_ss;

      --write to 20-bit mode
      WHEN wr_20 =>  
         rxrate_i        <= rxrate_ss;
         drp_rate_busy_i <= '1';
         drpen_o <= '1';
         drpwe_o <= '1';
         drpdi_o <= rd_data(15 downto 0); --restore user setting per prev read

      --wait to complete write to 20-bit mode
      WHEN wait_wr_done2 =>  
         rxrate_i        <= rxrate_ss;
         drp_rate_busy_i <= '1';

      WHEN others        => null;  

     END CASE;
  END PROCESS;

  process (DRPCLK)
  begin
    if (DRPCLK'event and DRPCLK='1') then
      if( state = wr_16 or state = wait_pmareset or state = wr_20 or state = wait_wr_done1) then
        flag <= '1';
      elsif(state = wait_wr_done2) then
        flag <= '0';
      end if; 
   end if;

  end process;

  process (DRPCLK)
  begin
    if (DRPCLK'event and DRPCLK='1') then
      if( state = wait_rd_data and DRPRDY ='1' and flag = '0') then
        original_rd_data <= DRPDO;
      end if; 
    end if; 
  end process;

END Behavioral;


