------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor: Xilinx
-- \   \   \/     Version : 3.6
--  \   \         Application : 7 Series FPGAs Transceivers Wizard 
--  /   /         Filename : gtwizard_x1y12_support.vhd
-- /___/   /\      
-- \   \  /  \ 
--  \___\/\___\
--
--  Description : This module instantiates the modules required for
--                reset and initialisation of the Transceiver
--
-- Module gtwizard_X1Y12_support
-- Generated by Xilinx 7 Series FPGAs Transceivers Wizard
-- 
-- 
-- (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
--***********************************Entity Declaration************************

entity gtwizard_X1Y12_support is
generic
(
    EXAMPLE_SIM_GTRESET_SPEEDUP             : string    := "TRUE";     -- simulation setting for GT SecureIP model
    STABLE_CLOCK_PERIOD                     : integer   := 10  

);
port
(
    SOFT_RESET_TX_IN                        : in   std_logic;
    SOFT_RESET_RX_IN                        : in   std_logic;
    DONT_RESET_ON_DATA_ERROR_IN             : in   std_logic;
    Q3_CLK1_GTREFCLK_PAD_N_IN               : in   std_logic;
    Q3_CLK1_GTREFCLK_PAD_P_IN               : in   std_logic;

    GT0_TX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_RX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_DATA_VALID_IN                       : in   std_logic;
    GT1_TX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT1_RX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT1_DATA_VALID_IN                       : in   std_logic;
 
    GT0_TXUSRCLK_OUT                        : out  std_logic;
    GT0_TXUSRCLK2_OUT                       : out  std_logic;
    GT0_RXUSRCLK_OUT                        : out  std_logic;
    GT0_RXUSRCLK2_OUT                       : out  std_logic;
 
    GT1_TXUSRCLK_OUT                        : out  std_logic;
    GT1_TXUSRCLK2_OUT                       : out  std_logic;
    GT1_RXUSRCLK_OUT                        : out  std_logic;
    GT1_RXUSRCLK2_OUT                       : out  std_logic;

    --_________________________________________________________________________
    --GT0  (X1Y12)
    --____________________________CHANNEL PORTS________________________________
    -------------------------- Channel - Clocking Ports ------------------------
    gt0_gtnorthrefclk0_in                   : in   std_logic;
    gt0_gtnorthrefclk1_in                   : in   std_logic;
    gt0_gtsouthrefclk0_in                   : in   std_logic;
    gt0_gtsouthrefclk1_in                   : in   std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    gt0_drpaddr_in                          : in   std_logic_vector(8 downto 0);
    gt0_drpdi_in                            : in   std_logic_vector(15 downto 0);
    gt0_drpdo_out                           : out  std_logic_vector(15 downto 0);
    gt0_drpen_in                            : in   std_logic;
    gt0_drprdy_out                          : out  std_logic;
    gt0_drpwe_in                            : in   std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    gt0_eyescanreset_in                     : in   std_logic;
    gt0_rxuserrdy_in                        : in   std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    gt0_eyescandataerror_out                : out  std_logic;
    gt0_eyescantrigger_in                   : in   std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    gt0_rxslide_in                          : in   std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt0_dmonitorout_out                     : out  std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    gt0_rxdata_out                          : out  std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    gt0_rxdisperr_out                       : out  std_logic_vector(1 downto 0);
    gt0_rxnotintable_out                    : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt0_gthrxn_in                           : in   std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    gt0_rxmonitorout_out                    : out  std_logic_vector(6 downto 0);
    gt0_rxmonitorsel_in                     : in   std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt0_rxoutclkfabric_out                  : out  std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt0_gtrxreset_in                        : in   std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    gt0_rxcharisk_out                       : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    gt0_gthrxp_in                           : in   std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt0_rxresetdone_out                     : out  std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    gt0_gttxreset_in                        : in   std_logic;
    gt0_txuserrdy_in                        : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    gt0_txdata_in                           : in   std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    gt0_gthtxn_out                          : out  std_logic;
    gt0_gthtxp_out                          : out  std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt0_txoutclkfabric_out                  : out  std_logic;
    gt0_txoutclkpcs_out                     : out  std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt0_txresetdone_out                     : out  std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    gt0_txcharisk_in                        : in   std_logic_vector(1 downto 0);

    --GT1  (X1Y13)
    --____________________________CHANNEL PORTS________________________________
    -------------------------- Channel - Clocking Ports ------------------------
    gt1_gtnorthrefclk0_in                   : in   std_logic;
    gt1_gtnorthrefclk1_in                   : in   std_logic;
    gt1_gtsouthrefclk0_in                   : in   std_logic;
    gt1_gtsouthrefclk1_in                   : in   std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    gt1_drpaddr_in                          : in   std_logic_vector(8 downto 0);
    gt1_drpdi_in                            : in   std_logic_vector(15 downto 0);
    gt1_drpdo_out                           : out  std_logic_vector(15 downto 0);
    gt1_drpen_in                            : in   std_logic;
    gt1_drprdy_out                          : out  std_logic;
    gt1_drpwe_in                            : in   std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    gt1_eyescanreset_in                     : in   std_logic;
    gt1_rxuserrdy_in                        : in   std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    gt1_eyescandataerror_out                : out  std_logic;
    gt1_eyescantrigger_in                   : in   std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    gt1_rxslide_in                          : in   std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt1_dmonitorout_out                     : out  std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    gt1_rxdata_out                          : out  std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    gt1_rxdisperr_out                       : out  std_logic_vector(1 downto 0);
    gt1_rxnotintable_out                    : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt1_gthrxn_in                           : in   std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    gt1_rxmonitorout_out                    : out  std_logic_vector(6 downto 0);
    gt1_rxmonitorsel_in                     : in   std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt1_rxoutclkfabric_out                  : out  std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt1_gtrxreset_in                        : in   std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    gt1_rxcharisk_out                       : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    gt1_gthrxp_in                           : in   std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt1_rxresetdone_out                     : out  std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    gt1_gttxreset_in                        : in   std_logic;
    gt1_txuserrdy_in                        : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    gt1_txdata_in                           : in   std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    gt1_gthtxn_out                          : out  std_logic;
    gt1_gthtxp_out                          : out  std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt1_txoutclkfabric_out                  : out  std_logic;
    gt1_txoutclkpcs_out                     : out  std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt1_txresetdone_out                     : out  std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    gt1_txcharisk_in                        : in   std_logic_vector(1 downto 0);

    --____________________________COMMON PORTS________________________________
    GT0_QPLLLOCK_OUT : out std_logic;
    GT0_QPLLREFCLKLOST_OUT  : out std_logic;
    GT0_QPLLRESET_OUT  : out std_logic;
     GT0_QPLLOUTCLK_OUT  : out std_logic;
     GT0_QPLLOUTREFCLK_OUT : out std_logic;
       sysclk_in        : in std_logic

);

end gtwizard_X1Y12_support;
    
architecture RTL of gtwizard_X1Y12_support is
attribute DowngradeIPIdentifiedWarnings: string;
attribute DowngradeIPIdentifiedWarnings of RTL : architecture is "yes";

--**************************Component Declarations*****************************

component gtwizard_X1Y12_init
 
port
(
    SYSCLK_IN                               : in   std_logic;
    SOFT_RESET_TX_IN                        : in   std_logic;
    SOFT_RESET_RX_IN                        : in   std_logic;
    DONT_RESET_ON_DATA_ERROR_IN             : in   std_logic;
    GT0_DRP_BUSY_OUT                        : out  std_logic;
    GT0_TX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_RX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_DATA_VALID_IN                       : in   std_logic;
    GT1_DRP_BUSY_OUT                        : out  std_logic;
    GT1_TX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT1_RX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT1_DATA_VALID_IN                       : in   std_logic;

    --_________________________________________________________________________
    --GT0  (X1Y12)
    --____________________________CHANNEL PORTS________________________________
    -------------------------- Channel - Clocking Ports ------------------------
    gt0_gtnorthrefclk0_in                   : in   std_logic;
    gt0_gtnorthrefclk1_in                   : in   std_logic;
    gt0_gtsouthrefclk0_in                   : in   std_logic;
    gt0_gtsouthrefclk1_in                   : in   std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    gt0_drpaddr_in                          : in   std_logic_vector(8 downto 0);
    gt0_drpclk_in                           : in   std_logic;
    gt0_drpdi_in                            : in   std_logic_vector(15 downto 0);
    gt0_drpdo_out                           : out  std_logic_vector(15 downto 0);
    gt0_drpen_in                            : in   std_logic;
    gt0_drprdy_out                          : out  std_logic;
    gt0_drpwe_in                            : in   std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    gt0_eyescanreset_in                     : in   std_logic;
    gt0_rxuserrdy_in                        : in   std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    gt0_eyescandataerror_out                : out  std_logic;
    gt0_eyescantrigger_in                   : in   std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    gt0_rxslide_in                          : in   std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt0_dmonitorout_out                     : out  std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX Interface Ports -----------------
    gt0_rxusrclk_in                         : in   std_logic;
    gt0_rxusrclk2_in                        : in   std_logic;
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    gt0_rxdata_out                          : out  std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    gt0_rxdisperr_out                       : out  std_logic_vector(1 downto 0);
    gt0_rxnotintable_out                    : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt0_gthrxn_in                           : in   std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    gt0_rxmonitorout_out                    : out  std_logic_vector(6 downto 0);
    gt0_rxmonitorsel_in                     : in   std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt0_rxoutclkfabric_out                  : out  std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt0_gtrxreset_in                        : in   std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    gt0_rxcharisk_out                       : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    gt0_gthrxp_in                           : in   std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt0_rxresetdone_out                     : out  std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    gt0_gttxreset_in                        : in   std_logic;
    gt0_txuserrdy_in                        : in   std_logic;
    ------------------ Transmit Ports - FPGA TX Interface Ports ----------------
    gt0_txusrclk_in                         : in   std_logic;
    gt0_txusrclk2_in                        : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    gt0_txdata_in                           : in   std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    gt0_gthtxn_out                          : out  std_logic;
    gt0_gthtxp_out                          : out  std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt0_txoutclk_out                        : out  std_logic;
    gt0_txoutclkfabric_out                  : out  std_logic;
    gt0_txoutclkpcs_out                     : out  std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt0_txresetdone_out                     : out  std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    gt0_txcharisk_in                        : in   std_logic_vector(1 downto 0);

    --GT1  (X1Y13)
    --____________________________CHANNEL PORTS________________________________
    -------------------------- Channel - Clocking Ports ------------------------
    gt1_gtnorthrefclk0_in                   : in   std_logic;
    gt1_gtnorthrefclk1_in                   : in   std_logic;
    gt1_gtsouthrefclk0_in                   : in   std_logic;
    gt1_gtsouthrefclk1_in                   : in   std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    gt1_drpaddr_in                          : in   std_logic_vector(8 downto 0);
    gt1_drpclk_in                           : in   std_logic;
    gt1_drpdi_in                            : in   std_logic_vector(15 downto 0);
    gt1_drpdo_out                           : out  std_logic_vector(15 downto 0);
    gt1_drpen_in                            : in   std_logic;
    gt1_drprdy_out                          : out  std_logic;
    gt1_drpwe_in                            : in   std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    gt1_eyescanreset_in                     : in   std_logic;
    gt1_rxuserrdy_in                        : in   std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    gt1_eyescandataerror_out                : out  std_logic;
    gt1_eyescantrigger_in                   : in   std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    gt1_rxslide_in                          : in   std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt1_dmonitorout_out                     : out  std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX Interface Ports -----------------
    gt1_rxusrclk_in                         : in   std_logic;
    gt1_rxusrclk2_in                        : in   std_logic;
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    gt1_rxdata_out                          : out  std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    gt1_rxdisperr_out                       : out  std_logic_vector(1 downto 0);
    gt1_rxnotintable_out                    : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt1_gthrxn_in                           : in   std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    gt1_rxmonitorout_out                    : out  std_logic_vector(6 downto 0);
    gt1_rxmonitorsel_in                     : in   std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt1_rxoutclkfabric_out                  : out  std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt1_gtrxreset_in                        : in   std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    gt1_rxcharisk_out                       : out  std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    gt1_gthrxp_in                           : in   std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt1_rxresetdone_out                     : out  std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    gt1_gttxreset_in                        : in   std_logic;
    gt1_txuserrdy_in                        : in   std_logic;
    ------------------ Transmit Ports - FPGA TX Interface Ports ----------------
    gt1_txusrclk_in                         : in   std_logic;
    gt1_txusrclk2_in                        : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    gt1_txdata_in                           : in   std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    gt1_gthtxn_out                          : out  std_logic;
    gt1_gthtxp_out                          : out  std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt1_txoutclk_out                        : out  std_logic;
    gt1_txoutclkfabric_out                  : out  std_logic;
    gt1_txoutclkpcs_out                     : out  std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt1_txresetdone_out                     : out  std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    gt1_txcharisk_in                        : in   std_logic_vector(1 downto 0);


    --____________________________COMMON PORTS________________________________
    GT0_QPLLLOCK_IN : in std_logic;
    GT0_QPLLREFCLKLOST_IN  : in std_logic;
    GT0_QPLLRESET_OUT  : out std_logic;
     GT0_QPLLOUTCLK_IN  : in std_logic;
     GT0_QPLLOUTREFCLK_IN : in std_logic

);

end component;

component gtwizard_X1Y12_common_reset  
generic
(
      STABLE_CLOCK_PERIOD      : integer := 8        -- Period of the stable clock driving this state-machine, unit is [ns]
   );
port
   (    
      STABLE_CLOCK             : in std_logic;             --Stable Clock, either a stable clock from the PCB
      SOFT_RESET               : in std_logic;               --User Reset, can be pulled any time
      COMMON_RESET             : out std_logic  --Reset QPLL
   );
end component;

component gtwizard_X1Y12_common 
generic
(
    -- Simulation attributes
    WRAPPER_SIM_GTRESET_SPEEDUP     : string     :=  "FALSE" ;       -- Set to "TRUE" to speed up sim reset
    SIM_QPLLREFCLK_SEL              :bit_vector  := "001"
 
);
port
(
    GTGREFCLK_IN      : in std_logic;
    GTNORTHREFCLK0_IN : in std_logic;
    GTNORTHREFCLK1_IN : in std_logic;
    GTSOUTHREFCLK0_IN : in std_logic;
    GTSOUTHREFCLK1_IN : in std_logic;
    QPLLREFCLKSEL_IN   : in std_logic_vector(2 downto 0);
    GTREFCLK0_IN : in std_logic;
    GTREFCLK1_IN      : in std_logic;
    QPLLLOCK_OUT : out std_logic;
    QPLLLOCKDETCLK_IN : in std_logic;
    QPLLOUTCLK_OUT : out std_logic;
    QPLLOUTREFCLK_OUT : out std_logic;
    QPLLREFCLKLOST_OUT : out std_logic;    
    QPLLRESET_IN : in std_logic

);

end component;

component gtwizard_X1Y12_GT_USRCLK_SOURCE 
port
(
 
    GT0_TXUSRCLK_OUT             : out std_logic;
    GT0_TXUSRCLK2_OUT            : out std_logic;
    GT0_TXOUTCLK_IN              : in  std_logic;
    GT0_RXUSRCLK_OUT             : out std_logic;
    GT0_RXUSRCLK2_OUT            : out std_logic;
 
    GT1_TXUSRCLK_OUT             : out std_logic;
    GT1_TXUSRCLK2_OUT            : out std_logic;
    GT1_TXOUTCLK_IN              : in  std_logic;
    GT1_RXUSRCLK_OUT             : out std_logic;
    GT1_RXUSRCLK2_OUT            : out std_logic;
    Q3_CLK1_GTREFCLK_PAD_N_IN               : in   std_logic;
    Q3_CLK1_GTREFCLK_PAD_P_IN               : in   std_logic;
    Q3_CLK1_GTREFCLK_OUT                    : out  std_logic
);
end component;

--***********************************Parameter Declarations********************

    constant DLY : time := 1 ns;

--************************** Register Declarations ****************************

    signal   gt0_txfsmresetdone_i            : std_logic;
signal   gt0_rxfsmresetdone_i            : std_logic;
    signal   gt0_txfsmresetdone_r            : std_logic;
    signal   gt0_txfsmresetdone_r2           : std_logic;
signal   gt0_rxresetdone_r               : std_logic;
signal   gt0_rxresetdone_r2              : std_logic;
signal   gt0_rxresetdone_r3              : std_logic;


    signal   gt1_txfsmresetdone_i            : std_logic;
signal   gt1_rxfsmresetdone_i            : std_logic;
    signal   gt1_txfsmresetdone_r            : std_logic;
    signal   gt1_txfsmresetdone_r2           : std_logic;
signal   gt1_rxresetdone_r               : std_logic;
signal   gt1_rxresetdone_r2              : std_logic;
signal   gt1_rxresetdone_r3              : std_logic;


signal   reset_pulse                     : std_logic_vector(3 downto 0);
    signal   reset_counter  :   unsigned(5 downto 0) := "000000";

--**************************** Wire Declarations ******************************
    -------------------------- GT Wrapper Wires ------------------------------
    --________________________________________________________________________
    --________________________________________________________________________
    --GT0  (X1Y12)

    -------------------------- Channel - Clocking Ports ------------------------
    signal  gt0_gtnorthrefclk0_i            : std_logic;
    signal  gt0_gtnorthrefclk1_i            : std_logic;
    signal  gt0_gtsouthrefclk0_i            : std_logic;
    signal  gt0_gtsouthrefclk1_i            : std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    signal  gt0_drpaddr_i                   : std_logic_vector(8 downto 0);
    signal  gt0_drpdi_i                     : std_logic_vector(15 downto 0);
    signal  gt0_drpdo_i                     : std_logic_vector(15 downto 0);
    signal  gt0_drpen_i                     : std_logic;
    signal  gt0_drprdy_i                    : std_logic;
    signal  gt0_drpwe_i                     : std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    signal  gt0_eyescanreset_i              : std_logic;
    signal  gt0_rxuserrdy_i                 : std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    signal  gt0_eyescandataerror_i          : std_logic;
    signal  gt0_eyescantrigger_i            : std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    signal  gt0_rxslide_i                   : std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    signal  gt0_dmonitorout_i               : std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    signal  gt0_rxdata_i                    : std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    signal  gt0_rxdisperr_i                 : std_logic_vector(1 downto 0);
    signal  gt0_rxnotintable_i              : std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    signal  gt0_gthrxn_i                    : std_logic;
    -------------------- Receive Ports - RX Equailizer Ports -------------------
    signal  gt0_rxlpmhfhold_i               : std_logic;
    signal  gt0_rxlpmlfhold_i               : std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    signal  gt0_rxmonitorout_i              : std_logic_vector(6 downto 0);
    signal  gt0_rxmonitorsel_i              : std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    signal  gt0_rxoutclk_i                  : std_logic;
    signal  gt0_rxoutclkfabric_i            : std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    signal  gt0_gtrxreset_i                 : std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    signal  gt0_rxcharisk_i                 : std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    signal  gt0_gthrxp_i                    : std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    signal  gt0_rxresetdone_i               : std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    signal  gt0_gttxreset_i                 : std_logic;
    signal  gt0_txuserrdy_i                 : std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    signal  gt0_txdata_i                    : std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    signal  gt0_gthtxn_i                    : std_logic;
    signal  gt0_gthtxp_i                    : std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    signal  gt0_txoutclk_i                  : std_logic;
    signal  gt0_txoutclkfabric_i            : std_logic;
    signal  gt0_txoutclkpcs_i               : std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    signal  gt0_txresetdone_i               : std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    signal  gt0_txcharisk_i                 : std_logic_vector(1 downto 0);

    --________________________________________________________________________
    --________________________________________________________________________
    --GT1  (X1Y13)

    -------------------------- Channel - Clocking Ports ------------------------
    signal  gt1_gtnorthrefclk0_i            : std_logic;
    signal  gt1_gtnorthrefclk1_i            : std_logic;
    signal  gt1_gtsouthrefclk0_i            : std_logic;
    signal  gt1_gtsouthrefclk1_i            : std_logic;
    ---------------------------- Channel - DRP Ports  --------------------------
    signal  gt1_drpaddr_i                   : std_logic_vector(8 downto 0);
    signal  gt1_drpdi_i                     : std_logic_vector(15 downto 0);
    signal  gt1_drpdo_i                     : std_logic_vector(15 downto 0);
    signal  gt1_drpen_i                     : std_logic;
    signal  gt1_drprdy_i                    : std_logic;
    signal  gt1_drpwe_i                     : std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    signal  gt1_eyescanreset_i              : std_logic;
    signal  gt1_rxuserrdy_i                 : std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    signal  gt1_eyescandataerror_i          : std_logic;
    signal  gt1_eyescantrigger_i            : std_logic;
    --------------- Receive Ports - Comma Detection and Alignment --------------
    signal  gt1_rxslide_i                   : std_logic;
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    signal  gt1_dmonitorout_i               : std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    signal  gt1_rxdata_i                    : std_logic_vector(15 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    signal  gt1_rxdisperr_i                 : std_logic_vector(1 downto 0);
    signal  gt1_rxnotintable_i              : std_logic_vector(1 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    signal  gt1_gthrxn_i                    : std_logic;
    -------------------- Receive Ports - RX Equailizer Ports -------------------
    signal  gt1_rxlpmhfhold_i               : std_logic;
    signal  gt1_rxlpmlfhold_i               : std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    signal  gt1_rxmonitorout_i              : std_logic_vector(6 downto 0);
    signal  gt1_rxmonitorsel_i              : std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    signal  gt1_rxoutclk_i                  : std_logic;
    signal  gt1_rxoutclkfabric_i            : std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    signal  gt1_gtrxreset_i                 : std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    signal  gt1_rxcharisk_i                 : std_logic_vector(1 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    signal  gt1_gthrxp_i                    : std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    signal  gt1_rxresetdone_i               : std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    signal  gt1_gttxreset_i                 : std_logic;
    signal  gt1_txuserrdy_i                 : std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    signal  gt1_txdata_i                    : std_logic_vector(15 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    signal  gt1_gthtxn_i                    : std_logic;
    signal  gt1_gthtxp_i                    : std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    signal  gt1_txoutclk_i                  : std_logic;
    signal  gt1_txoutclkfabric_i            : std_logic;
    signal  gt1_txoutclkpcs_i               : std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    signal  gt1_txresetdone_i               : std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    signal  gt1_txcharisk_i                 : std_logic_vector(1 downto 0);

    --____________________________COMMON PORTS________________________________
    signal gt0_qplllock_i : std_logic;
    signal gt0_qpllrefclklost_i  : std_logic;
    signal gt0_qpllreset_i  : std_logic;
    signal gt0_qpllreset_t  : std_logic;
     signal gt0_qplloutclk_i  : std_logic;
     signal gt0_qplloutrefclk_i : std_logic;

    ------------------------------- Global Signals -----------------------------
    signal  gt0_tx_system_reset_c           : std_logic;
    signal  gt0_rx_system_reset_c           : std_logic;
    signal  gt1_tx_system_reset_c           : std_logic;
    signal  gt1_rx_system_reset_c           : std_logic;
    signal  tied_to_ground_i                : std_logic;
    signal  tied_to_ground_vec_i            : std_logic_vector(63 downto 0);
    signal  tied_to_vcc_i                   : std_logic;
    signal  tied_to_vcc_vec_i               : std_logic_vector(7 downto 0);
    signal  drpclk_in_i                     : std_logic;
    signal  sysclk_in_i                     : std_logic;
    signal  GTTXRESET_IN                    : std_logic;
    signal  GTRXRESET_IN                    : std_logic;
    signal  QPLLRESET_IN                    : std_logic;

    attribute keep: string;
   ------------------------------- User Clocks ---------------------------------
    signal    gt0_txusrclk_i                  : std_logic; 
    signal    gt0_txusrclk2_i                 : std_logic; 
    signal    gt0_rxusrclk_i                  : std_logic; 
    signal    gt0_rxusrclk2_i                 : std_logic; 
    
    
    
    
    signal    gt1_txusrclk_i                  : std_logic; 
    signal    gt1_txusrclk2_i                 : std_logic; 
    signal    gt1_rxusrclk_i                  : std_logic; 
    signal    gt1_rxusrclk2_i                 : std_logic; 
    
    
    
    
    ----------------------------- Reference Clocks ----------------------------
    
signal    q3_clk1_refclk_i                : std_logic;
    signal gt0_gtgrefclk_common_i : std_logic;
    signal gt0_gtnorthrefclk0_common_i : std_logic;
    signal gt0_gtnorthrefclk1_common_i : std_logic;
    signal gt0_gtrefclk1_common_i : std_logic;
    signal gt0_gtsouthrefclk0_common_i : std_logic;
    signal gt0_gtsouthrefclk1_common_i : std_logic;

signal commonreset_i : std_logic;
--**************************** Main Body of Code *******************************
begin

    --  Static signal Assigments
tied_to_ground_i                             <= '0';
tied_to_ground_vec_i                         <= x"0000000000000000";
tied_to_vcc_i                                <= '1';
tied_to_vcc_vec_i                            <= "11111111";

 
      gt0_qplllock_out  <= gt0_qplllock_i;
      gt0_qpllrefclklost_out <= gt0_qpllrefclklost_i;
     gt0_qpllreset_t <= commonreset_i or gt0_qpllreset_i;
     gt0_qpllreset_out <= commonreset_i or gt0_qpllreset_i;
     gt0_qplloutclk_out <= gt0_qplloutclk_i;
     gt0_qplloutrefclk_out <= gt0_qplloutrefclk_i;


 
      GT0_TXUSRCLK_OUT <= gt0_txusrclk_i; 
      GT0_TXUSRCLK2_OUT <= gt0_txusrclk2_i;
      GT0_RXUSRCLK_OUT <= gt0_rxusrclk_i;
      GT0_RXUSRCLK2_OUT <= gt0_rxusrclk2_i;
 
      GT1_TXUSRCLK_OUT <= gt1_txusrclk_i; 
      GT1_TXUSRCLK2_OUT <= gt1_txusrclk2_i;
      GT1_RXUSRCLK_OUT <= gt1_rxusrclk_i;
      GT1_RXUSRCLK2_OUT <= gt1_rxusrclk2_i;


    
  
    
  
    gt_usrclk_source : gtwizard_X1Y12_GT_USRCLK_SOURCE
    port map
   (
 
        GT0_TXUSRCLK_OUT                =>      gt0_txusrclk_i,
        GT0_TXUSRCLK2_OUT               =>      gt0_txusrclk2_i,
        GT0_TXOUTCLK_IN                 =>      gt0_txoutclk_i,
        GT0_RXUSRCLK_OUT                =>      gt0_rxusrclk_i,
        GT0_RXUSRCLK2_OUT               =>      gt0_rxusrclk2_i,
 
        GT1_TXUSRCLK_OUT                =>      gt1_txusrclk_i,
        GT1_TXUSRCLK2_OUT               =>      gt1_txusrclk2_i,
        GT1_TXOUTCLK_IN                 =>      gt1_txoutclk_i,
        GT1_RXUSRCLK_OUT                =>      gt1_rxusrclk_i,
        GT1_RXUSRCLK2_OUT               =>      gt1_rxusrclk2_i,
        Q3_CLK1_GTREFCLK_PAD_N_IN       =>      Q3_CLK1_GTREFCLK_PAD_N_IN,
        Q3_CLK1_GTREFCLK_PAD_P_IN       =>      Q3_CLK1_GTREFCLK_PAD_P_IN,
        Q3_CLK1_GTREFCLK_OUT            =>      q3_clk1_refclk_i

    );

sysclk_in_i <= sysclk_in;

    common0_i:gtwizard_X1Y12_common 
  generic map
  (
   WRAPPER_SIM_GTRESET_SPEEDUP => EXAMPLE_SIM_GTRESET_SPEEDUP,
   SIM_QPLLREFCLK_SEL => "010"
  )
 port map
   (
    GTGREFCLK_IN      => gt0_gtgrefclk_common_i,
    GTNORTHREFCLK0_IN => gt0_gtnorthrefclk0_common_i,
    GTNORTHREFCLK1_IN => gt0_gtnorthrefclk1_common_i,
    GTSOUTHREFCLK0_IN => gt0_gtsouthrefclk0_common_i,
    GTSOUTHREFCLK1_IN => gt0_gtsouthrefclk1_common_i,
    QPLLREFCLKSEL_IN    => "010",
    GTREFCLK0_IN      => tied_to_ground_i,
    GTREFCLK1_IN      => q3_clk1_refclk_i,
    QPLLLOCK_OUT => gt0_qplllock_i,
    QPLLLOCKDETCLK_IN => sysclk_in_i,
    QPLLOUTCLK_OUT => gt0_qplloutclk_i,
    QPLLOUTREFCLK_OUT => gt0_qplloutrefclk_i,
    QPLLREFCLKLOST_OUT => gt0_qpllrefclklost_i,    
    QPLLRESET_IN => gt0_qpllreset_t

);

    common_reset_i:gtwizard_X1Y12_common_reset 
   generic map 
   (
      STABLE_CLOCK_PERIOD =>STABLE_CLOCK_PERIOD        -- Period of the stable clock driving this state-machine, unit is [ns]
   )
   port map
   (    
      STABLE_CLOCK => sysclk_in_i,             --Stable Clock, either a stable clock from the PCB
     
      SOFT_RESET => soft_reset_tx_in,               --User Reset, can be pulled any time
      COMMON_RESET => commonreset_i              --Reset QPLL
   );


    gtwizard_X1Y12_init_i : gtwizard_X1Y12_init
    port map
    (
        sysclk_in                       =>      sysclk_in_i,
        soft_reset_tx_in                =>      SOFT_RESET_TX_IN,
        soft_reset_rx_in                =>      SOFT_RESET_RX_IN,
        dont_reset_on_data_error_in     =>      DONT_RESET_ON_DATA_ERROR_IN,
        gt0_drp_busy_out                =>      open,
        gt0_tx_fsm_reset_done_out       =>      gt0_tx_fsm_reset_done_out,
        gt0_rx_fsm_reset_done_out       =>      gt0_rx_fsm_reset_done_out,
        gt0_data_valid_in               =>      gt0_data_valid_in,
        gt1_drp_busy_out                =>      open,
        gt1_tx_fsm_reset_done_out       =>      gt1_tx_fsm_reset_done_out,
        gt1_rx_fsm_reset_done_out       =>      gt1_rx_fsm_reset_done_out,
        gt1_data_valid_in               =>      gt1_data_valid_in,

        --_____________________________________________________________________
        --_____________________________________________________________________
        --GT0  (X1Y12)

        -------------------------- Channel - Clocking Ports ------------------------
        gt0_gtnorthrefclk0_in           =>      gt0_gtnorthrefclk0_in,
        gt0_gtnorthrefclk1_in           =>      gt0_gtnorthrefclk1_in,
        gt0_gtsouthrefclk0_in           =>      gt0_gtsouthrefclk0_in,
        gt0_gtsouthrefclk1_in           =>      gt0_gtsouthrefclk1_in,
        ---------------------------- Channel - DRP Ports  --------------------------
        gt0_drpaddr_in                  =>      gt0_drpaddr_in,
        gt0_drpclk_in                   =>      sysclk_in_i,
        gt0_drpdi_in                    =>      gt0_drpdi_in,
        gt0_drpdo_out                   =>      gt0_drpdo_out,
        gt0_drpen_in                    =>      gt0_drpen_in,
        gt0_drprdy_out                  =>      gt0_drprdy_out,
        gt0_drpwe_in                    =>      gt0_drpwe_in,
        --------------------- RX Initialization and Reset Ports --------------------
        gt0_eyescanreset_in             =>      gt0_eyescanreset_in,
        gt0_rxuserrdy_in                =>      gt0_rxuserrdy_in,
        -------------------------- RX Margin Analysis Ports ------------------------
        gt0_eyescandataerror_out        =>      gt0_eyescandataerror_out,
        gt0_eyescantrigger_in           =>      gt0_eyescantrigger_in,
        --------------- Receive Ports - Comma Detection and Alignment --------------
        gt0_rxslide_in                  =>      gt0_rxslide_in,
        ------------------- Receive Ports - Digital Monitor Ports ------------------
        gt0_dmonitorout_out             =>      gt0_dmonitorout_out,
        ------------------ Receive Ports - FPGA RX Interface Ports -----------------
        gt0_rxusrclk_in                 =>      gt0_rxusrclk_i,
        gt0_rxusrclk2_in                =>      gt0_rxusrclk2_i,
        ------------------ Receive Ports - FPGA RX interface Ports -----------------
        gt0_rxdata_out                  =>      gt0_rxdata_out,
        ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
        gt0_rxdisperr_out               =>      gt0_rxdisperr_out,
        gt0_rxnotintable_out            =>      gt0_rxnotintable_out,
        ------------------------ Receive Ports - RX AFE Ports ----------------------
        gt0_gthrxn_in                   =>      gt0_gthrxn_in,
        --------------------- Receive Ports - RX Equalizer Ports -------------------
        gt0_rxmonitorout_out            =>      gt0_rxmonitorout_out,
        gt0_rxmonitorsel_in             =>      gt0_rxmonitorsel_in,
        --------------- Receive Ports - RX Fabric Output Control Ports -------------
        gt0_rxoutclkfabric_out          =>      gt0_rxoutclkfabric_out,
        ------------- Receive Ports - RX Initialization and Reset Ports ------------
        gt0_gtrxreset_in                =>      gt0_gtrxreset_in,
        ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        gt0_rxcharisk_out               =>      gt0_rxcharisk_out,
        ------------------------ Receive Ports -RX AFE Ports -----------------------
        gt0_gthrxp_in                   =>      gt0_gthrxp_in,
        -------------- Receive Ports -RX Initialization and Reset Ports ------------
        gt0_rxresetdone_out             =>      gt0_rxresetdone_out,
        --------------------- TX Initialization and Reset Ports --------------------
        gt0_gttxreset_in                =>      gt0_gttxreset_in,
        gt0_txuserrdy_in                =>      gt0_txuserrdy_in,
        ------------------ Transmit Ports - FPGA TX Interface Ports ----------------
        gt0_txusrclk_in                 =>      gt0_txusrclk_i,
        gt0_txusrclk2_in                =>      gt0_txusrclk2_i,
        ------------------ Transmit Ports - TX Data Path interface -----------------
        gt0_txdata_in                   =>      gt0_txdata_in,
        ---------------- Transmit Ports - TX Driver and OOB signaling --------------
        gt0_gthtxn_out                  =>      gt0_gthtxn_out,
        gt0_gthtxp_out                  =>      gt0_gthtxp_out,
        ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        gt0_txoutclk_out                =>      gt0_txoutclk_i,
        gt0_txoutclkfabric_out          =>      gt0_txoutclkfabric_out,
        gt0_txoutclkpcs_out             =>      gt0_txoutclkpcs_out,
        ------------- Transmit Ports - TX Initialization and Reset Ports -----------
        gt0_txresetdone_out             =>      gt0_txresetdone_out,
        ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        gt0_txcharisk_in                =>      gt0_txcharisk_in,



        --_____________________________________________________________________
        --_____________________________________________________________________
        --GT1  (X1Y13)

        -------------------------- Channel - Clocking Ports ------------------------
        gt1_gtnorthrefclk0_in           =>      gt1_gtnorthrefclk0_in,
        gt1_gtnorthrefclk1_in           =>      gt1_gtnorthrefclk1_in,
        gt1_gtsouthrefclk0_in           =>      gt1_gtsouthrefclk0_in,
        gt1_gtsouthrefclk1_in           =>      gt1_gtsouthrefclk1_in,
        ---------------------------- Channel - DRP Ports  --------------------------
        gt1_drpaddr_in                  =>      gt1_drpaddr_in,
        gt1_drpclk_in                   =>      sysclk_in_i,
        gt1_drpdi_in                    =>      gt1_drpdi_in,
        gt1_drpdo_out                   =>      gt1_drpdo_out,
        gt1_drpen_in                    =>      gt1_drpen_in,
        gt1_drprdy_out                  =>      gt1_drprdy_out,
        gt1_drpwe_in                    =>      gt1_drpwe_in,
        --------------------- RX Initialization and Reset Ports --------------------
        gt1_eyescanreset_in             =>      gt1_eyescanreset_in,
        gt1_rxuserrdy_in                =>      gt1_rxuserrdy_in,
        -------------------------- RX Margin Analysis Ports ------------------------
        gt1_eyescandataerror_out        =>      gt1_eyescandataerror_out,
        gt1_eyescantrigger_in           =>      gt1_eyescantrigger_in,
        --------------- Receive Ports - Comma Detection and Alignment --------------
        gt1_rxslide_in                  =>      gt1_rxslide_in,
        ------------------- Receive Ports - Digital Monitor Ports ------------------
        gt1_dmonitorout_out             =>      gt1_dmonitorout_out,
        ------------------ Receive Ports - FPGA RX Interface Ports -----------------
        gt1_rxusrclk_in                 =>      gt1_rxusrclk_i,
        gt1_rxusrclk2_in                =>      gt1_rxusrclk2_i,
        ------------------ Receive Ports - FPGA RX interface Ports -----------------
        gt1_rxdata_out                  =>      gt1_rxdata_out,
        ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
        gt1_rxdisperr_out               =>      gt1_rxdisperr_out,
        gt1_rxnotintable_out            =>      gt1_rxnotintable_out,
        ------------------------ Receive Ports - RX AFE Ports ----------------------
        gt1_gthrxn_in                   =>      gt1_gthrxn_in,
        --------------------- Receive Ports - RX Equalizer Ports -------------------
        gt1_rxmonitorout_out            =>      gt1_rxmonitorout_out,
        gt1_rxmonitorsel_in             =>      gt1_rxmonitorsel_in,
        --------------- Receive Ports - RX Fabric Output Control Ports -------------
        gt1_rxoutclkfabric_out          =>      gt1_rxoutclkfabric_out,
        ------------- Receive Ports - RX Initialization and Reset Ports ------------
        gt1_gtrxreset_in                =>      gt1_gtrxreset_in,
        ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
        gt1_rxcharisk_out               =>      gt1_rxcharisk_out,
        ------------------------ Receive Ports -RX AFE Ports -----------------------
        gt1_gthrxp_in                   =>      gt1_gthrxp_in,
        -------------- Receive Ports -RX Initialization and Reset Ports ------------
        gt1_rxresetdone_out             =>      gt1_rxresetdone_out,
        --------------------- TX Initialization and Reset Ports --------------------
        gt1_gttxreset_in                =>      gt1_gttxreset_in,
        gt1_txuserrdy_in                =>      gt1_txuserrdy_in,
        ------------------ Transmit Ports - FPGA TX Interface Ports ----------------
        gt1_txusrclk_in                 =>      gt1_txusrclk_i,
        gt1_txusrclk2_in                =>      gt1_txusrclk2_i,
        ------------------ Transmit Ports - TX Data Path interface -----------------
        gt1_txdata_in                   =>      gt1_txdata_in,
        ---------------- Transmit Ports - TX Driver and OOB signaling --------------
        gt1_gthtxn_out                  =>      gt1_gthtxn_out,
        gt1_gthtxp_out                  =>      gt1_gthtxp_out,
        ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
        gt1_txoutclk_out                =>      gt1_txoutclk_i,
        gt1_txoutclkfabric_out          =>      gt1_txoutclkfabric_out,
        gt1_txoutclkpcs_out             =>      gt1_txoutclkpcs_out,
        ------------- Transmit Ports - TX Initialization and Reset Ports -----------
        gt1_txresetdone_out             =>      gt1_txresetdone_out,
        ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
        gt1_txcharisk_in                =>      gt1_txcharisk_in,



    gt0_qplllock_in => gt0_qplllock_i,
    gt0_qpllrefclklost_in => gt0_qpllrefclklost_i,
    gt0_qpllreset_out => gt0_qpllreset_i,
    gt0_qplloutclk_in => gt0_qplloutclk_i,
    gt0_qplloutrefclk_in => gt0_qplloutrefclk_i
    );



end RTL;
