#!/bin/bash -f
#*********************************************************************************************************
# Vivado (TM) v2020.2 (64-bit)
#
# Filename    : GTH_Core.sh
# Simulator   : Synopsys Verilog Compiler Simulator
# Description : Simulation script for compiling, elaborating and verifying the project source files.
#               The script will automatically create the design libraries sub-directories in the run
#               directory, add the library logical mappings in the simulator setup file, create default
#               'do/prj' file, execute compilation, elaboration and simulation steps.
#
# Generated by Vivado on Wed Sep 14 14:13:37 +0200 2022
# SW Build 3064766 on Wed Nov 18 09:12:45 MST 2020
#
# Copyright 1986-2020 Xilinx, Inc. All Rights Reserved. 
#
# usage: GTH_Core.sh [-help]
# usage: GTH_Core.sh [-lib_map_path]
# usage: GTH_Core.sh [-noclean_files]
# usage: GTH_Core.sh [-reset_run]
#
# Prerequisite:- To compile and run simulation, you must compile the Xilinx simulation libraries using the
# 'compile_simlib' TCL command. For more information about this command, run 'compile_simlib -help' in the
# Vivado Tcl Shell. Once the libraries have been compiled successfully, specify the -lib_map_path switch
# that points to these libraries and rerun export_simulation. For more information about this switch please
# type 'export_simulation -help' in the Tcl shell.
#
# You can also point to the simulation libraries by either replacing the <SPECIFY_COMPILED_LIB_PATH> in this
# script with the compiled library directory path or specify this path with the '-lib_map_path' switch when
# executing this script. Please type 'GTH_Core.sh -help' for more information.
#
# Additional references - 'Xilinx Vivado Design Suite User Guide:Logic simulation (UG900)'
#
#*********************************************************************************************************

# Directory path for design sources and include directories (if any) wrt this path
ref_dir="."

# Override directory with 'export_sim_ref_dir' env path value if set in the shell
if [[ (! -z "$export_sim_ref_dir") && ($export_sim_ref_dir != "") ]]; then
  ref_dir="$export_sim_ref_dir"
fi

# Command line options
vlogan_opts="-full64"
vhdlan_opts="-full64"
vcs_elab_opts="-full64 -debug_pp -t ps -licqueue -l elaborate.log"
vcs_sim_opts="-ucli -licqueue -l simulate.log"

# Design libraries
design_libs=(xpm axi_bram_ctrl_v4_1_4 xil_defaultlib blk_mem_gen_v8_4_4 axi_lite_ipif_v3_0_4 lib_cdc_v1_0_2 interrupt_control_v3_1_4 axi_gpio_v2_0_24 lib_pkg_v1_0_2 axi_iic_v2_0_25 generic_baseblocks_v2_1_0 axi_infrastructure_v1_1_0 axi_register_slice_v2_1_22 fifo_generator_v13_2_5 axi_data_fifo_v2_1_21 axi_crossbar_v2_1_23 axi_timer_v2_0_24 lib_srl_fifo_v1_0_2 axi_uart16550_v2_0_24 mdm_v3_2_19 microblaze_v11_0_4 axi_intc_v4_1_15 lmb_bram_if_cntlr_v4_0_19 lmb_v10_v3_0_11 xlconcat_v2_1_4 proc_sys_reset_v5_0_13 xlconstant_v1_1_7)

# Simulation root library directory
sim_lib_dir="vcs_lib"

# Script info
echo -e "GTH_Core.sh - Script generated by export_simulation (Vivado v2020.2 (64-bit)-id)\n"

# Main steps
run()
{
  check_args $# $1
  setup $1 $2
  compile
  elaborate
  simulate
}

# RUN_STEP: <compile>
compile()
{
  # Compile design files
  vlogan -work xpm $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "D:/Xilinx_2020.2/Vivado/2020.2/data/ip/xpm/xpm_cdc/hdl/xpm_cdc.sv" \
    "D:/Xilinx_2020.2/Vivado/2020.2/data/ip/xpm/xpm_memory/hdl/xpm_memory.sv" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xpm $vhdlan_opts \
    "D:/Xilinx_2020.2/Vivado/2020.2/data/ip/xpm/xpm_VCOMP.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_bram_ctrl_v4_1_4 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/c9f0/hdl/axi_bram_ctrl_v4_1_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_bram_ctrl_0_0/sim/GTH_Core_axi_bram_ctrl_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work blk_mem_gen_v8_4_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/2985/simulation/blk_mem_gen_v8_4.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_bram_ctrl_0_bram_0/sim/GTH_Core_axi_bram_ctrl_0_bram_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work axi_lite_ipif_v3_0_4 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/66ea/hdl/axi_lite_ipif_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work lib_cdc_v1_0_2 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ef1e/hdl/lib_cdc_v1_0_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work interrupt_control_v3_1_4 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/a040/hdl/interrupt_control_v3_1_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_gpio_v2_0_24 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/4318/hdl/axi_gpio_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_gpio_0_0/sim/GTH_Core_axi_gpio_0_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_gpio_2_0/sim/GTH_Core_axi_gpio_2_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_gpio_3_0/sim/GTH_Core_axi_gpio_3_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work lib_pkg_v1_0_2 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/0513/hdl/lib_pkg_v1_0_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_iic_v2_0_25 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/1529/hdl/axi_iic_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_iic_0_0/sim/GTH_Core_axi_iic_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work generic_baseblocks_v2_1_0 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/b752/hdl/generic_baseblocks_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_infrastructure_v1_1_0 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl/axi_infrastructure_v1_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_register_slice_v2_1_22 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/af2c/hdl/axi_register_slice_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work fifo_generator_v13_2_5 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/276e/simulation/fifo_generator_vlog_beh.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work fifo_generator_v13_2_5 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/276e/hdl/fifo_generator_v13_2_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work fifo_generator_v13_2_5 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/276e/hdl/fifo_generator_v13_2_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_data_fifo_v2_1_21 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/54c0/hdl/axi_data_fifo_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_crossbar_v2_1_23 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/bc0a/hdl/axi_crossbar_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_xbar_0/sim/GTH_Core_xbar_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work axi_timer_v2_0_24 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/70d6/hdl/axi_timer_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_timer_0_0/sim/GTH_Core_axi_timer_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work lib_srl_fifo_v1_0_2 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/51ce/hdl/lib_srl_fifo_v1_0_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_uart16550_v2_0_24 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/df78/hdl/axi_uart16550_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_axi_uart16550_0_0/sim/GTH_Core_axi_uart16550_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_clk_wiz_0_0/GTH_Core_clk_wiz_0_0_clk_wiz.v" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_clk_wiz_0_0/GTH_Core_clk_wiz_0_0.v" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/bd19/src/gtxe2_top.v" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gtxe2_top_0_0/sim/GTH_Core_gtxe2_top_0_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work mdm_v3_2_19 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/8715/hdl/mdm_v3_2_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_mdm_1_0/sim/GTH_Core_mdm_1_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work microblaze_v11_0_4 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/9285/hdl/microblaze_v11_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_microblaze_0_0/sim/GTH_Core_microblaze_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_intc_v4_1_15 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/47b8/hdl/axi_intc_v4_1_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_microblaze_0_axi_intc_0/sim/GTH_Core_microblaze_0_axi_intc_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_xbar_1/sim/GTH_Core_xbar_1.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work lmb_bram_if_cntlr_v4_0_19 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/0b98/hdl/lmb_bram_if_cntlr_v4_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_dlmb_bram_if_cntlr_0/sim/GTH_Core_dlmb_bram_if_cntlr_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work lmb_v10_v3_0_11 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/c2ed/hdl/lmb_v10_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_dlmb_v10_0/sim/GTH_Core_dlmb_v10_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_ilmb_bram_if_cntlr_0/sim/GTH_Core_ilmb_bram_if_cntlr_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_ilmb_v10_0/sim/GTH_Core_ilmb_v10_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_lmb_bram_0/sim/GTH_Core_lmb_bram_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xlconcat_v2_1_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/4b67/hdl/xlconcat_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_microblaze_0_xlconcat_0/sim/GTH_Core_microblaze_0_xlconcat_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work proc_sys_reset_v5_0_13 $vhdlan_opts \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/8842/hdl/proc_sys_reset_v5_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_proc_sys_reset_1_0/sim/GTH_Core_proc_sys_reset_1_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xlconstant_v1_1_7 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/fcfc/hdl/xlconstant_v1_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ipshared/d0f7" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/hdl" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/hdl/verilog" +incdir+"$ref_dir/../../../../CmuxSim.gen/sources_1/bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/hdl/verilog" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_xlconstant_1_0/sim/GTH_Core_xlconstant_1_0.v" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_xlconstant_2_0/sim/GTH_Core_xlconstant_2_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/ila_0/sim/ila_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/test_ila/sim/test_ila.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/CmuxTraffic.srcs/sources_1/ip/vio_cmux/sim/vio_cmux.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslStdRtlPkg.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/FiberPkg.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/ClkCorrTx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslAxiPkg.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CmuCorePkg.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/MsgStreamTx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslDmaTypePkg.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslAxisResize.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslSync.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslSyncVec.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslRptrEmpty.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslWptrFull.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslDpRAM.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslAsyncFIFO.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslStreamFifoReadAdapter.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslAxisFifo.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/Crc16D8.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/TxFsm.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/FiberLinkTx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/FiberLinkMapTx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/RxFsm.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/FiberLinkRx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/MsgStreamRx.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslEdgeDet.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/CslEdgeDetVec.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/StatusMon.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/Watchdog.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/FiberMon.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/SimItuLink.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/SimFecLink.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/InjectErrFiber.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/src/SimItuItmLink.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/d9a0/CmuxTraffic.srcs/sources_1/new/CmuxTrafficTop.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_CmuxTrafficTop_0_0/sim/GTH_Core_CmuxTrafficTop_0_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_0/sim/ila_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/ila_1/sim/ila_1.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_common_reset.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_common.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_gt_usrclk_source.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_support.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_tx_startup_fsm.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_rx_startup_fsm.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_init.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_gt.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core_multi_gt.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_gtrxreset_seq.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_rxpmarst_seq.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_rxrate_seq.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core/example_design/gt_core_sync_block.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sources_1/ip/gt_core/gt_core.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ipshared/0855/sources_1/new/gt_wrapper.vhd" \
    "$ref_dir/../../../bd/GTH_Core/ip/GTH_Core_gt_wrapper_0_0/sim/GTH_Core_gt_wrapper_0_0.vhd" \
    "$ref_dir/../../../bd/GTH_Core/sim/GTH_Core.vhd" \
  2>&1 | tee -a vhdlan.log


  vlogan -work xil_defaultlib $vlogan_opts +v2k \
    glbl.v \
  2>&1 | tee -a vlogan.log

}

# RUN_STEP: <elaborate>
elaborate()
{
  vcs $vcs_elab_opts xil_defaultlib.GTH_Core xil_defaultlib.glbl -o GTH_Core_simv
}

# RUN_STEP: <simulate>
simulate()
{
  ./GTH_Core_simv $vcs_sim_opts -do simulate.do
}

# STEP: setup
setup()
{
  case $1 in
    "-lib_map_path" )
      if [[ ($2 == "") ]]; then
        echo -e "ERROR: Simulation library directory path not specified (type \"./GTH_Core.sh -help\" for more information)\n"
        exit 1
      fi
      create_lib_mappings $2
    ;;
    "-reset_run" )
      reset_run
      echo -e "INFO: Simulation run files deleted.\n"
      exit 0
    ;;
    "-noclean_files" )
      # do not remove previous data
    ;;
    * )
      create_lib_mappings $2
  esac

  create_lib_dir

  # Add any setup/initialization commands here:-

  # <user specific commands>

}

# Define design library mappings
create_lib_mappings()
{
  file="synopsys_sim.setup"
  if [[ -e $file ]]; then
    if [[ ($1 == "") ]]; then
      return
    else
      rm -rf $file
    fi
  fi

  touch $file

  lib_map_path=""
  if [[ ($1 != "") ]]; then
    lib_map_path="$1"
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    mapping="$lib:$sim_lib_dir/$lib"
    echo $mapping >> $file
  done

  if [[ ($lib_map_path != "") ]]; then
    incl_ref="OTHERS=$lib_map_path/synopsys_sim.setup"
    echo $incl_ref >> $file
  fi
}

# Create design library directory paths
create_lib_dir()
{
  if [[ -e $sim_lib_dir ]]; then
    rm -rf $sim_lib_dir
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    lib_dir="$sim_lib_dir/$lib"
    if [[ ! -e $lib_dir ]]; then
      mkdir -p $lib_dir
    fi
  done
}

# Delete generated data from the previous run
reset_run()
{
  files_to_remove=(ucli.key GTH_Core_simv vlogan.log vhdlan.log compile.log elaborate.log simulate.log .vlogansetup.env .vlogansetup.args .vcs_lib_lock scirocco_command.log 64 AN.DB csrc GTH_Core_simv.daidir)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done

  create_lib_dir
}

# Check command line arguments
check_args()
{
  if [[ ($1 == 1 ) && ($2 != "-lib_map_path" && $2 != "-noclean_files" && $2 != "-reset_run" && $2 != "-help" && $2 != "-h") ]]; then
    echo -e "ERROR: Unknown option specified '$2' (type \"./GTH_Core.sh -help\" for more information)\n"
    exit 1
  fi

  if [[ ($2 == "-help" || $2 == "-h") ]]; then
    usage
  fi
}

# Script usage
usage()
{
  msg="Usage: GTH_Core.sh [-help]\n\
Usage: GTH_Core.sh [-lib_map_path]\n\
Usage: GTH_Core.sh [-reset_run]\n\
Usage: GTH_Core.sh [-noclean_files]\n\n\
[-help] -- Print help information for this script\n\n\
[-lib_map_path <path>] -- Compiled simulation library directory path. The simulation library is compiled\n\
using the compile_simlib tcl command. Please see 'compile_simlib -help' for more information.\n\n\
[-reset_run] -- Recreate simulator setup files and library mappings for a clean run. The generated files\n\
from the previous run will be removed. If you don't want to remove the simulator generated files, use the\n\
-noclean_files switch.\n\n\
[-noclean_files] -- Reset previous run, but do not remove simulator generated files from the previous run.\n\n"
  echo -e $msg
  exit 1
}

# Launch script
run $1 $2
