---------------------------------------------------------------------------------------------------
--! @brief Powerup Reset module test bench 
--! @details
--!
--!
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date October 12 2018 created
--! @date October 15 2018 last modify
--!
--! @version v0.1
--!
--!
--! @file PowerupRstTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;

use work.CslStdRtlPkg.all;
use work.AxiStreamPkg.all;
---------------------------------------------------------------------------------------------------
entity PowerupRstTb is
end entity ;
---------------------------------------------------------------------------------------------------
architecture Bhv of PowerupRstTb is
   -----------------------------
   -- Port Signals 
   -----------------------------
   -- Clock reset
   constant CLK_PERIOD_C : time := 10 ns; --! clock period
   constant CLK_DELAY_C  : time := 0 ns;  --! clock delay at startup 

   constant TPD_C        : time     := 1 ns; --! TPD constant
   constant EXTR_R_POL_G : boolean  := true; --! external reset polarity
   constant HOLD_TIME_G  : positive := 1000; --! hold time for PowerupRst module

   signal clk_i      : sl := '0'; --! single ended clock input
   signal pwrGood_i  : sl := '0'; --! external sigal for power good information
   signal rstTrue_o  : sl;        --! reset ouptut
   signal rstFalse_o : sl;        --! reset ouptut

---------------------------------------------------------------------------------------------------
begin -- architecture Bhv

   -----------------------------
   -- component instantiation 
   -----------------------------
   uut0_PowerupRst : entity work.PowerupRst
      generic map (
         TPD_G        => TPD_C,
         EXTR_R_POL_G => true,
         HOLD_TIME_G  => HOLD_TIME_G
      )
      port map (
         clk_i    => clk_i,
         extRst_i => pwrGood_i,
         rst_o    => rstTrue_o
      );

   uut1_PowerupRst : entity work.PowerupRst
      generic map (
         TPD_G        => TPD_C,
         EXTR_R_POL_G => false,
         HOLD_TIME_G  => HOLD_TIME_G
      )
      port map (
         clk_i    => clk_i,
         extRst_i => pwrGood_i,
         rst_o    => rstFalse_o
      );

   -- Clock
   process is
   begin
      wait for CLK_DELAY_C;
      while (true) loop
         clk_i <= not clk_i;
         wait for CLK_PERIOD_C/2.0;
      end loop;
   end process;

   -- uut simulation process
   StimuliProcess : process
   begin
      wait for 1000*CLK_PERIOD_C;
      pwrGood_i <= '1';
      wait for 20004 ns;
      pwrGood_i <= '0';
   end process StimuliProcess;

end architecture Bhv;
---------------------------------------------------------------------------------------------------