---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslAxis2ArrayTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;
--use work.CslAxiPkg.all;
use work.CslDmaPkg.all;
use work.CslDmaTypePkg.all;
use work.AxiStreamPkg.all;
--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslAxis2ArrayTb is
end CslAxis2ArrayTb;
---------------------------------------------------------------------------------------------------
architecture behavior of CslAxis2ArrayTb is 

   --Inputs
   signal clk_i               : sl                    := '0'; --! internal clock signal bus
   signal rst_i               : sl                    := '0'; --! internal reset signal bus
   
   constant TPD_G             : time                  := 1 ns;
   constant PIPELINE_G        : natural               := 1;
   constant BRAM_G            : boolean               := true;
   constant AWIDTH_G          : positive              := 8;
   constant THRESHOLD_G       : positive              := 30;
   constant TUSER_NORMAL_G    : boolean               := false; 
   constant TID_WIDTH_G       : positive              := 8; 
   constant TDEST_WIDTH_G     : positive              := 8;
   constant TUSER_WIDTH_G     : positive              := 8;  
   constant BYTES_SLV_G       : positive              := 4;
   constant BYTES_MST_G       : positive              := 16;
   constant SIZE_G            : positive              := 8;
   constant SIZE1_G           : positive              := 8;
   
   constant SLAVE_AXI_CONFIG_G : AxiStreamConfigType := (
      TSTRB_EN_C    => true,
      TDATA_BYTES_C => BYTES_SLV_G,
      TDEST_BITS_C  => TDEST_WIDTH_G,
      TID_BITS_C    => TID_WIDTH_G,
      TKEEP_MODE_C  => TKEEP_NORMAL_C,
      TUSER_BITS_C  => TUSER_WIDTH_G,
      TUSER_MODE_C  => TUSER_LAST_C
   );

   constant MASTER_AXI_CONFIG_G : AxiStreamConfigType := (
      TSTRB_EN_C    => true,
      TDATA_BYTES_C => BYTES_MST_G,
      TDEST_BITS_C  => TDEST_WIDTH_G,
      TID_BITS_C    => TID_WIDTH_G,
      TKEEP_MODE_C  => TKEEP_NORMAL_C,
      TUSER_BITS_C  => TUSER_WIDTH_G,
      TUSER_MODE_C  => TUSER_LAST_C
   );

   signal axisWriteMaster_i   : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal axisWriteSlave_o    : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   signal axisWriteSlave1_o   : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   
   signal mAxisMaster         : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal mAxisSlave          : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   signal mAxisMaster1        : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal mAxisSlave1         : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   
   signal axisReadMaster_o    : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal axisReadMaster1_o   : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal axisReadSlave_i     : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   signal axisReadSlave1_i    : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   
   signal dmaReadData         : slv(31 downto 0);
   signal dmaReadData1        : slv(31 downto 0);
   signal dataCnt : integer   := 1;
   constant NUM_OF_DATA_C     : integer := 200;
   
   signal req_i               : sl                    := '0';
   signal strobe_o            : sl;
   signal msg32Array_o        : Slv32Array(SIZE_G-1 downto 0);
   signal lenErr_o            : sl;
   
   signal strobe1_o           : sl;
   signal msg32Array1_o       : Slv32Array(SIZE_G-1 downto 0);
   signal lenErr1_o           : sl;
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant
   ---------------------------------------------------------------------------------------------------
begin
          
   uut_CslAxisFifo : entity work.CslAxisFifo
      generic map (
         TPD_G          => TPD_G,
         PIPELINE_G     => PIPELINE_G,
         BRAM_G         => BRAM_G, 
         AWIDTH_G       => AWIDTH_G,
         THRESHOLD_G    => THRESHOLD_G,
         TUSER_NORMAL_G => TUSER_NORMAL_G,
         TID_WIDTH_G    => TID_WIDTH_G,
         TDEST_WIDTH_G  => TDEST_WIDTH_G,
         TUSER_WIDTH_G  => TUSER_WIDTH_G,
         BYTES_SLV_G    => BYTES_SLV_G,
         BYTES_MST_G    => BYTES_MST_G)
      port map (
         sAxisClk_i     => clk_i,
         sAxisRst_i     => rst_i,
         sAxisMaster_i  => axisWriteMaster_i,
         sAxisSlave_o   => axisWriteSlave_o,
         mAxisClk_i     => clk_i,
         mAxisRst_i     => rst_i,
         mAxisMaster_o  => mAxisMaster,
         mAxisSlave_i   => mAxisSlave
      );
      
    uut1_CslAxisFifo : entity work.CslAxisFifo
      generic map (
         TPD_G          => TPD_G,
         PIPELINE_G     => PIPELINE_G,
         BRAM_G         => BRAM_G, 
         AWIDTH_G       => AWIDTH_G,
         THRESHOLD_G    => THRESHOLD_G,
         TUSER_NORMAL_G => TUSER_NORMAL_G,
         TDEST_WIDTH_G  => TDEST_WIDTH_G,
         TUSER_WIDTH_G  => TUSER_WIDTH_G,
         BYTES_SLV_G    => BYTES_MST_G,
         BYTES_MST_G    => BYTES_SLV_G)
      port map (
         sAxisClk_i     => clk_i,
         sAxisRst_i     => rst_i,
         sAxisMaster_i  => mAxisMaster,
         sAxisSlave_o   => mAxisSlave,
         mAxisClk_i     => clk_i,
         mAxisRst_i     => rst_i,
         mAxisMaster_o  => axisReadMaster_o,
         mAxisSlave_i   => axisReadSlave_i
      );
      
   uut_CslAxis2Array : entity work.CslAxis2Array
      generic map (
         TPD_G          => TPD_G,
         SIZE_G         => SIZE_G,
         REQ_MODE_G     => true)
      port map (
         clk_i          => clk_i,
         rst_i          => rst_i,
         req_i          => req_i,
         axisMaster_i   => axisReadMaster_o,
         axisSlave_o    => axisReadSlave_i,
         strobe_o       => strobe_o,
         msg32Array_o   => msg32Array_o,
         lenErr_o       => lenErr_o
      );


   uut_AxiStreamFifoV2 : entity work.AxiStreamFifoV2
      generic map (
         TPD_G                  => TPD_G,
         INT_PIPE_STAGES_G      => 1,
         PIPE_STAGES_G          => 1,
         SLAVE_READY_EN_G       => true,
         VALID_THOLD_G          => 1,
         VALID_BURST_MODE_G     => false,
         BRAM_EN_G              => false,
         GEN_SYNC_FIFO_G        => false,
         CASCADE_SIZE_G         => 1,
         FIFO_ADDR_WIDTH_G      => AWIDTH_G,
         FIFO_FIXED_THRESH_G    => false,
         FIFO_PAUSE_THRESH_G    => 250,
         INT_WIDTH_SELECT_G     => "WIDE",
         INT_DATA_WIDTH_G       => 16,
         LAST_FIFO_ADDR_WIDTH_G => 0,
         CASCADE_PAUSE_SEL_G    => 0,
         SLAVE_AXI_CONFIG_G     => SLAVE_AXI_CONFIG_G,
         MASTER_AXI_CONFIG_G    => MASTER_AXI_CONFIG_G)
      port map (
         sAxisClk        => clk_i,
         sAxisRst        => rst_i,
         sAxisMaster     => axisWriteMaster_i,
         sAxisSlave      => axisWriteSlave1_o,
         sAxisCtrl       => open,
         fifoPauseThresh => (others => '1'),
         fifoWrCnt       => open,
         mAxisClk        => clk_i,
         mAxisRst        => rst_i,
         mAxisMaster     => mAxisMaster1,
         mAxisSlave      => mAxisSlave1,
         mTLastTUser     => open
      );
      
   uut1_AxiStreamFifoV2 : entity work.AxiStreamFifoV2
      generic map (
         TPD_G                  => TPD_G,
         INT_PIPE_STAGES_G      => 1,
         PIPE_STAGES_G          => 1,
         SLAVE_READY_EN_G       => true,
         VALID_THOLD_G          => 1,
         VALID_BURST_MODE_G     => false,
         BRAM_EN_G              => false,
         GEN_SYNC_FIFO_G        => false,
         CASCADE_SIZE_G         => 1,
         FIFO_ADDR_WIDTH_G      => AWIDTH_G,
         FIFO_FIXED_THRESH_G    => false,
         FIFO_PAUSE_THRESH_G    => 250,
         INT_WIDTH_SELECT_G     => "WIDE",
         INT_DATA_WIDTH_G       => 16,
         LAST_FIFO_ADDR_WIDTH_G => 0,
         CASCADE_PAUSE_SEL_G    => 0,
         SLAVE_AXI_CONFIG_G     => MASTER_AXI_CONFIG_G,
         MASTER_AXI_CONFIG_G    => SLAVE_AXI_CONFIG_G)
      port map (
         sAxisClk        => clk_i,
         sAxisRst        => rst_i,
         sAxisMaster     => mAxisMaster1,
         sAxisSlave      => mAxisSlave1,
         sAxisCtrl       => open,
         fifoPauseThresh => (others => '1'),
         fifoWrCnt       => open,
         mAxisClk        => clk_i,
         mAxisRst        => rst_i,
         mAxisMaster     => axisReadMaster1_o,
         mAxisSlave      => axisReadSlave1_i,
         mTLastTUser     => open
      );
      
   uut1_CslAxis2Array : entity work.CslAxis2Array
      generic map (
         TPD_G          => TPD_G,
         SIZE_G         => SIZE1_G,
         REQ_MODE_G     => false)
      port map (
         clk_i          => clk_i,
         rst_i          => rst_i,
         req_i          => '0',
         axisMaster_i   => axisReadMaster1_o,
         axisSlave_o    => axisReadSlave1_i,
         strobe_o       => strobe1_o,
         msg32Array_o   => msg32Array1_o,
         lenErr_o       => lenErr1_o
      );
      
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0';
      wait for T_C/2;
      clk_i <= '1';
      wait for T_C/2;
   end process;
   
   dmaReadData    <= axisReadMaster_o.tdata(31 downto 0);
   dmaReadData1   <= axisReadMaster1_o.tdata(31 downto 0);
   
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
     
      axisWriteMaster_i.tValid            <= '0';

      wait until clk_i = '1';
      wait for TPD_G;

      -- input signals
      rst_i <= '0';
      wait for T_C * 10;
      
      -- reset
      rst_i <= '1';
      wait for T_C * 10;
      
      rst_i <= '0';
      wait for T_C * 10;
 
      dataCnt <= 1;
      
      while (dataCnt <= NUM_OF_DATA_C) loop

         axisWriteMaster_i.tValid             <= '1';
         
         if (axisWriteSlave1_o.tReady = '1') then
            dataCnt                                <= dataCnt + 1;
            axisWriteMaster_i.tData(31 downto 0)   <= slv(to_unsigned(dataCnt, 32));
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*4 -1 downto TUSER_WIDTH_G*3)   <= slv(to_unsigned(dataCnt+4, TUSER_WIDTH_G));
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*3 -1 downto TUSER_WIDTH_G*2)   <= slv(to_unsigned(dataCnt+3, TUSER_WIDTH_G));
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*2 -1 downto TUSER_WIDTH_G)     <= slv(to_unsigned(dataCnt+2, TUSER_WIDTH_G));
            axisWriteMaster_i.tUser(TUSER_WIDTH_G-1 downto 0)                    <= slv(to_unsigned(dataCnt+1, TUSER_WIDTH_G));
            wait for T_C * 1;
         else
            wait for T_C * 1;
         end if;
         
      end loop;
      
      axisWriteMaster_i.tValid             <= '0';
      dataCnt <= 1;
      wait for T_C * 500;
      
      req_i    <= '1';
      wait for T_C * 1;
      
      for i in 0 to 50 loop
         req_i       <= '0';
         wait until strobe_o = '1';
         req_i    <= '1';
         wait for T_C;
      end loop;

      wait for T_C * 1000;

      ---- Stop simulation
      assert false report "SIMULATION COMPLEATED" severity failure;
      
   end process;
end;
---------------------------------------------------------------------------------------------------
