---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslAxisFifoTb.vhd
---------------------------------------------------------------------------------------------------
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.numeric_std.all; 
use ieee.math_real.all; 
use work.CslStdRtlPkg.all; 
use work.CslAxiPkg.all; 
use work.CslDmaTypePkg.all; 
--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslAxisFifoTb is
end CslAxisFifoTb; 
---------------------------------------------------------------------------------------------------
architecture behavior of CslAxisFifoTb is 
   
   --Inputs
   signal clk_i : sl := '0'; --! internal clock signal bus
   signal rst_i : sl := '0'; --! internal reset signal bus
   
   constant TPD_G          : time     := 1 ns; 
   constant PIPELINE_G     : natural  := 1; 
   constant BRAM_G         : boolean  := true; 
   constant AWIDTH_G       : positive := 8; 
   constant THRESHOLD_G    : positive := 30; 
   constant TUSER_NORMAL_G : boolean  := false; 
   constant TID_WIDTH_G    : positive := 8; 
   constant TDEST_WIDTH_G  : positive := 8; 
   constant TUSER_WIDTH_G  : positive := 8; 
   constant BYTES_SLV_G    : positive := 4; 
   constant BYTES_MST_G    : positive := 16; 
   
   
   signal axisWriteMaster_i  : AxiStreamMasterType    := AXI_STREAM_MASTER_INIT_C; 
   signal axisWriteSlave_o   : AxiStreamSlaveType     := AXI_STREAM_SLAVE_INIT_C; 
   
   signal mAxisMaster        : AxiStreamMasterType    := AXI_STREAM_MASTER_INIT_C; 
   signal mAxisSlave         : AxiStreamSlaveType     := AXI_STREAM_SLAVE_INIT_C; 
   
   signal axisReadMaster_o   : AxiStreamMasterType    := AXI_STREAM_MASTER_INIT_C; 
   signal axisReadSlave_i    : AxiStreamSlaveType     := AXI_STREAM_SLAVE_INIT_C; 
   
   signal dmaReadData     : slv(31 downto 0); 
   signal dataCnt         : integer := 1; 
   constant NUM_OF_DATA_C : integer := 200; 
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant
                                   ---------------------------------------------------------------------------------------------------
begin
   
   uut_CslAxisFifo : entity work.CslAxisFifo
      generic map (
         TPD_G          => TPD_G,
         PIPELINE_G     => PIPELINE_G,
         BRAM_G         => BRAM_G, 
         AWIDTH_G       => AWIDTH_G,
         THRESHOLD_G    => THRESHOLD_G,
         TUSER_NORMAL_G => TUSER_NORMAL_G,
         TID_WIDTH_G    => TID_WIDTH_G,
         TDEST_WIDTH_G  => TDEST_WIDTH_G,
         TUSER_WIDTH_G  => TUSER_WIDTH_G,
         BYTES_SLV_G    => BYTES_SLV_G,
         BYTES_MST_G    => BYTES_MST_G)
      port map (
         sAxisClk_i    => clk_i,
         sAxisRst_i    => rst_i,
         sAxisMaster_i => axisWriteMaster_i,
         sAxisSlave_o  => axisWriteSlave_o,
         mAxisClk_i    => clk_i,
         mAxisRst_i    => rst_i,
         mAxisMaster_o => mAxisMaster,
         mAxisSlave_i  => mAxisSlave
      ); 
   
   uut1_CslAxisFifo : entity work.CslAxisFifo
      generic map (
         TPD_G          => TPD_G,
         PIPELINE_G     => PIPELINE_G,
         BRAM_G         => BRAM_G, 
         AWIDTH_G       => AWIDTH_G,
         THRESHOLD_G    => THRESHOLD_G,
         TUSER_NORMAL_G => TUSER_NORMAL_G,
         TDEST_WIDTH_G  => TDEST_WIDTH_G,
         TUSER_WIDTH_G  => TUSER_WIDTH_G,
         BYTES_SLV_G    => BYTES_MST_G,
         BYTES_MST_G    => BYTES_SLV_G)
      port map (
         sAxisClk_i    => clk_i,
         sAxisRst_i    => rst_i,
         sAxisMaster_i => mAxisMaster,
         sAxisSlave_o  => mAxisSlave,
         mAxisClk_i    => clk_i,
         mAxisRst_i    => rst_i,
         mAxisMaster_o => axisReadMaster_o,
         mAxisSlave_i  => axisReadSlave_i
      ); 
   
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0'; 
      wait for T_C/2; 
      clk_i <= '1'; 
      wait for T_C/2; 
   end process; 
   
   dmaReadData  <= axisReadMaster_o.tdata(31 downto 0); 
   
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
      
      axisWriteMaster_i.tValid <= '0'; 
      axisReadSlave_i.tReady   <= '0'; 
      
      wait until clk_i = '1'; 
      wait for TPD_G; 
      
      -- input signals
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      -- reset
      rst_i <= '1'; 
      wait for T_C * 10; 
      
      rst_i <= '0'; 
      wait for T_C * 10; 
      
      dataCnt <= 1; 
      
      while (dataCnt <= NUM_OF_DATA_C) loop
         
         axisWriteMaster_i.tValid <= '1'; 
         
         if (axisWriteSlave_o.tReady = '1') then
            dataCnt                                                            <= dataCnt + 1; 
            axisWriteMaster_i.tData(31 downto 0)                               <= slv(to_unsigned(dataCnt, 32)); 
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*4 -1 downto TUSER_WIDTH_G*3) <= slv(to_unsigned(dataCnt+4, TUSER_WIDTH_G)); 
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*3 -1 downto TUSER_WIDTH_G*2) <= slv(to_unsigned(dataCnt+3, TUSER_WIDTH_G)); 
            axisWriteMaster_i.tUser(TUSER_WIDTH_G*2 -1 downto TUSER_WIDTH_G)   <= slv(to_unsigned(dataCnt+2, TUSER_WIDTH_G)); 
            axisWriteMaster_i.tUser(TUSER_WIDTH_G-1 downto 0)                  <= slv(to_unsigned(dataCnt+1, TUSER_WIDTH_G)); 
            wait for T_C * 1; 
         else
            wait for T_C * 1; 
         end if; 
         
      end loop; 
      
      axisWriteMaster_i.tValid <= '0'; 
      dataCnt                  <= 1; 
      wait for T_C * 500; 
      
      axisReadSlave_i.tReady <= '1'; 
      wait for T_C * 1; 
      
      while (dataCnt <= NUM_OF_DATA_C) loop
         
         -- Check out read channel
         if (axisReadMaster_o.tValid = '1') then
            
            if (dmaReadData /= slv(to_unsigned(dataCnt, 32))) then
               wait for T_C; 
            end if; 
            
            dataCnt <= dataCnt + 1; 
         end if; 
         
         wait for T_C * 1; 
         
      end loop; 
      
      wait for T_C * 1000; 
      
      ---- Stop simulation
      assert false report "SIMULATION COMPLEATED" severity failure; 
      
   end process; 
end; 
---------------------------------------------------------------------------------------------------
