---------------------------------------------------------------------------------------------------
--! @brief  
--! @details  
--!
--! @author
--!
--! @date January 12 2018 created
--!
--! @version 
--!
--!
--! @file CslDmaTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;
use work.CslAxiPkg.all;
--use work.CslDmaPkg.all;
use work.CslDmaTypePkg.all;
--use work.AxiStreamPkg.all;
--! @brief
--! @details
--! @author
---------------------------------------------------------------------------------------------------
entity CslAxisResizeTb is
end CslAxisResizeTb;
---------------------------------------------------------------------------------------------------
architecture behavior of CslAxisResizeTb is 
   


   --Inputs
   signal clk_i               : sl                    := '0'; --! internal clock signal bus
   signal rst_i               : sl                    := '0'; --! internal reset signal bus
   
   constant TPD_G             : time                  := 1 ns;
   constant TID_WIDTH_G       : positive              := 8; 
   constant TDEST_WIDTH_G     : positive              := 8;
   constant TUSER_WIDTH_G     : positive              := 8;  
   constant BYTES_SLV_G       : positive              := 8;
   constant BYTES_MST_G       : positive              := 8;

   signal axisWriteMaster_i   : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal axisWriteSlave_o    : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   
   signal mAxisMaster         : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal mAxisSlave          : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;

   
   signal axisReadMaster_o    : AxiStreamMasterType   := AXI_STREAM_MASTER_INIT_C;
   signal axisReadSlave_i     : AxiStreamSlaveType    := AXI_STREAM_SLAVE_INIT_C;
   
   signal dmaReadData         : slv(31 downto 0);
   signal dataCnt : integer := 1;
   constant NUM_OF_DATA_C : integer := 498;
   
   -- Clock period definitions 
   constant T_C : time := 10.0 ns; --! Clock period constant
   ---------------------------------------------------------------------------------------------------
begin
          
   uut1_CslAxisResize : entity work.CslAxisResize
      generic map (
         TPD_G         => TPD_G,
         TID_WIDTH_G   => TID_WIDTH_G,
         TDEST_WIDTH_G => TDEST_WIDTH_G,
         TUSER_WIDTH_G => TUSER_WIDTH_G,
         BYTES_SLV_G   => BYTES_SLV_G,
         BYTES_MST_G   => BYTES_MST_G)
      port map (
         clk_i         => clk_i,
         rst_i         => rst_i,
         sAxisMaster_i => axisWriteMaster_i,
         sAxisSlave_o  => axisWriteSlave_o,
         mAxisMaster_o => mAxisMaster,
         mAxisSlave_i  => mAxisSlave
      );
      
   uut2_CslAxisResize : entity work.CslAxisResize
      generic map (
         TPD_G         => TPD_G,
         TID_WIDTH_G   => TID_WIDTH_G,
         TDEST_WIDTH_G => TDEST_WIDTH_G,
         TUSER_WIDTH_G => TUSER_WIDTH_G,
         BYTES_SLV_G   => BYTES_MST_G,
         BYTES_MST_G   => BYTES_SLV_G)
      port map (
         clk_i         => clk_i,
         rst_i         => rst_i,
         sAxisMaster_i => mAxisMaster,
         sAxisSlave_o  => mAxisSlave,
         mAxisMaster_o => axisReadMaster_o,
         mAxisSlave_i  => axisReadSlave_i
      );

   

  
   --! @brief Clock procces 
   --! @details Clock signal generator
   --! @param[in]  T_C
   --! @param[out] clk_i
   p_SyncClkGen : process
   begin
      clk_i <= '0';
      wait for T_C/2;
      clk_i <= '1';
      wait for T_C/2;
   end process;
   
   dmaReadData    <= axisReadMaster_o.tdata(31 downto 0);
   
   --! @brief 
   --! @details 
   --! @param[in] 
   --! @param[out]
   p_Sim : process
   begin
     
      axisWriteMaster_i.tValid            <= '0';
      axisReadSlave_i.tReady              <= '1';

      wait until clk_i = '1';
      wait for TPD_G;

      -- input signals
      rst_i <= '0';
      wait for T_C * 10;
      
      axisWriteMaster_i.tValid            <= '1';
      
      -- reset
      rst_i <= '1';
      wait for T_C * 10;
      
      rst_i <= '0';
      wait for T_C * 10;
 
      dataCnt <= 1;
      
      while (dataCnt < NUM_OF_DATA_C) loop

         axisWriteMaster_i.tValid             <= '1';
         
         if (axisWriteSlave_o.tReady = '1') then
            dataCnt                                <= dataCnt + 1;
            axisWriteMaster_i.tData(31 downto 0)   <= slv(to_unsigned(dataCnt, 32));
            wait for T_C * 1;
         else
            wait for T_C * 1;
         end if;
         
      end loop;
      
      axisWriteMaster_i.tValid             <= '0';

      wait for T_C * 1000;
      
   end process;
end;
---------------------------------------------------------------------------------------------------
