---------------------------------------------------------------------------------------------------
--! @brief Powerup Reset module test bench 
--! @details
--!
--!
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date October 12 2018 created
--! @date October 15 2018 last modify
--!
--! @version v0.1
--!
--!
--! @file PowerupRstTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;

use work.CslStdRtlPkg.all;
use work.AxiStreamPkg.all;
---------------------------------------------------------------------------------------------------
entity  WatchdogTb is
end entity WatchdogTb;
---------------------------------------------------------------------------------------------------
architecture Bhv of WatchdogTb is
  -----------------------------
  -- Port Signals 
  -----------------------------
   -- Clock reset
   constant CLK_PERIOD_C      : time         := 10 ns;      --! clock period
   constant CLK_DELAY_C       : time         := 0 ns;       --! clock delay at startup 
   --
   constant TPD_C             : time         := 1 ns;       --! TPD constant
   constant WIDTH_G           : positive     := 16;         --! hold time for PowerupRst module
   --
   signal   clk_i             : sl:= '0';                   --! clock input
   signal   en_i              : sl:= '0';                   --! enable watchdog signal
   signal   rst_i             : sl:= '1';                   --! reset input signal
   signal   wdRst_i           : sl:= '0';
   signal   time_i            : slv(WIDTH_G-1 downto 0) := (others => '0');
   signal   tout_o            : sl;
---------------------------------------------------------------------------------------------------
begin  -- architecture Bhv

   -----------------------------
   -- component instantiation 
   -----------------------------
   uut_PowerupRst : entity work.Watchdog
      generic map (
         TPD_G   => TPD_C,
         WIDTH_G => WIDTH_G
      )
      port map (
         clk_i   => clk_i,
         rst_i   => rst_i,
         en_i    => en_i,
         wdRst_i => wdRst_i,
         time_i  => time_i,
         tout_o  => tout_o
      );


   -- Clock
	process is
   begin
      wait for CLK_DELAY_C;
      while (true) loop
         clk_i <= not clk_i;
         wait for CLK_PERIOD_C/2.0;
      end loop;
   end process;
   
   -- Reset
	process is
   begin
      rst_i <= not rst_i;
      wait for 10000*CLK_PERIOD_C/2.0;
   end process;
   
   -- enable watchdog
	process is
   begin
      en_i <= not en_i;
      wait for 20000*CLK_PERIOD_C/2.0;
   end process;
   
   -- uut simulation process
   StimuliProcess : process
   begin 
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      time_i      <= std_logic_vector(to_unsigned(800, WIDTH_G));
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      time_i      <= std_logic_vector(to_unsigned(2000, WIDTH_G));
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
      wait for 1000*CLK_PERIOD_C;
      wdRst_i     <= '1';
      wait for CLK_PERIOD_C;
      wdRst_i     <= '0';
   end process StimuliProcess;
  
end architecture Bhv;
---------------------------------------------------------------------------------------------------