---------------------------------------------------------------------------------------------------
--! @brief  Single Port RAM test bench
--! @details The test bench simulate the module with various input signals value,
--! lenghts and timing.
--! 
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date January 8 2018 created
--! @date March 28 2018 last modify
--!
--! @version v1.0
--!
--! @par Modifications:
--! jkokalj, January 8 2018: Created
--! jkokalj, March 28 2018: design iteration
--!
--! @file CslSpRAMTb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;

--! @brief  Single Port RAM test bench
--! @details The test bench simulate the module with various input signals value,
--! lenghts and timing.
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
---------------------------------------------------------------------------------------------------
entity CslSpRAMTb is
   generic(
      TPD_G          : time     := 1 ns;
      ADR_W_G        : integer := 4;
      DAT_W_G        : integer := 8 ;
      PIPELINE_G     : natural := 1;
      WRITE_FIRST_G  : boolean := true;
      RAM_STYLE_G    : string  := "block"
    );
end CslSpRAMTb;
 
architecture behavior of CslSpRAMTb is 
 
   --Inputs
   signal clka : std_logic := '0';
   signal rsta : std_logic := '0';
   signal wea : std_logic := '0';
   signal addra : std_logic_vector(ADR_W_G-1 downto 0) := (others => '0');
   signal dina : std_logic_vector(DAT_W_G-1 downto 0) := (others => '0');

 	--Outputs
   signal doutB_WR_SYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutB_RD_SYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutB_WR_ASYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutB_RD_ASYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutB_WR_SYNC_REG : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutB_RD_SYNC_REG : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_WR_SYNC_REG : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_RD_SYNC_REG : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_WR_SYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_RD_SYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_WR_ASYNC : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutD_RD_ASYNC : std_logic_vector(DAT_W_G-1 downto 0);

   -- Clock period definitions
   constant CLKA_I_PERIOD_C : time := 10 ns;
 
begin
 
	-- Instantiate the Unit Under Test (UUT)
   uut1:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 1,
         WRITE_FIRST_G  => true,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_WR_SYNC
      );
   
   uut2:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 1,
         WRITE_FIRST_G  => false,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_RD_SYNC
      );
      
   uut3:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 0,
         WRITE_FIRST_G  => true,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_WR_ASYNC
      );

   uut4:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 0,
         WRITE_FIRST_G  => false,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_RD_ASYNC
      );
   
   -- Instantiate the Unit Under Test (UUT)
   uut11:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 2,
         WRITE_FIRST_G  => true,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_WR_SYNC_REG
      );
   
   uut12:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 2,
         WRITE_FIRST_G  => false,
         BRAM_G         => true
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutB_RD_SYNC_REG
      );
      
   uut13:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 2,
         WRITE_FIRST_G  => true,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_WR_SYNC_REG
      );

   uut14:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 2,
         WRITE_FIRST_G  => false,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_RD_SYNC_REG
      );
	-- Instantiate the Unit Under Test (UUT)
   uut5:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 1,
         WRITE_FIRST_G  => true,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_WR_SYNC
      );
   
   uut6:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 1,
         WRITE_FIRST_G  => false,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_RD_SYNC
      );
      
   uut7:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 0,
         WRITE_FIRST_G  => true,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_WR_ASYNC
      );

   uut8:entity work.CslSpRAM 
      generic map(
         ADR_W_G        => ADR_W_G,
         DAT_W_G        => DAT_W_G,
         PIPELINE_G     => 0,
         WRITE_FIRST_G  => false,
         BRAM_G         => false
      )
      port map (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => doutD_RD_ASYNC
      );      
   -- Clock process definitions
   clka_process :process
   begin
		clka <= '0';
		wait for CLKA_I_PERIOD_C/2;
		clka <= '1';
		wait for CLKA_I_PERIOD_C/2;
   end process;
   
   -- Clock process definitions
   rsta_process :process
   begin
		rsta <= '0';
		wait for CLKA_I_PERIOD_C*25;
		rsta <= '1';
		wait for CLKA_I_PERIOD_C*5;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin		
      wait for CLKA_I_PERIOD_C;
      addra <="0001";
      dina  <="00001111";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0010";
      dina  <="00001111";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0011";
      dina  <="00011110";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0100";
      dina  <="00111100";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0010";
      dina  <="01111000";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0011";
      dina  <="11110000";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0100";
      dina  <="11100000";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0001";
      dina  <="11000000";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0001";
      dina  <="00001111";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0010";
      dina  <="00001111";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0011";
      dina  <="00011110";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0100";
      dina  <="00111100";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0010";
      dina  <="01111000";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0011";
      dina  <="11110000";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0100";
      dina  <="11100000";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C;
      addra <="0001";
      dina  <="11000000";
      wea   <= '1';
      wait for CLKA_I_PERIOD_C;
      addra <="0011";
      dina  <="11000000";
      wea   <= '0';
      wait for CLKA_I_PERIOD_C*2;
   end process;
end;
