---------------------------------------------------------------------------------------------------
--! @brief True Dual port RAM test bench
--! @details   The test bench simulates the module with various input signals value,
--! lenghts and timing.
--!
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
--!
--! @date Januar 23 2018 created
--! @date Januar 23 2018 last modify
--!
--! @version v1.0
--!
--! @par Modifications:
--! jkokalj, Januar 23 2018: Created
--!
--! @file CslTrueDpRAM_Tb.vhd
---------------------------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.CslStdRtlPkg.all;

--! @brief True Dual port RAM test bench
--! @details   The test bench simulates the module with various input signals value,
--! lenghts and timing.
--! @author Jernej Kokalj, Cosylab (jernej.kokalj@cosylab.com)
---------------------------------------------------------------------------------------------------
entity CslTrueDpRAMTb is
   generic(
      TPD_G          : time      := 1 ns;
      ADR_W_G        : integer   := 4;      --! addresa width
      DAT_W_G        : integer   := 8 ;     --! data width
      PIPELINE_G     : positive  := 2;      --! delay in clock cycles of output data
      WRITE_FIRST_G  : boolean   := false    --! true=> write first mode, false=> read first mode
    );
end CslTrueDpRAMTb;
---------------------------------------------------------------------------------------------------
architecture behavior of CslTrueDpRAMTb is 

   --Inputs
   signal clka : std_logic := '0';
   signal rsta : std_logic := '0';
   signal wea : std_logic := '0';
   signal addra : std_logic_vector(ADR_W_G-1 downto 0) := (others => '0');
   signal dina : std_logic_vector(DAT_W_G-1 downto 0) := (others => '0');
   signal clkb : std_logic := '0';
   signal rstb : std_logic := '0';
   signal web : std_logic := '0';
   signal addrb : std_logic_vector(ADR_W_G-1 downto 0) := (others => '0');
   signal dinb : std_logic_vector(DAT_W_G-1 downto 0) := (others => '0');

 	--Outputs
   signal douta_WR : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutb_WR : std_logic_vector(DAT_W_G-1 downto 0);
   signal douta_WR1 : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutb_WR1 : std_logic_vector(DAT_W_G-1 downto 0);
   signal douta_RD : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutb_RD : std_logic_vector(DAT_W_G-1 downto 0);
   signal douta_RD1 : std_logic_vector(DAT_W_G-1 downto 0);
   signal doutb_RD1 : std_logic_vector(DAT_W_G-1 downto 0);
   
   -- Clock period definitions
   constant clka_period_C : time := 15 ns;
   constant clkb_period_C : time := 10 ns;
 
begin
 
	-- Instantiate the Unit Under Test (UUT)
   uut: entity work.CslTrueDpRAM 
      generic map(
         TPD_G          => TPD_G,
         ADR_W_G        => ADR_W_G, --! addresa width
         DAT_W_G        => DAT_W_G, --! data width
         PIPELINE_G     => 1,       --! delay in clock cycles of output data
         WRITE_FIRST_G  => true     --! true=> write first mode, false=> read first mode
      )
      PORT MAP (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => douta_WR,
         clkb => clkb,
         rstb => rstb,
         web => web,
         addrb => addrb,
         dinb => dinb,
         doutb => doutb_WR
      );
      
	-- Instantiate the Unit Under Test (UUT)
   uut1: entity work.CslTrueDpRAM 
      generic map(
         TPD_G          => TPD_G,
         ADR_W_G        => ADR_W_G, --! addresa width
         DAT_W_G        => DAT_W_G, --! data width
         PIPELINE_G     => 1,       --! delay in clock cycles of output data
         WRITE_FIRST_G  => false    --! true=> write first mode, false=> read first mode
      )
      PORT MAP (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => douta_RD,
         clkb => clkb,
         rstb => rstb,
         web => web,
         addrb => addrb,
         dinb => dinb,
         doutb => doutb_RD
      );
      
   	-- Instantiate the Unit Under Test (UUT)
   uut2: entity work.CslTrueDpRAM 
      generic map(
         TPD_G          => TPD_G,
         ADR_W_G        => ADR_W_G, --! addresa width
         DAT_W_G        => DAT_W_G, --! data width
         PIPELINE_G     => 2,       --! delay in clock cycles of output data
         WRITE_FIRST_G  => true     --! true=> write first mode, false=> read first mode
      )
      PORT MAP (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => douta_WR1,
         clkb => clkb,
         rstb => rstb,
         web => web,
         addrb => addrb,
         dinb => dinb,
         doutb => doutb_WR1
      );
      
	-- Instantiate the Unit Under Test (UUT)
   uut3: entity work.CslTrueDpRAM 
      generic map(
         TPD_G          => TPD_G,
         ADR_W_G        => ADR_W_G, --! addresa width
         DAT_W_G        => DAT_W_G, --! data width
         PIPELINE_G     => 2,       --! delay in clock cycles of output data
         WRITE_FIRST_G  => false    --! true=> write first mode, false=> read first mode
      )
      PORT MAP (
         clka => clka,
         rsta => rsta,
         wea => wea,
         addra => addra,
         dina => dina,
         douta => douta_RD1,
         clkb => clkb,
         rstb => rstb,
         web => web,
         addrb => addrb,
         dinb => dinb,
         doutb => doutb_RD1
      );

   --! @brief Clock A procces 
   --! @details Clock signal generator
   --! @param[in]  clka_period_C
   --! @param[out] clka
   clka_process :process
   begin
		clka <= '0';
		wait for clka_period_C/2;
		clka <= '1';
		wait for clka_period_C/2;
   end process;

   --! @brief Clock B procces 
   --! @details Clock signal generator
   --! @param[in]  clkb_period_C
   --! @param[out] clkb 
   clkb_process :process
   begin
		clkb <= '0';
		wait for clkb_period_C/2;
		clkb <= '1';
		wait for clkb_period_C/2;
   end process;
 

   --! @brief Simulation procces 
   --! @details Simulation with various signals value, length and timings
   --! @param[in] 
   --! @param[out] addra, dina, wea
   stim_procA: process
   begin		
   wait for clka_period_C;
      addra <="0001";
      dina  <="00001111";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0010";
      dina  <="00001111";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0011";
      dina  <="00011110";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0100";
      dina  <="00111100";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0010";
      dina  <="01111000";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0011";
      dina  <="11110000";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0100";
      dina  <="11100000";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0001";
      dina  <="11000000";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0001";
      dina  <="00001111";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0010";
      dina  <="00001111";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0011";
      dina  <="00011110";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0100";
      dina  <="00111100";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0010";
      dina  <="01111000";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0011";
      dina  <="11110000";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0100";
      dina  <="11100000";
      wea   <= '0';
      wait for clka_period_C;
      addra <="0001";
      dina  <="11000000";
      wea   <= '1';
      wait for clka_period_C;
      addra <="0011";
      dina  <="11000000";
      wea   <= '0';
      wait for clka_period_C*2;
   end process;
   
   --! @brief Simulation procces 
   --! @details Simulation with various signals value, length and timings
   --! @param[in] 
   --! @param[out] addrb, dinb, web
   stim_procB: process
   begin		
      wait for clkb_period_C;
      addrb <="0100";
      dinb  <="11100000";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0001";
      dinb  <="11000000";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0001";
      dinb  <="00001111";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0010";
      dinb  <="00001111";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0011";
      dinb  <="00011110";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0100";
      dinb  <="00111100";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0010";
      dinb  <="01111000";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0011";
      dinb  <="11110000";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0100";
      dinb  <="11100000";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0001";
      dinb  <="11000000";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0011";
      dinb  <="11000000";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0001";
      dinb  <="00001111";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0010";
      dinb  <="00001111";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0011";
      dinb  <="00011110";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0100";
      dinb  <="00111100";
      web   <= '0';
      wait for clkb_period_C;
      addrb <="0010";
      dinb  <="01111000";
      web   <= '1';
      wait for clkb_period_C;
      addrb <="0011";
      dinb  <="11110000";
      web   <= '0';
      wait for clkb_period_C*2;
   end process;

end;
---------------------------------------------------------------------------------------------------