----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 03/16/2022 05:03:39 PM
-- Design Name: 
-- Module Name: CMUX_Simulator - rtl
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use work.CslStdRtlPkg.all;
use ieee.numeric_std.all;
use work.CslAxiPkg.all;
use work.FiberPkg.all;
--
use work.CmuCorePkg.all;

library unisim;
use unisim.vcomponents.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity CMUX_Simulator is
generic
(
  --  TPD_G                                   : time      := 1 ns;
    SOF_CHAR_G        : std_logic_vector(7 downto 0)     := x"1C";
    EOF_CHAR_G        : std_logic_vector(7 downto 0)     := x"FE";  
    EXAMPLE_CONFIG_INDEPENDENT_LANES        : integer   := 1;
    EXAMPLE_LANE_WITH_START_CHAR            : integer   := 0;    -- specifies lane with unique start frame ch
    EXAMPLE_WORDS_IN_BRAM                   : integer   := 512;  -- specifies amount of data in BRAM
    EXAMPLE_SIM_GTRESET_SPEEDUP             : string    := "FALSE";    -- simulation setting for GT SecureIP model
    STABLE_CLOCK_PERIOD                     : integer   := 10;
    EXAMPLE_USE_CHIPSCOPE                   : integer   := 1           -- Set to 1 to use Chipscope to drive resets
);

Port ( 
   -- Q3_CLK1_GTREFCLK_PAD_N_IN               : in   std_logic;
 --   Q3_CLK1_GTREFCLK_PAD_P_IN               : in   std_logic;
    DRP_CLK_IN                              : in   std_logic;
    SYS_RST                                 : in   std_logic;
    
--    DRP_CLK_IN_P                           : in   std_logic;
--    DRP_CLK_IN_N                           : in   std_logic;
--   GTTX_RESET_IN                           : in   std_logic;
--   GTRX_RESET_IN                           : in   std_logic;
--   CPLL_RESET_IN                           : in   std_logic; 
--   QPLL_RESET_IN                           : in   std_logic;
--   TRACK_DATA_OUT                          : out  std_logic;
    RXN_IN                                  : in   std_logic_vector(3 downto 0);
    RXP_IN                                  : in   std_logic_vector(3 downto 0);
   -- TXN_OUT                                 : out  std_logic_vector(3 downto 0);
   -- TXP_OUT                                 : out  std_logic_vector(3 downto 0);
    GT_CORR_DATA                            : out  std_logic_vector(15 downto 0);
    GT_CORR_CHAR                            : out  std_logic_vector(1 downto 0)
--    SFP1_TX_DISABLE                         : out   std_logic;
--    SFP2_TX_DISABLE                         : out   std_logic;
--    SFP3_TX_DISABLE                         : out   std_logic;
--    SFP4_TX_DISABLE                         : out   std_logic;
    
--    USER_CLOCK_P                            : in    std_logic;
--    USER_CLOCK_N                            : in    std_logic;
--    USER_SMA_CLOCK_P                        : out    std_logic;
--    USER_SMA_CLOCK_N                        : out    std_logic    
);
end CMUX_Simulator;

architecture top_level of CMUX_Simulator is

   constant TPD_G : time      := 1 ns;
   --! internal signals
   signal startRst      : sl := '1';
   signal rstAll        : sl; 
   signal rstGtRx       : sl; 
   signal clrSimErr     : sl;   
   signal sysRst        : sl;
   signal injCrc        : sl;
   signal injLen        : sl;
   signal injId         : sl;
   signal rstTs         : sl;   
   signal injCrcRE      : sl;
   signal injLenRE      : sl;
   signal injIdRE       : sl;
   signal rstTsRE       : sl;
   signal cntID         : slv(7 downto 0) := (others => '0');
   signal gtRefClkDiv2  : sl;
   signal sysClk        : sl;
   signal gtRefClk      : sl;
   signal gtRx_po       : GtArray(1 downto 0)   := (others => GT_INIT_C);
   signal gtTx_po       : GtArray(1 downto 0)   := (others => GT_INIT_C); 
   signal gtTxCor_po    : GtArray(1 downto 0)   := (others => GT_INIT_C); 

   signal rstCnt  : unsigned(15 downto 0):=(others=>'0');
   
   --!
   
   --! TX SFED
   signal strobe         : sl;  
   signal sfedMsg        : Slv32Array(7 downto 0)  := (others => x"00000000");
   signal sfedMsgStat    : slv(31 downto 0):= x"0000003d";   
   --
   signal sfedAxisMaster : AxiStreamMasterType := AXI_STREAM_MASTER_INIT_C;
   signal sfedAxisSlave  : AxiStreamSlaveType;
   --
   signal hpdIdle         : sl; 
   signal sfedPeriod      : slv(bitSize(ITU_PERIOD_C)-1 downto 0) := (others => '0');
   
   -- ITU Message verificator
   signal ituStat  : SfedStatType;            
   signal ituMsg   : ItuMsgType;
   signal fecStat  : SfedStatType; 
   signal fecMsg   : ItuMsgType; 
   
   -- Internal logic
   signal stallTstmp          : sl:='0';  
   signal stallStrb           : sl:='0';  
   signal tsCounter           : unsigned(63 downto 0);
   signal strCounter          : unsigned(bitsize(ITU_PERIOD_C)-1 downto 0);
   signal strRegCounter       : unsigned(31 downto 0);
   
   -- Configuration request
   signal  reqCmd  : slv(31 downto 0);
   signal  reqDev  : slv(31 downto 0);   
   signal  reqAddr : slv(31 downto 0);
   signal  reqLen  : slv(31 downto 0);
   signal  reqData : slv(31 downto 0);
   signal  stbAutoEn   : sl;
   signal  reqStbVio   : sl;
   signal  reqStbAuto  : sl;
   signal  reqStb      : sl;
   
   -- Configuration response
   signal  rspCmd  : slv(31 downto 0);
   signal  rspAddr : slv(31 downto 0);
   signal  rspLen  : slv(31 downto 0);
   signal  rspStat : slv(31 downto 0); 
   signal  rspData : Slv32Array(15 downto 0);   

   -- VIO signals
   signal  rstClr   : slv(1 downto 0);
   signal  inject   : slv(4 downto 0);
   signal  fecStatReg : slv(31 downto 0);
   signal  ituStatReg : slv(31 downto 0);   
   
   -- Config msg
   signal fecStrobe    : sl := '0';
   signal fecDrop      : sl := '0';
   signal fecConfigMsg : Slv32Array(23 downto 0) := (others => x"00000000");
   signal fecConfigRsp : Slv32Array(23 downto 0) := (others => x"00000000"); 

 
begin

 -----------------------------
   -- 1 HPD 
   ----------------------------- 
   u2_InjectErrFiber : entity work.InjectErrFiber
      generic map (
         TPD_G      => TPD_G,
         SOF_CHAR_G => SOF_CHAR_G,
         EOF_CHAR_G => EOF_CHAR_G
      )
      port map (
         clk_i             => sysClk,
         rst_i             => sysRst,
         en_i              => '1',
         injId_i           => injIdRE,
         id_i              => cntID,
         injCrc_i          => injCrcRE,
         injLen_i          => injLenRE,
         gtTxData_i        => gtTx_po(1).data(15 downto 8),
         gtTxChar_i        => gtTx_po(1).char(1),
         gtClkCorrEn_i     => gtTx_po(1).clkCorrEn,
         gtCorruptTxData_o => gtTxCor_po(1).data(15 downto 8),
         gtCorruptTxChar_o => gtTxCor_po(1).char(1),
         gtClkCorrEn_o     => gtTxCor_po(1).clkCorrEn
      );
 
   -----------------------------
   -- 1 LPD 
   -----------------------------  
   u3_InjectErrFiber : entity work.InjectErrFiber
      generic map (
         TPD_G      => TPD_G,
         SOF_CHAR_G => SOF_CHAR_G,
         EOF_CHAR_G => EOF_CHAR_G
      )
      port map (
         clk_i             => sysClk,
         rst_i             => sysRst,
         en_i              => '1',
         injId_i           => injIdRE,
         id_i              => cntID,
         injCrc_i          => injCrcRE,
         injLen_i          => injLenRE,
         gtTxData_i        => gtTx_po(1).data(7 downto 0),
         gtTxChar_i        => gtTx_po(1).char(0),
         gtClkCorrEn_i     => gtTx_po(1).clkCorrEn,
         gtCorruptTxData_o => gtTxCor_po(1).data(7 downto 0),
         gtCorruptTxChar_o => gtTxCor_po(1).char(0),
         gtClkCorrEn_o     => open
      );
      
 ------------------------------------------------------------------------
   -- CMU Tester
   ------------------------------------------------------------------------   
   
   -----------------------------------------------------------
   -- Make SFED messages
   -----------------------------------------------------------
   sfedPeriod <= toSlv(ITU_PERIOD_C, bitsize(ITU_PERIOD_C));   
   
   -- Proces for generatig input array message and message strobes
   process(DRP_CLK_IN,SYS_RST)
   begin
      if rising_edge(DRP_CLK_IN) then
         if SYS_RST = '1' then
            sfedMsg <= (others => x"00000000");
            tsCounter     <= (others => '0');
            strCounter    <= (others => '0');
            strRegCounter <= (others => '0');
         else
            if stallTstmp='0' then
               tsCounter <= tsCounter + 1;
            end if;
            strCounter <= strCounter + 1;
            strRegCounter <= strRegCounter + 1;

            -- Generate Reg strobe every 0.5s
            if (strRegCounter = x"2FAf080") then
               strRegCounter <=(others => '0');
               reqStbAuto <= '1';
            else 
               reqStbAuto <= '0';           
            end if;
            
            -- Generate SFED message strobe
            if (strCounter = ITU_PERIOD_C-1 and stallStrb = '0') then
               strCounter <=(others => '0');
               strobe <= '1';
            else 
               strobe <= '0';           
            end if;
            ---------------------------------------------------------------------------------------------
            sfedMsg(0) <= sfedMsgStat;
            for i in 1 to 2 loop
               sfedMsg(i) <= slv(tsCounter + to_unsigned(i,32));
            end loop;
            for i in 3 to 4 loop
               sfedMsg(i) <= x"0000" & slv(tsCounter + to_unsigned(i,16));
            end loop;
            sfedMsg(5) <= (others => '0');               
            sfedMsg(6) <= slv(tsCounter(31 downto 0));
            ---------------------------------------------------------------------------------------------
         end if;
      end if;
   end process;


-----------------------------------------------------------
   -- 1 x SFED link
   -----------------------------------------------------------
   u0_MsgStreamTx : entity work.MsgStreamTx
      generic map (
         TPD_G  => TPD_G,
         SIZE_G => 8)
      port map (
         clk_i        => sysClk,
         rst_i        => sysRst,
         strobe_i     => strobe,
         msg32Array_i => sfedMsg,
         full_i       => '0',
         axisMaster_o => sfedAxisMaster,
         axisSlave_i  => sfedAxisSlave,
         drop_o       => open);
         
         
   --! FiberLinkTx module to transmit the messages over GT fiber 
   u_FiberLinkMapTx : entity work.FiberLinkMapTx
      generic map (
         TPD_G            => TPD_G,
         HPD_DATA_WIDTH_G => 4,
         HPD_MAX_SIZE_G   => 8,
         LPD_DATA_WIDTH_G => 4,
         LPD_PIPES_G      => 1,
         LPD_MAX_SIZE_G   => 4)
      port map (
         clk_i             => sysClk,
         rst_i             => sysRst,
         hpdTxAxisMaster_i => sfedAxisMaster,
         hpdTxAxisSlave_o  => sfedAxisSlave,
         hpdTxPktFull_o    => open,
         hpdTxErr_o        => open,
         hpdIdle_o         => hpdIdle,
         -- LPD not used but has to be there to handle comma 0x00BC 
         lpdTxAxisMaster_i => (others => AXI_STREAM_MASTER_INIT_C),
         gtDataTx_o          => gtTx_po(0).data,
         gtCharTx_o          => gtTx_po(0).char);
         
   --! driving Clock correction enable signal from Lpd and Hpd Idle signals
  -- gtTx_po(0).clkCorrEn  <= hpdIdle;
    GT_CORR_DATA <= gtTx_po(0).data;
    GT_CORR_CHAR <= gtTx_po(0).char;

end top_level;
