----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 02/03/2022 05:03:37 PM
-- Design Name: 
-- Module Name: CmuxSim - rtl
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
--  CMUX Simulator with following traffic : SFED, DDS, ITM .. 
--     
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use work.CslStdRtlPkg.all;
use ieee.numeric_std.all;
use work.CslAxiPkg.all;
use work.FiberPkg.all;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
library UNISIM;
use UNISIM.VComponents.all;

entity CmuxSim is
   generic (
      --TPD_G             : time                    := 1 ns;
      EXTR_R_POL_G      : boolean                 := true;
      HOLD_TIME_G       : positive                := 1000
      );
   
   port (     

              Q3_CLK1_GTREFCLK_PAD_N_IN     : in    std_logic;
              Q3_CLK1_GTREFCLK_PAD_P_IN     : in    std_logic;                
              SYSCLKP_I                     : in    std_logic;     
              SYSCLKN_I                     : in    std_logic;          
              RXN_IN                        : in    std_logic;
              RXP_IN                        : in    std_logic;
              TXN_OUT                       : out   std_logic;
              TXP_OUT                       : out   std_logic ;     
              SFP1_TX_DISABLE               : out   std_logic;
              SFP2_TX_DISABLE               : out   std_logic;
              SFP3_TX_DISABLE               : out   std_logic;
              SFP4_TX_DISABLE               : out   std_logic;
              SFP1_LOS                      : in    std_logic;
              SFP2_LOS                      : in    std_logic;
              SFP3_LOS                      : in    std_logic;
              SFP4_LOS                      : in    std_logic;
              SFP1_MOD_DETECT               : in    std_logic;
              SFP2_MOD_DETECT               : in    std_logic;
              SFP3_MOD_DETECT               : in    std_logic;
              SFP4_MOD_DETECT               : in    std_logic;
              LED                           : out std_logic_vector (7 downto 0);
              USER_CLOCK_P                  : in    std_logic;
              USER_CLOCK_N                  : in    std_logic;
              USER_SMA_CLOCK_P              : out    std_logic;
              USER_SMA_CLOCK_N              : out    std_logic              
      );
end CmuxSim;

architecture rtl of CmuxSim is

component gthwizard_CmuxSim is
port
(
    SOFT_RESET_TX_IN                        : in   std_logic;
    SOFT_RESET_RX_IN                        : in   std_logic;
    DONT_RESET_ON_DATA_ERROR_IN             : in   std_logic;
    Q3_CLK1_GTREFCLK_PAD_N_IN               : in   std_logic;
    Q3_CLK1_GTREFCLK_PAD_P_IN               : in   std_logic;

    GT0_TX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_RX_FSM_RESET_DONE_OUT               : out  std_logic;
    GT0_DATA_VALID_IN                       : in   std_logic;
 
    GT0_TXUSRCLK_OUT                        : out  std_logic;
    GT0_TXUSRCLK2_OUT                       : out  std_logic;
    GT0_RXUSRCLK_OUT                        : out  std_logic;
    GT0_RXUSRCLK2_OUT                       : out  std_logic;

    --_________________________________________________________________________
    --GT0  (X1Y12)
    --____________________________CHANNEL PORTS________________________________
    ---------------------------- Channel - DRP Ports  --------------------------
    gt0_drpaddr_in                          : in   std_logic_vector(8 downto 0);
    gt0_drpdi_in                            : in   std_logic_vector(15 downto 0);
    gt0_drpdo_out                           : out  std_logic_vector(15 downto 0);
    gt0_drpen_in                            : in   std_logic;
    gt0_drprdy_out                          : out  std_logic;
    gt0_drpwe_in                            : in   std_logic;
    --------------------- RX Initialization and Reset Ports --------------------
    gt0_eyescanreset_in                     : in   std_logic;
    gt0_rxuserrdy_in                        : in   std_logic;
    -------------------------- RX Margin Analysis Ports ------------------------
    gt0_eyescandataerror_out                : out  std_logic;
    gt0_eyescantrigger_in                   : in   std_logic;
    ------------------- Receive Ports - Clock Correction Ports -----------------
    gt0_rxclkcorcnt_out                     : out  std_logic_vector(1 downto 0);
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt0_dmonitorout_out                     : out  std_logic_vector(14 downto 0);
    ------------------ Receive Ports - FPGA RX interface Ports -----------------
    gt0_rxdata_out                          : out  std_logic_vector(31 downto 0);
    ------------------ Receive Ports - RX 8B/10B Decoder Ports -----------------
    gt0_rxdisperr_out                       : out  std_logic_vector(3 downto 0);
    gt0_rxnotintable_out                    : out  std_logic_vector(3 downto 0);
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt0_gthrxn_in                           : in   std_logic;
    --------------------- Receive Ports - RX Equalizer Ports -------------------
    gt0_rxmonitorout_out                    : out  std_logic_vector(6 downto 0);
    gt0_rxmonitorsel_in                     : in   std_logic_vector(1 downto 0);
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt0_rxoutclkfabric_out                  : out  std_logic;
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt0_gtrxreset_in                        : in   std_logic;
    ------------------- Receive Ports - RX8B/10B Decoder Ports -----------------
    gt0_rxcharisk_out                       : out  std_logic_vector(3 downto 0);
    ------------------------ Receive Ports -RX AFE Ports -----------------------
    gt0_gthrxp_in                           : in   std_logic;
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt0_rxresetdone_out                     : out  std_logic;
    --------------------- TX Initialization and Reset Ports --------------------
    gt0_gttxreset_in                        : in   std_logic;
    gt0_txuserrdy_in                        : in   std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    gt0_txdata_in                           : in   std_logic_vector(31 downto 0);
    ---------------- Transmit Ports - TX Driver and OOB signaling --------------
    gt0_gthtxn_out                          : out  std_logic;
    gt0_gthtxp_out                          : out  std_logic;
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt0_txoutclkfabric_out                  : out  std_logic;
    gt0_txoutclkpcs_out                     : out  std_logic;
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt0_txresetdone_out                     : out  std_logic;
    ----------- Transmit Transmit Ports - 8b10b Encoder Control Ports ----------
    gt0_txcharisk_in                        : in   std_logic_vector(3 downto 0);

    --____________________________COMMON PORTS________________________________
    GT0_QPLLLOCK_OUT : out std_logic;
    GT0_QPLLREFCLKLOST_OUT  : out std_logic;
     GT0_QPLLOUTCLK_OUT  : out std_logic;
     GT0_QPLLOUTREFCLK_OUT : out std_logic;
       sysclk_in        : in std_logic     
);
end component;

signal start : std_logic;
--signal errors_occured : std_logic;
signal tied_to_ground_i, tied_to_vcc_i : std_logic;
signal tied_to_ground_8_0_i : std_logic_vector(8 downto 0);
signal tied_to_ground_15_0_i : std_logic_vector(15 downto 0);
signal drpclk_in : std_logic:= '0';
signal GT0_DATA_VALID_IN : std_logic;
signal gt0_txdata_in, gt0_rxdata_out, rx_data_from_sync : std_logic_vector(31 downto 0);
signal gt0_txcharisk_in, gt0_rxcharisk_out, gt0_rxcharisk_from_sync : std_logic_vector(1 downto 0);
signal gt0_txresetdone_out, gt0_rxresetdone_out : std_logic;
signal GT0_TX_FSM_RESET_DONE_OUT, GT0_RX_FSM_RESET_DONE_OUT : std_logic;
signal GT0_RXUSRCLK2_OUT, GT0_RXUSRCLK_OUT, GT0_TXUSRCLK2_OUT, GT0_TXUSRCLK_OUT : std_logic;
signal DRP_CLK_IN : std_logic;
signal TX_CLK_CORR_DATA:  std_logic_vector(31 downto 0):= (others => '1');
signal TX_CLK_CORR_CHAR : std_logic_vector (3 downto 0):= (others => '1');
signal CLK156,userclock :std_logic;
signal sig_Q3_CLK1_GTREFCLK_PAD_P_IN, sig_Q3_CLK1_GTREFCLK_PAD_N_IN : std_logic;
begin

 --disable optics if module is NOT present

  SFP1_TX_DISABLE <= '0'; 
  SFP2_TX_DISABLE <= '0';
  SFP3_TX_DISABLE <= '0';
  SFP4_TX_DISABLE <=  '0';
 
-- -- assign GPIO LEDS for SFP+ module user visual status 

    LED(0) <= SFP1_MOD_DETECT ; -- DS2 (right side of LED array)
    LED(1) <= SFP2_MOD_DETECT ; -- DS3
    LED(2) <= SFP3_MOD_DETECT ; -- DS4
    LED(3) <= SFP4_MOD_DETECT ; -- DS5  

    LED(4) <= SFP1_LOS ; -- DS6
    LED(5) <= SFP2_LOS ; -- DS7
    LED(6) <= SFP3_LOS ; -- DS8
    LED(7) <= SFP4_LOS ; -- DS9 (left side of LED array)
    
tied_to_ground_i <= '0';
tied_to_vcc_i    <= '1';
tied_to_ground_8_0_i <= (others => '0');
tied_to_ground_15_0_i <= (others => '0');

gtwizard_0_i : gthwizard_CmuxSim
port map
(
    SOFT_RESET_TX_IN                 => tied_to_ground_i,
    SOFT_RESET_RX_IN                 => tied_to_ground_i,     
    DONT_RESET_ON_DATA_ERROR_IN      => tied_to_ground_i, 
    Q3_CLK1_GTREFCLK_PAD_N_IN        => Q3_CLK1_GTREFCLK_PAD_N_IN, --sig_Q3_CLK1_GTREFCLK_PAD_N_IN,      
    Q3_CLK1_GTREFCLK_PAD_P_IN        => Q3_CLK1_GTREFCLK_PAD_P_IN, --sig_Q3_CLK1_GTREFCLK_PAD_P_IN,        

    GT0_TX_FSM_RESET_DONE_OUT       => GT0_TX_FSM_RESET_DONE_OUT,         
    GT0_RX_FSM_RESET_DONE_OUT       => GT0_RX_FSM_RESET_DONE_OUT,        
    GT0_DATA_VALID_IN               =>   gt0_rxresetdone_out,          
 
    GT0_TXUSRCLK_OUT                => GT0_TXUSRCLK_OUT,                 
    GT0_TXUSRCLK2_OUT               => GT0_TXUSRCLK2_OUT,                
    GT0_RXUSRCLK_OUT                => GT0_RXUSRCLK_OUT,                
    GT0_RXUSRCLK2_OUT               => GT0_RXUSRCLK2_OUT,           
    --_________________________________________________________________________
    --GT0  (X1Y12)
    --____________________________CHANNEL PORTS________________________________
    ---------------------------- Channel - DRP Ports  --------------------------
    gt0_drpaddr_in                  => tied_to_ground_8_0_i,             
    gt0_drpdi_in                    => tied_to_ground_15_0_i,         
    gt0_drpdo_out                   => open,        
    gt0_drpen_in                    => tied_to_ground_i,               
    gt0_drprdy_out                  => open,          
    gt0_drpwe_in                    =>      tied_to_ground_i,              
    --------------------- RX Initialization and Reset Ports --------------------
    gt0_eyescanreset_in             =>      tied_to_ground_i,         
    gt0_rxuserrdy_in                =>      tied_to_vcc_i,     
    -------------------------- RX Margin Analysis Ports ------------------------
    gt0_eyescandataerror_out        =>      open,        
    gt0_eyescantrigger_in           =>      tied_to_ground_i,         
    ------------------- Receive Ports - Clock Correction Ports -----------------
    gt0_rxclkcorcnt_out             =>       open,       
    ------------------- Receive Ports - Digital Monitor Ports ------------------
    gt0_dmonitorout_out             =>      open,  
    ------------------ Receive Ports - FPGA RX Interface Ports -----------------
    gt0_rxdata_out                  =>      gt0_rxdata_out, 
    ------------------ Receive Ports - RX 8B/10B Dsecoder Ports -----------------
  --  gt0_rxcharisk_out               =>      gt0_rxcharisk_out(1 downto 0),   
    gt0_rxdisperr_out               =>      open,  
    gt0_rxnotintable_out            =>      open,        
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt0_gthrxn_in                   =>      RXN_IN,                       
    -------------------- Receive Ports - RX Equailizer Ports -------------------
    gt0_rxmonitorout_out             =>   open,       
    gt0_rxmonitorsel_in              =>   (others => '0'),    
    --------------- Receive Ports - RX Fabric Output Control Ports -------------
    gt0_rxoutclkfabric_out          =>      open, 
    ------------- Receive Ports - RX Initialization and Reset Ports ------------
    gt0_gtrxreset_in                =>      tied_to_ground_i,             
    ------------------------ Receive Ports - RX AFE Ports ----------------------
    gt0_gthrxp_in                   =>      RXP_IN,      
    -------------- Receive Ports -RX Initialization and Reset Ports ------------
    gt0_rxresetdone_out             =>      gt0_rxresetdone_out,          
    --------------------- TX Initialization and Reset Ports --------------------
    gt0_gttxreset_in                =>      tied_to_ground_i,                   
    gt0_txuserrdy_in                =>      tied_to_vcc_i,                 
    ------------------ Transmit Ports - FPGA TX Interface Ports ----------------
    gt0_txdata_in                   =>      TX_CLK_CORR_DATA,          
    --------------- Transmit Ports - TX Configurable Driver Ports --------------
    gt0_gthtxn_out                  =>      TXN_OUT,           
    gt0_gthtxp_out                  =>      TXP_OUT,         
    ----------- Transmit Ports - TX Fabric Clock Output Control Ports ----------
    gt0_txoutclkfabric_out          =>      open,  
    gt0_txoutclkpcs_out             =>      open,  
    ------------- Transmit Ports - TX Initialization and Reset Ports -----------
    gt0_txresetdone_out             =>      gt0_txresetdone_out,        
    ------------------ Transmit Ports - TX 8B/10B Encoder Ports ----------------
    gt0_txcharisk_in                =>      TX_CLK_CORR_CHAR,      
    --____________________________COMMON PORTS________________________________
    GT0_QPLLLOCK_OUT                => open,
    GT0_QPLLREFCLKLOST_OUT          => open,   
    GT0_QPLLOUTCLK_OUT              => open,
    GT0_QPLLOUTREFCLK_OUT           => open,    
    sysclk_in                       => drpclk_in
   );

--//////////////////////////////////////////////////////////////
--//
--// VC709 SFP REFCLK using SMA connectors J25 & J26
--//   USER_SMA_CLOCK_P is SMA J31 (LOC = AJ32)
--//   USER_SMA_CLOCK_N is SMA J32 (LOC = AK32)
--// User needs to connect SMA cables from J31 to J25 
--// User needs to connect SMA cables from J32 to J26
--//
--//////////////////////////////////////////////////////////////
--//
--// Create 156.25MHz USER_SMA_CLOCK from USER_CLOCK input
--// Use for SFP+ REFCLK to drive SFP electrical loopback modules
--// LVDS inputs (Vcco = 1.8V) IBUFDS instantiation


-- IBUFGDS: Differential Global Clock Input Buffer
-- 7 Series
-- Xilinx HDL Libraries Guide, version 14.7
IBUFGDS_CLK156 : IBUFGDS
generic map (
DIFF_TERM => FALSE, -- Differential Termination
IBUF_LOW_PWR => TRUE, -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
IOSTANDARD => "DEFAULT")
port map (
    O => userclock, -- Clock buffer output
    I => USER_CLOCK_P, -- Diff_p clock buffer input (connect directly to top-level port)
    IB =>USER_CLOCK_N -- Diff_n clock buffer input (connect directly to top-level port)
);
-- End of IBUFGDS_inst instantiation

userclock_BUFG : BUFG 
port map 
(    
      I    => userclock,
      O    => CLK156 
);    

GT_CLKP_BUFG : BUFG 
port map 
(    
      I    => Q3_CLK1_GTREFCLK_PAD_P_IN,
      O    => sig_Q3_CLK1_GTREFCLK_PAD_P_IN 
);    
GT_CLKN_BUFG : BUFG 
port map 
(    
      I    => Q3_CLK1_GTREFCLK_PAD_N_IN,
      O    => sig_Q3_CLK1_GTREFCLK_PAD_N_IN 
);    

--// Clean up clock using ODDR flip flop for best duty cycle clock output
--ODDR   u10 (.D1(1'b1), .D2(1'b0), .CE(1'b1), .C( CLK156 ), .Q( MYCLK ) );

--// Use LVDS output buffer to create GTH REFCLK for SFP testing
 
--OBUFDS u11 (.I( MYCLK ), .O( USER_SMA_CLOCK_P ), .OB( USER_SMA_CLOCK_N ) );


-- OBUFDS: Differential Output Buffer
-- 7 Series
-- Xilinx HDL Libraries Guide, version 14.7
OBUFDS_inst : OBUFDS
generic map (
    IOSTANDARD => "DEFAULT", -- Specify the output I/O standard
    SLEW => "SLOW") -- Specify the output slew rate
port map (
    O => USER_SMA_CLOCK_P, -- Diff_p output (connect directly to top-level port)
    OB => USER_SMA_CLOCK_N, -- Diff_n output (connect directly to top-level port)
    I => CLK156 -- Buffer input
);
-- End of OBUFDS_inst instantiation


IBUFDS_GTE2_inst : IBUFDS_GTE2
   generic map (
      CLKCM_CFG => TRUE,   -- Refer to Transceiver User Guide
      CLKRCV_TRST => TRUE, -- Refer to Transceiver User Guide
      CLKSWING_CFG => "11"  -- Refer to Transceiver User Guide
   )
  port map (
      O => open,      -- 1-bit output: Refer to Transceiver User Guide 
      ODIV2 => DRP_CLK_IN,            -- 1-bit output: Refer to Transceiver User Guide
      CEB => '0',               -- 1-bit input: Refer to Transceiver User Guide
      I => SYSCLKP_I,    -- 1-bit input: Refer to Transceiver User Guide
      IB => SYSCLKN_I    -- 1-bit input: Refer to Transceiver User Guide
   );

-- End of IBUFDS_GTE2_inst instantiatio

  DRP_CLK_BUFG : BUFG 
  port map 
   (    
       I    => DRP_CLK_IN,
       O    => drpclk_in 
   );    
       
-- IBUFGDS: Differential Global Clock Input Buffer
-- 7 Series
-- Xilinx HDL Libraries Guide, version 14.7
--BUFGDS_inst : IBUFGDS
--generic map (
--DIFF_TERM => FALSE, -- Differential Termination
--IBUF_LOW_PWR => TRUE, -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
--IOSTANDARD => "DEFAULT")
--port map (
--O =>drpclk_in, -- Clock buffer output
--I => SYSCLKP_I, -- Diff_p clock buffer input (connect directly to top-level port)
--IB =>SYSCLKN_I -- Diff_n clock buffer input (connect directly to top-level port)
--);
-- End of IBUFGDS_inst instantiation
end rtl;

