
from ctypes import *
from enum import Enum
from PyBta.PyFrame import PyBtaChannelId
from PyBta.PyFrame import PyBtaDataFormat
from PyBta.PyFrame import PyBtaUnit
from PyBta.PyFrame import PyBtaMetadataId



class BtaMetadataC(Structure):
    _fields_ = [
        ("id", c_uint32),
        ("data", c_void_p),
        ("dataLen", c_uint32),
    ]


class BtaChannel(Structure):
    _fields_ = [
        ("id", c_uint32),  # Type of data in this channel
        ("xRes", c_uint16),  # Number of columns
        ("yRes", c_uint16),  # Number of rows
        ("dataFormat", c_uint32),  # The bytestream in data needs to be casted to this format
        ("unit", c_uint32),  # Informative, for easier interpretation of the data
        ("integrationTime", c_uint32),  # Integration time at which the frame was captured in [us]
        ("modulationFrequency", c_uint32),  # Modulation frequency at which the frame was captured in [Hz]
        ("data", POINTER(c_uint8)),      # Pixels starting with upper left pixel. For nofBytesPerPixel bigger than 1 the first byte is the lowbyte
        ("dataLen", c_uint32),  # Length of the channel data in bytes (= xRes*yRes*bytesPerPixel)
        ("metadata", c_void_p),  # List of pointers to additional generic data
        ("metadataLen", c_uint32),  # The number of BTA_Metadata pointers stored in metadata
        ("lensIndex", c_uint8),
        ("flags", c_uint32),
        ("sequenceCounter", c_uint8),
        ("gain", c_float),
    ]

class BtaFrame(Structure):
    _fields_ = [
        ("firmwareVersionMajor", c_uint8),  # Firmware version major
        ("firmwareVersionMinor", c_uint8),  # Firmware version minor
        ("firmwareVersionNonFunc", c_uint8),  # Firmware version non functional
        ("mainTemp", c_float),  # Main-board/processor temperature sensor in degree Celcius
        ("ledTemp", c_float),  # Led-board temperature sensor in degree Celcius
        ("genericTemp", c_float),  # Additional Generic temperature sensor in degree Celcius
        ("frameCounter", c_uint32),  # Consecutive numbering of frames
        ("timeStamp", c_uint32),        # Time-stamp at which the frame was captured (in microseconds) (max 1h 11m 34s 967ms 295 us)
        ("channels", POINTER(POINTER(BtaChannel))),  # Data containing channelsLen Channel structs
        ("channelsLen", c_uint8),  # The number of BTA_Channel pointers stored in channels
    ]




