
from enum import Enum
from enum import IntEnum



class PyBtaFrameMode(IntEnum):
    CurrentConfig       = 0    # The sensors settings are not changed and data is passed through (according to device's current calculation/image mode settings)
    DistAmp             = 1    # Distance, Amplitude
    ZAmp                = 2    # Z coordinates, Amplitude
    DistAmpFlags        = 3    # Distance, Amplitude, Flags (see camera user manual)
    XYZ                 = 4    # X, Y, Z coordinates
    XYZAmp              = 5    # X, Y, Z coordinates, Amplitude
    DistAmpColor        = 6    # Distance, Amplitude, Color
    XYZAmpFlags         = 7    # X, Y, Z coordinates, Amplitude, Flags (see camera user manual)
    RawPhases           = 8    # Raw phase data untouched as delivered by the sensor
    Intensities         = 9    # Intensity (Ambient light)
    DistColor           = 10   # Distance, RGB data
    DistAmpBalance      = 11   # Distance, Amplitude, Balance (see camera user manual)
    XYZColor            = 12   # X, Y, Z coordinates, RGB data overlay (see camera user manual)
    Dist                = 13   # Distance
    DistConfExt         = 14   # Distance, Confidence (Different image processing behaviour, consult camera software manual)
    Amp                 = 15   # Amplitude
    RawdistAmp          = 16   # Distance raw, Amplitude
    RawPhasesExt        = 17   # Up to 8 channels of BTA_ChannelIdRawPhase
    RawQI               = 18   # BTA_ChannelIdRawI and BTA_ChannelIdRawQ
    XYZConfColor        = 19   # Cartesian, Confidence, RGB
    XYZAmpColorOverlay  = 20   # Cartesian, Amplitude, RGB, overlay
    DistAmpConf         = 21   # Distance, Amplitude, Confidence (see camera user manual)
    ChannelSelection    = 255, # Frame mode is defined by channel selection registers (see camera user manual)


class PyBtaChannelId(IntEnum):
    Unknown =        0x0
    Distance =       0x1
    Amplitude =      0x2
    X =              0x4
    Y =              0x8
    Z =             0x10
    Confidence =    0x20
    Flags =         0x40
    Phase0 =        0x80    # Used for raw sensor output (phase shift 0°)
    Phase90 =      0x100    # Used for raw sensor output (phase shift 90°)
    Phase180 =     0x200    # Used for raw sensor output (phase shift 180°)
    Phase270 =     0x400    # Used for raw sensor output (phase shift 270°)
    RawPhase =      0x81    # Used for raw sensor output (variable phase shift)
    RawQ =          0x82
    RawI =          0x83
    Test =         0x800
    Color =       0x1000
    RawDist =     0x4000   # Unfiltered unitless distance values (full unumbiguous range) scaled to full range of corresponding BTA_DataFormat (former BTA_ChannelIdPhase)
    GrayScale =   0x8000
    Balance =    0x10000
    StdDev =     0x20000

    Custom01 = 0x1000000
    Custom02 = 0x2000000
    Custom03 = 0x3000000
    Custom04 = 0x4000000
    Custom05 = 0x5000000
    Custom06 = 0x6000000
    Custom07 = 0x7000000
    Custom08 = 0x8000000
    Custom09 = 0x9000000
    Custom10 = 0xa000000

    
class PyBtaDataFormat(IntEnum):
    Unknown         = 0x0
    UInt8           = 0x11
    UInt16          = 0x12
    SInt16Mlx1C11S  = 0x62
    SInt16Mlx12S    = 0x72
    UInt16Mlx1C11U  = 0x82
    UInt16Mlx12U    = 0x92
    UInt32          = 0x14
    SInt16          = 0x22
    SInt32          = 0x24
    Float32         = 0x34
    Float64         = 0x38
    Rgb565          = 0x42
    Rgb24           = 0x43
    Jpeg            = 0x50
    Yuv422          = 0x52, #YUV
    Yuv444          = 0x53, #YUV
    Yuv444UYV       = 0x63, #UYV

    
class PyBtaUnit(IntEnum):
    UnitLess = 0
    Meter = 1
    Millimeter = 3


class PyBtaMetadataId(IntEnum):    
    ChessboardCorners     = 0xab8471f9,
    MlxMeta1              = 0xa720b906,
    MlxMeta2              = 0xa720b907,
    MlxTest               = 0xa720b908,
    MlxAdcData            = 0xa720b909,



class PyBtaMetadata:
    id = 0
    data = None


class PyBtaChannel:    
    id = 0
    xRes = 0
    yRes = 0
    dataFormat = 0
    unit = 0
    integrationTime = 0
    modulationFrequency = 0
    data = None
    metadata = None
    lensIndex = 0
    flags = 0
    sequenceCounter = 0
    gain = 0


class PyBtaFrame:
    firmwareVersionMajor = 0
    firmwareVersionMinor = 0
    firmwareVersionNonFunc = 0
    mainTemp = 0
    ledTemp = 0
    genericTemp = 0
    frameCounter = 0
    timeStamp = 0
    channels = None
    