/* Copyright (C) 2003-2007 Analog Devices, Inc. All Rights Reserved. */

/* CPLB table definitions for ADSP-BF561 Core A. */

.file_attr DualCoreMem="CoreA";

#if defined(__ADSPBF561__)
#include <sys/platform.h>
#include <cplb.h>

.section/DOUBLEANY cplb_data;

.align 4;
// The possible placements of stack in memory must be covered by a locked
// DCPLB to ensure it is always available for use by exception handlers.
_dcplbs_table:
.byte4=
  // L1 Data A & B, (set write-through bit to avoid 1st write exceptions)
  0xFF800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE | CPLB_LOCK | CPLB_WT),

  // L2 in the default LDFs is split into three blocks:
  //   Core B only - 32K 
  //   Core A only - 32K 
  //   Shared      - 64K 
  // The shared memory is set as uncached because there is no cache coherency.
  // The Core B descriptors are provided at the end of this table as they should
  // not normally be accessed from core A when using the default LDFs.

  // L2 SRAM - Core A (MEM_L2_SRAM_A/mem_a_l2_sram)
  0xFEB08000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB09000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0A000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0B000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0C000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0D000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0E000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB0F000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 

  // L2 SRAM - shared and uncached (MEM_L2_SRAM/mem_l2_shared)
  0xFEB10000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB11000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB12000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB13000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB14000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB15000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB16000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB17000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB18000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB19000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1A000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1B000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1C000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1D000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1E000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 
  0xFEB1F000, (PAGE_SIZE_4KB | CPLB_DNOCACHE), 

  0x20200000, (PAGE_SIZE_1MB | CPLB_DNOCACHE),  // Async Memory Bank 2 (Secnd)
  0x20100000, (PAGE_SIZE_1MB | CPLB_DNOCACHE),  // Async Memory Bank 1 (Prim B)
  0x20000000, (PAGE_SIZE_1MB | CPLB_DNOCACHE),  // Async Memory Bank 0

  // Up to 512 MB SDRAM memory space 
  // 64 MB populated on Ez-kit and default LDFs so this is described first
  // The default LDF contains a configuration for two external banks
  // each holding 32MB SDRAM. The default LDF uses one bank per core,
  // partitioned to segment data and program.
  // MEM_SDRAM0_BANK0 (8MB - defined in default LDF) potentially utilised as
  // stack, therefore locked.
  // MEM_SDRAM1_SHARED is shared to not cached.

  0x00000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE | CPLB_LOCK),  // MEM_SDRAM0_BANK0
  0x00400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE | CPLB_LOCK),  // MEM_SDRAM0_BANK0

  0x00800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK1
  0x00C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK1

  0x01000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK2
  0x01400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK2

  0x01C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK3
  0x01800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM0_BANK3

  0x02000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK0
  0x02400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK0

  0x02800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK1
  0x02C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK1

  0x03000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK2
  0x03400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK2

  0x03800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  // MEM_SDRAM1_BANK3

  0x03C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // MEM_SDRAM1_SHARED

  0x04000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x04400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x04800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x04C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x05000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x05400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x05800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x05C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x06000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x06400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x06800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x06C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x07000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x07400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x07800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x07C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x08000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x08400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x08800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x08C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x09000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x09400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x09800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x09C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x0a000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0a400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0a800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0aC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0b000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0b400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0b800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0bC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x0c000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0c400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0c800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0cC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0d000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0d400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0d800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0dC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x0e000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0e400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0e800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0eC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0f000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0f400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0f800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x0fC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x10000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x10400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x10800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x10C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x11000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x11400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x11800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x11C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x12000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x12400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x12800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x12C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x13000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x13400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x13800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x13C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x14000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x14400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x14800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x14C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x15000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x15400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x15800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x15C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x16000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x16400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x16800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x16C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x17000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x17400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x17800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x17C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x18000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x18400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x18800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x18C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x19000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x19400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x19800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x19C00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x1a000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1a400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1a800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1aC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1b000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1b400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1b800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1bC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x1c000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1c400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1c800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1cC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1d000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1d400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1d800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1dC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x1e000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1e400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1e800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1eC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1f000000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1f400000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1f800000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //
  0x1fC00000, (PAGE_SIZE_4MB | CPLB_DDOCACHE),  //

  0x2FC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // Async Mem Bank 3 (64MB)
  0x2F800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2F400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2F000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2EC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2E800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2E400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2E000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2DC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2D800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2D400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2D000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2CC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2C800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2C400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2C000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 

  0x2BC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // Async Mem Bank 2 (64MB)
  0x2B800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2B400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2B000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2AC00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2A800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2A400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x2A000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x29C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x29800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x29400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x29000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x28C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x28800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x28400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x28000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 

  0x27C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // Async Mem Bank 1 (64MB)
  0x27800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x27400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x27000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x26C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x26800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x26400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x26000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x25C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x25800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x25400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x25000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x24C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x24800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x24400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x24000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 

  0x23C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // Async Mem Bank 0 (64MB)
  0x23800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x23400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x23000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x22C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x22800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x22400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x22000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x21C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x21800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x21400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x21000000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x20C00000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x20800000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x20400000, (PAGE_SIZE_4MB | CPLB_DNOCACHE),  // 
  0x20300000, (PAGE_SIZE_1MB | CPLB_DNOCACHE),  // 

  // L2 SRAM - Core B (MEM_L2_SRAM_B/mem_b_l2_sram)
  0xFEB00000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB01000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB02000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB03000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB04000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB05000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB06000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 
  0xFEB07000, (PAGE_SIZE_4KB | CPLB_DDOCACHE), 

  0xffffffff; // end of section - termination
._dcplbs_table.end:


_icplbs_table:
.byte4=
  0xFFA00000, (PAGE_SIZE_1MB | CPLB_I_PAGE_MGMT), // L1 Code - Page Size = 1MB 
  0xFEB00000, (PAGE_SIZE_1MB | CPLB_IDOCACHE), // L2 SRAM
  0xEF000000, (PAGE_SIZE_1KB | CPLB_I_PAGE_MGMT), // Boot ROM

  0x20000000, (PAGE_SIZE_1MB | CPLB_IDOCACHE),  // Async Memory Bank 0

  0x01C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // EZ-Kit has 64 MB SDRAM
  0x01800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x01400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x01000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x00C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x00800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x00400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x00000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 

  0x02000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x02400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x02800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x02C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x03000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x03400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x03800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x03C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  // The remaining entries cover areas which are within the
  // ADSP-BF561 memory map, but are not likely to be supported by
  // the EZ-Kit.

  0x04000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 64-512 MB SDRAM
  0x04400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x04800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x04C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x05000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x05400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x05800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x05C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x06000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x06400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x06800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x06C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x07000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x07400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x07800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x07C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x08000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x08400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x08800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x08C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x09000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x09400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x09800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x09C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x0a000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0a400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0a800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0aC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0b000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0b400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0b800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0bC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x0c000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0c400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0c800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0cC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0d000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0d400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0d800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0dC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x0e000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0e400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0e800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0eC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0f000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0f400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0f800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x0fC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x10000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x10400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x10800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x10C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x11000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x11400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x11800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x11C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x12000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x12400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x12800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x12C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x13000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x13400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x13800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x13C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x14000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x14400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x14800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x14C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x15000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x15400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x15800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x15C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x16000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x16400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x16800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x16C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x17000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x17400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x17800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x17C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x18000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x18400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x18800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x18C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x19000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x19400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x19800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x19C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x1a000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1a400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1a800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1aC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1b000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1b400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1b800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1bC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x1c000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1c400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1c800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1cC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1d000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1d400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1d800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1dC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x1e000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1e400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1e800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1eC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1f000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1f400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1f800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //
  0x1fC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  //

  0x2FC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // Async Mem Bank 3 (64MB)
  0x2F800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2F400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2F000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2EC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2E800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2E400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2E000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2DC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2D800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2D400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2D000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2CC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2C800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2C400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2C000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 

  0x2BC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // Async Mem Bank 2 (64MB)
  0x2B800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2B400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2B000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2AC00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2A800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2A400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x2A000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x29C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x29800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x29400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x29000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x28C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x28800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x28400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x28000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 

  0x27C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // Async Mem Bank 1 (64MB)
  0x27800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x27400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x27000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x26C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x26800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x26400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x26000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x25C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x25800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x25400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x25000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x24C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x24800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x24400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x24000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 

  0x23C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // Async Mem Bank 0 (64MB)
  0x23800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x23400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x23000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x22C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x22800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x22400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x22000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x21C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x21800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x21400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x21000000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x20C00000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x20800000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x20400000, (PAGE_SIZE_4MB | CPLB_IDOCACHE),  // 
  0x20300000, (PAGE_SIZE_1MB | CPLB_IDOCACHE),  // 
  0x20200000, (PAGE_SIZE_1MB | CPLB_IDOCACHE),  // 
  0x20100000, (PAGE_SIZE_1MB | CPLB_IDOCACHE),  // 

  0xffffffff; // end of section - termination
._icplbs_table.end:


#else

.section/DOUBLEANY cplb_data;

.align 4;

_dcplbs_table:
_icplbs_table:
  .byte4=0xffffffff;
._dcplbs_table.end:
._icplbs_table.end:

#endif

.global _icplbs_table;
.type _icplbs_table, STT_OBJECT;
.global _dcplbs_table;
.type _dcplbs_table, STT_OBJECT;
